/*****************************************************************************/
/*                       Image processing functions                          */
/*  Header file : detection teacher position                                 */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2006                                                             */
/*****************************************************************************/

#include <deque>
#include "cv.h"

struct s_Position
{
   double x,y;
   double divx, divy;
   int Size;
};

typedef std::deque<s_Position> t_PositionTrajectory;

bool IsPrezentation(CvPoint2D32f *Points, int x, int y);
// test if point lies inside the presentation table
  // points representation   0 1
  //                         3 2

class c_BackGroundDetection
{
   int imWidth, imHeight;
   CvPoint2D32f BestPoints[4]; 
   
   IplImage *OCimgColor;
   IplImage *MaskImage;
   CvRect track_window;
   CvBox2D track_box;
   CvConnectedComp track_comp;
   t_PositionTrajectory PositionList;
   double oldx, oldy, olddivx, olddivy;
   public:
   c_BackGroundDetection() {  MaskImage=NULL;  OCimgColor=NULL; }
   ~c_BackGroundDetection()  
   { 
	   if (OCimgColor!=NULL) cvReleaseImage(&OCimgColor);  
	   if (MaskImage!=NULL) cvReleaseImage(&MaskImage);  
	   PositionList.clear();   
   }
   bool Init(unsigned char *img, int XSize, int YSize, CvPoint2D32f *Prezentation);
   bool Init(IplImage *imgColor, CvPoint2D32f *Prezentation);

   void Localize(IplImage *imgColor, double &x, double &y, double &divx, double &divy, int &Size, int Threshold);

   int GetPosition(int Pos, float &x, float &y);
   int GetTrajectorySize()  {   return (int)PositionList.size(); }
};