/*****************************************************************************/
/*                       Image processing functions                          */
/*  Source file : detection of the rectangle under perspective view          */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2006                                                             */
/*****************************************************************************/
#include "definitions.h"
#include "cv.h"

void ResizeTwice(unsigned char *source, unsigned char *dst, int Width, int Height);
// the final size of output image is twice smaller, rounded down

int LinesIntersection(s_Line *Line1, s_Line *Line2, CvPoint2D32f *Point);
// return intersection point [x,y]

float HypothesisTest(unsigned char *Image, int Width, int Height, CvPoint2D32f *Lines, int nr);
// compute coincidence of defined rectangle with binary image

class c_DetectRectangle
{

   t_LineList HorizontalLines;
   t_LineList VerticalLines;
   public:
   int Width, Height;
   int VerticalPoints, HorizontalPoints;
   void Init(int XSize, int YSize);
   void PutLine(float R, float Alpha, int Weight);
   void Sort();
   float FindRectangle(unsigned char *Image, int xsize, int ysize, CvPoint2D32f *BestA);
   float HypothesisTest(unsigned char *Image, int xsize, int ysize, CvPoint2D32f *Lines, int nr);
};
