/*****************************************************************************/
/*                       Image processing functions                          */
/*  Header file : image color corrections                                    */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2006                                                             */
/*****************************************************************************/

void AreaHistogramColorEqual(unsigned char *InputImage, unsigned char *OutputImage, unsigned char *Mask, int Width, int Height, int Color);
// Color - RGB, R, G, B, HSV - 0, 1, 2, 3, 4, determine which color part will be used for histogram computation
// Mask - mask image, which determine the selected area. 0 - nonselected, other - selected


void ContrastSetting(unsigned char *InputImage, unsigned char *OutputImage, int Width, int Height, int Min, int Max, int Color);
// Color - RGB, R, G, B, HSV - 0, 1, 2, 3, 4, determine which color part will be used for contrast computation
// Min, Max - determine minimal and maximal value of the color value which will be used in the output image
