/*****************************************************************************/
/*                       Image processing functions                          */
/*  Header file : image color corrections                                    */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2006                                                             */
/*****************************************************************************/


void BlendDeinterlace(unsigned char *InputImage, unsigned char *OutputImage, int Width, int Height, int Line);
// color image
void BlendDeinterlaceGrey(unsigned char *InputImage, unsigned char *OutputImage, int Width, int Height, int Line);
// grayscale image

void GrayScale(unsigned char *InputImage, unsigned char *OutputImage, int Width, int Height);

void DeinterlaceByDirection(unsigned char *InputImage, unsigned char *OutputImage, int Width, int Height, float offsetx, float offsety, int Line);

void Blending(unsigned char *InputImage, unsigned char *OutputImage, int Width, int Height);

void bilinear(const unsigned char *InputImage, int Width, int Height, float X, float Y, int &r, int &g, int &b);


void Dilate(unsigned char* src, unsigned char *dst, int XSize, int YSize);
void Erode(unsigned char* src, unsigned char *dst, int XSize, int YSize);

void GaussianMask(unsigned char* src, unsigned char *dst, int XSize, int YSize);
int Sobel(unsigned char* src, unsigned char *dst, int XSize, int YSize);
int Sobel(unsigned char* src, unsigned char *dst, int XSize, int YSize, int Thres);

int MexicanHat5x5(unsigned char* src, unsigned char *dst, int XSize, int YSize);
int MexicanHat7x7(unsigned char* src, unsigned char *dst, int XSize, int YSize, int Thres);
int MexicanHat9x9(unsigned char* src, unsigned char *dst, int XSize, int YSize);
// zero crossing edge detector
