/*****************************************************************************/
/*                       Image processing functions                          */
/*  Header file : hough transform for average value estimation               */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2005                                                             */
/*****************************************************************************/
#include <memory.h>
#ifdef DIGILIB
  #include "Image.h"
#endif
#include <stdio.h>


class c_HoughTransform
{
  public:
  int XSize;
  int YSize;
  int CentX, CentY;
  int Count;
  float Ratio;
  int *Array;
  long *XVal, *YVal;
   // constructor & destructor
   c_HoughTransform()  { Array=NULL; XVal=NULL; YVal=NULL; Count=0; }
   ~c_HoughTransform() {
     if (Array!=NULL) delete [] Array;
     if (XVal!=NULL) delete [] XVal;
     if (YVal!=NULL) delete [] YVal;
   }
   // copy constructor
   c_HoughTransform(const c_HoughTransform &Hough)
   {
      Count=Hough.Count;
      XSize=Hough.XSize;
      YSize=Hough.YSize;
      if (Hough.XVal!=NULL)
      {
         XVal=new long[XSize*YSize];
         memcpy(XVal,Hough.XVal, XSize*YSize*sizeof(long));
      }
      if (Hough.YVal!=NULL)
      {
         YVal=new long[XSize*YSize];
         memcpy(YVal,Hough.YVal, XSize*YSize*sizeof(long));
      }
      if (Hough.Array!=NULL)
      {
         Array=new int[XSize*YSize];
         memcpy(Array,Hough.Array, XSize*YSize*sizeof(int));
      }
   }
   int FindMax(int &x, int &y);
   bool AddValue(float offsetx, float offsety);
   bool ResetValue(int x, int y);
   // initialization accumulator array
   void Init(int xsize, int ysize, float ratio);
   unsigned char* NormalizedHoughArray();
   int GetValue(int x, int y, float &avgx, float &avgy);
#ifdef DIGILIB
   long DrawArray(ImageStruct *Image);
#endif

};


