#ifndef _HOMO_INTERFACE_H
#define _HOMO_INTERFACE_H

#include "cv.h"

class c_Homography
{
   CvMat *Nu, *Nx;         // normalization matrix
   public:
   CvMat *invMatrix;
   CvMat *Matrix;
   c_Homography() 
   {   
	  Matrix    = cvCreateMat(3, 3, CV_32FC1);
	  invMatrix = cvCreateMat(3, 3, CV_32FC1);
	  Nu = cvCreateMat(3, 3, CV_32FC1);
	  Nx = cvCreateMat(3, 3, CV_32FC1);
	  cvSetZero(Nu);
	  cvmSet(Nu, 0, 0, 1);	cvmSet(Nu, 1, 1, 1);  cvmSet(Nu, 2, 2, 1);
	  cvSetZero(Nx);
	  cvmSet(Nx, 0, 0, 1);	cvmSet(Nx, 1, 1, 1);  cvmSet(Nx, 2, 2, 1);
	  cvSetZero(Matrix);
	  //cvmSet(Matrix 0, 0, 1);	cvmSet(Matrix, 1, 1, 1);  cvmSet(Matrix, 2, 2, 1);
	  cvSetZero(invMatrix);
	  cvmSet(invMatrix, 0, 0, 1);	cvmSet(invMatrix, 1, 1, 1);  cvmSet(invMatrix, 2, 2, 1);
   }
   ~c_Homography()
   {
		if (Nu) cvReleaseMat(&Nu);
		if (Nx) cvReleaseMat(&Nx);
		if (Matrix) cvReleaseMat(&Matrix);
		if (invMatrix) cvReleaseMat(&invMatrix);
   }
   int computeHomo4(CvPoint2D32f* X, CvPoint2D32f* U);
   // image points X
   // reference points U
//   float *computeLsmHomo(CvPoint2D32f* a, CvPoint2D32f* b, int numPoints);
   void XtoU(CvPoint2D32f* X, CvPoint2D32f* U);
   void UtoX(CvPoint2D32f* U, CvPoint2D32f* X);
};

#endif
 