//---------------------------------------------------------------------------
#ifndef DetectorESFH
#define DetectorESFH

//---------------------------------------------------------------------------
#include "Detector.h"
#include "findrectangle.h"
#include "teachertracking.h"
#include "cv.h"
#include "highgui.h"
#include "imagefun.h"
#include "homography.h"
#include "presentation.h"
#include "ConfigFile.h"
#include "ImgQueue.h"

//----------------------------------------------------------------------------
#define ESF_TYPE_PRESENTATION 1
#define ESF_TYPE_TRACKING 2
#define ESF_TYPE_ALL 255

//----------------------------------------------------------------------------
class TDetectorESF: public TDetector
{
	ExtractPresentation EPres;                 // for presentation table extraction
	c_BackGroundDetection TeacherTracking;     // tracking
	// Config file variables
	int PresWidth;                             // width of the presentation image
	int PresHeight;                            // height of the presentation image
	float Difference;                          // threshold for slide difference estimation
	int Threshold;                             // threshold for background subtraction
	int imagesize;                             // size of the resampled image
	CvPoint2D32f Points[4];                    // resized points of the projection screen defined by rectangle
	CvPoint2D32f OrigPoints[4];                // original points of the projection screen defined by rectangle
	////////////////////////////// image size  ////////////////////////////////
	int frameW, frameH;                        // original image size
	float SAMPLE;                              // ratio between original and resized image
	int FrameW2, FrameH2;                      // resized image size
	IplImage *imgColor;                        // header for input image
	IplImage *imgPrezentation;                 // image with presentation table
	IplImage *imgColorDown;                    // resized color image for processing
	IplImage *imgColortmp;

	int Type;
	int LOCALIZATION_STEP, PRESENTATION_STEP;

	bool Initialized;
	void InitA(int Width, int Height);

public:
	static TImgQueue *Slides;
	static void SetupSlides(TImgQueue *_Slides);

	TDetectorESF(int Type = ESF_TYPE_ALL);
	virtual void Init();
	virtual void Do(int Time, TImg &Img);
};

// extract presentation board image from imgColor into the imgPrezentation
void GetPrezentation(IplImage *imgColor, IplImage *imgPrezentation, CvPoint2D32f *Points);

#endif

