//---------------------------------------------------------------------------
#ifndef DetectorThreadH
#define DetectorThreadH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <SyncObjs.hpp>
#include <queue>
#include "ImpExp.h"

//---------------------------------------------------------------------------
class TImg;
class TDetector;

//---------------------------------------------------------------------------
class TDetectorThread: public TThread
{
private:
	class TQueueItem
	{
	public:
		int Time;
		TImg *Img;

		TQueueItem(int Time, TImg *Img)
		{
			this->Time = Time;
			this->Img = Img;
		}
	};

	Syncobjs::TEvent *StartEvent, *EmptyAllEvent, *EmptyOneEvent;
	Syncobjs::TCriticalSection *CSInput, *CSResults;

	TDetector *Detector;
	TImpExp ImpExp;

	int MaxQueueSize;
	std::queue<TQueueItem> Queue;

protected:
	void __fastcall Execute();

public:
	__fastcall TDetectorThread(TDetector *Detector);
	__fastcall ~TDetectorThread();

	void Init(int MaxQueueSize);
	void Do(int Time, TImg *Img);
	void Wait();
	void Break();
	bool Done();
	void Get(TImpExp &Results);
};
//---------------------------------------------------------------------------

#endif

