//---------------------------------------------------------------------------
#ifndef ComplexDetectorH
#define ComplexDetectorH

//---------------------------------------------------------------------------
#include "Events.h"
#include "Sources.h"
#include "ImpExp.h"
#include "Detector.h"
#include "DetectorThread.h"

//---------------------------------------------------------------------------
class TComplexDetector: public TImpExp
{
private:
	class TDetectorDesc
	{
	public:
		TDetector *Detector;
		int Camera;
		TDetectorThread *Thread;
	};
	typedef std::vector<TDetectorDesc> TDetectors;

	TDetectors Detectors;

	bool InThread;
	int MaxQueueLen;

	TImpExp ImpExp;

protected:
	void AddDetector(TDetector *Detector, int Camera);

public:
	TComplexDetector();
	virtual ~TComplexDetector();

	void SetConfiguration(char *Name, int Camera, ee::TParameters Configuration);

	virtual void Init(TExtendedSources &Sources, int MaxQueueSize);
	virtual void Do(int Time, TExtendedSources &Sources);
	void Break();
};

#endif

