#ifndef __BlahoDetector__h__
#define __BlahoDetector__h__


//---------------------------------------------------------------------------
#include "Detector.h"
#include "BlahoTracker.h"
#include "Events.h"

#include <cv.h>
#include "cxcore.h"
#include "cvext.hpp"
#include "highgui.h"

#include <string>


//---------------------------------------------------------------------------
class TBlahoDetector: public TDetector
{

	const std::string faceDetectorFilename;

	CvHaarClassifierCascade *faceDetectorCascade;

	CvMemStorage *storage;

	IplImage *frameSmall;
	IplImage *frameSmallLast;
	IplImage *frameGray;
	IplImage *differenceImage;

	int lastMovementTime;
	int lastFaceTime;
	bool noFace;
	int lastFacesTotal;

	const int differenceThreshold;
	const double differenceAreaThreshold; 
	const double faceDetectionImageScale;
	int camera;

public:

	TBlahoDetector();
	TBlahoDetector(int Camera);

	virtual void Init();
	virtual void Do(int Time, TImg &Img);

	virtual ~TBlahoDetector();
};


#endif