//---------------------------------------------------------------------------
#ifndef UnitVideoDemoH
#define UnitVideoDemoH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <vfw.h>
#include <Img.h>
#include <ExtCtrls.hpp>
#include <jpeg.hpp>
#include <vector>
#include "ImgQueue.h"

//---------------------------------------------------------------------------
class TFormVideoDemo : public TForm {
__published:	// IDE-managed Components
	TPanel *PanelRight;
	TImage *Image1;
	TPanel *PanelLeft;
	TPaintBox *PaintBoxVideo;
	TPaintBox *PaintBoxSlides;
	TTimer *Timer1;
	TTimer *TimerImages;
	void __fastcall PaintBoxVideoPaint(TObject *Sender);
	void __fastcall FormKeyDown(TObject *Sender, WORD &Key,
					TShiftState Shift);
	void __fastcall FormResize(TObject *Sender);
	void __fastcall PaintBoxVideoDblClick(TObject *Sender);
	void __fastcall PaintBoxSlidesPaint(TObject *Sender);
	void __fastcall Timer1Timer(TObject *Sender);
	void __fastcall PanelLeftResize(TObject *Sender);
	void __fastcall TimerImagesTimer(TObject *Sender);
	void __fastcall FormShow(TObject *Sender);

private:	// User declarations
	HDRAWDIB hdd;
	LPBITMAPINFO LastFrame;
	AnsiString FCaption;
	double FOutputAspectRatio;
	bool FFullScreen;
	int LastLeft, LastTop, LastWidth, LastHeight;
	int FSlideCount;
	double FSlideAspectRatio;
	TImgQueue *SourceSlides;
	TImgQueue Slides;
	AnsiString FLastImage;
	unsigned int ImageIndex;

public:		// User declarations
	std::vector<AnsiString> Images;

	__fastcall TFormVideoDemo(TComponent* Owner, AnsiString Caption = "");
	__fastcall ~TFormVideoDemo();

	void Display(TImg *Frame);
	void SetFullScreen(bool Value);
	void SetOutputAspectRatio(double Value);
	void SetSlideCount(int SlideCount);

	void SetupSlides(TImgQueue *_Slides) { SourceSlides = _Slides; };
};
//---------------------------------------------------------------------------

#endif

