//---------------------------------------------------------------------------
#ifndef UnitMainDemoH
#define UnitMainDemoH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Dialogs.hpp>
#include <time.h>
#include <ExtCtrls.hpp>
#include <ComCtrls.hpp>
#include <vector>
#include "RTEditor.h"
#include "AudioPlayer.h"
#include "UnitVideoDemo.h"
#include "UnitFloatControls.h"
#include "ImgQueue.h"

//---------------------------------------------------------------------------
class TFormMainDemo : public TForm, public TAudioPlayer::TAudioSource
{
__published:	// IDE-managed Components
	TButton *ButtonOpen;
	TOpenDialog *OpenDialog1;
	TRadioGroup *RadioGroupMode;
	TTrackBar *TrackBar1;
	TGroupBox *GroupBox1;
	TButton *ButtonInit;
	TLabel *Label2;
	TEdit *EditDelay;
	TGroupBox *Control;
	TButton *ButtonStart;
	TButton *ButtonStop;
	TGroupBox *GroupBox2;
	TLabel *LabelSkipProlog;
	TLabel *Label1;
	TLabel *Label3;
	TLabel *LabelTime;
	TLabel *LabelFPS;
	TGroupBox *GroupBox3;
	TListBox *ListBox2;
	TButton *Button1;
	TButton *Button2;
	TOpenDialog *OpenDialog2;
	TGroupBox *GroupBox4;
	TListBox *ListBox1;
	TRadioGroup *RadioGroupQuality;
	TLabel *Label4;
	TLabel *LabelSkipped;
	TLabel *Label5;
	TButton *ButtonReset;
	TRadioButton *CheckBoxAudio;
	TRadioGroup *RadioGroupOutput;
	TRadioGroup *RadioGroupInput;
	TButton *Button3;
	TLabel *LabelStatistics;
	TLabel *Label6;
	TEdit *Edit1;
	TButton *Button4;
	TSaveDialog *SaveDialog1;
	TButton *Button5;
	TLabel *LabelAudioBufOut;
	TLabel *Label7;
	TRadioButton *CheckBoxSync;
	TTimer *TimerSync;
	TCheckBox *CheckBoxInput;
	TCheckBox *CheckBoxShow;
	TRadioButton *RadioButton1;
	TButton *Button6;
	TEdit *EditStep;
	TLabel *Label8;
	TButton *ButtonOpenHub;
	TCheckBox *chbOnline;
	void __fastcall ButtonOpenClick(TObject *Sender);
	void __fastcall ButtonInitClick(TObject *Sender);
	void __fastcall ButtonStartClick(TObject *Sender);
	void __fastcall ButtonStopClick(TObject *Sender);
	void __fastcall CheckBoxShowClick(TObject *Sender);
	void __fastcall FormShow(TObject *Sender);
	void __fastcall CheckBoxInputClick(TObject *Sender);
	void __fastcall Button1Click(TObject *Sender);
	void __fastcall Button2Click(TObject *Sender);
	void __fastcall RadioGroupQualityClick(TObject *Sender);
	void __fastcall ButtonResetClick(TObject *Sender);
	void __fastcall Button3Click(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall Button4Click(TObject *Sender);
	void __fastcall Button5Click(TObject *Sender);
	void __fastcall TimerSyncTimer(TObject *Sender);
	void __fastcall Button6Click(TObject *Sender);
	void __fastcall ButtonOpenHubClick(TObject *Sender);
	void __fastcall chbOnlineClick(TObject *Sender);

private:	// User declarations
	AnsiString FDefaulCaption;
	AnsiString INIFileName;

	TFormVideoDemo *FormVideo;
	std::vector<TFormFloatControls*> FormControls;
	std::vector<TFormVideoDemo*> FormVideoInput;
	TImgQueue Slides;

	bool Initiallized;

	clock_t LastFrameTime;
	int FrameCount;
	int TotalFrameCount, TotalSkippedFrames;
	float FPS;
	TImg Frame;
	bool Repeat;
	TRTEditor *RTEditor;
	TAudioPlayer AudioPlayer;
	clock_t StartPlay;

	int SkipFrames, SkipProlog;
	bool Prepering;

	void Init();
	void UpdateStatus();

	TWave* FAudio;
	virtual unsigned int GetPos();
	virtual unsigned int GetLen();
	virtual BYTE *GetData(unsigned int &Len);

	void __fastcall NewWndProc(Messages::TMessage &Message);

	void DisplayOutput(TImg *Frame);
	void UpdateOutputWindow();

	void AddFormControls(AnsiString Caption, TRTEditor::TControlType Type);
	void CreateFormControls();
	void FreeFormControls();
	void __fastcall OnControlChange(System::TObject* Sender, TRTEditor::TControlType Type, TRTEditor::TFloatControl Control);

	void DisplayInput();
	void UpdateInputWindow();
	void FreeFormVideoInput();

	void LoadSources();
	void SaveSources();

	void LoadMain();
	void SaveMain();

	void SaveForm(TForm *Form);
	void LoadForm(TForm *Form);

	bool FromParam;
	void OpenFile(const char *FileName);

public:	// User declarations
	__fastcall TFormMainDemo(TComponent* Owner);
	__fastcall ~TFormMainDemo();
};
//---------------------------------------------------------------------------
extern PACKAGE TFormMainDemo *FormMainDemo;
//---------------------------------------------------------------------------

#endif

