//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "UnitFloatControls.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

//---------------------------------------------------------------------------
const int ControlWindth = 45;
const int ControlHeight = 60;
const int LabelHeight = 13;

//---------------------------------------------------------------------------
__fastcall TFormFloatControls::TFormFloatControls(TComponent* Owner, AnsiString Caption, TRTEditor::TControlType Type, TRTEditor::TFloatControls Controls): TForm(Owner)
{
	this->Caption = Caption;
	this->Controls = Controls;
	this->Type = Type;
	FOnControlChange = NULL;

	for (unsigned int i = 0; i < Controls.size(); i++)
	{
		TTrackBar *TrackBar = new TTrackBar(this);
		TrackBar->Parent = this;
		TrackBar->Orientation = trVertical;
		TrackBar->Left = i * ControlWindth;
		TrackBar->Top = LabelHeight;
		TrackBar->Width = ControlWindth;
		TrackBar->Height = ControlHeight;
		TrackBar->Min = 0;
		TrackBar->Max = 100;
		TrackBar->Position = TrackBar->Max - TrackBar->Max * Controls[i].Value;
		TrackBar->OnChange = TrackBarChange;
		TrackBar->Tag = i;

		TLabel *Label = new TLabel(this);
		Label->Parent = this;
		Label->AutoSize = false;
		Label->Left = i * ControlWindth;
		Label->Top = 0;
		Label->Height = LabelHeight;
		Label->Width = ControlWindth;
		Label->Caption = Controls[i].Name;
		Label->Alignment = taCenter;
	}

	ClientHeight = ControlHeight + LabelHeight;
	ClientWidth = ControlWindth * Controls.size();
}

//---------------------------------------------------------------------------
void __fastcall TFormFloatControls::TrackBarChange(TObject *Sender)
{
	TTrackBar *TrackBar = (TTrackBar*)Sender;
	Controls[TrackBar->Tag].Value = float(TrackBar->Max - TrackBar->Position) / float(TrackBar->Max);
	if (FOnControlChange)
	{
		FOnControlChange(this, Type, Controls[TrackBar->Tag]);
	}
}

