//---------------------------------------------------------------------------

#ifndef CAMERAREADER_H
#define CAMERAREADER_H

#include <process.h>
#include <vector>

#include "Sources.h"


class TFiCamera
{
private:
	static unsigned __stdcall ThreadFunction(void *param);

	TExtendedSource				*FSource;
	int							FId;
	unsigned long				FFrameIndex;
	HANDLE						hProcessThread;
public:
	static bool					Done;
	bool						StatusOK;

	TFiCamera(int ID, TExtendedSource *Source = NULL);
	~TFiCamera();

	bool Init();
	void Start();
};


#define CAMERA_MAX_COUNT	10

class TCameraReader
{
private:
	std::vector<TFiCamera*>	FCameras;

	TExtendedSources		FSources;
	int						FCameraCount;

protected:
	TFiCamera* AddCamera(int ID, TExtendedSource *Source = NULL);

public:
	TCameraReader();
	~TCameraReader();

	void Init(TExtendedSources &Sources);
    void Run();
};

//---------------------------------------------------------------------------

#endif
