//---------------------------------------------------------------------------
#ifndef AudioPlayerH
#define AudioPlayerH

//---------------------------------------------------------------------------
#include <windows.h>
#include <vfw.h>
#include <vector>
#include <Messages.hpp>

//---------------------------------------------------------------------------
const AudioBufNum = 32;

//---------------------------------------------------------------------------
class TAudioPlayer
{
private:
	HWND FHandle;

public:
	class TAudioSource
	{
	public:
		virtual unsigned int GetPos() = 0;
		virtual unsigned int GetLen() = 0;
		virtual BYTE *GetData(unsigned int &Len) = 0;
	};

protected:
	struct TAudioInfo
	{
		HWAVEOUT hwo;
		WAVEFORMATEX dwf;
		WAVEHDR wh[AudioBufNum];
		byte *AudioBuf;
		unsigned int AudioBufSize, AudioBufPos;
		int AudioBufIndex, AudioBufOut;
		TAudioSource *Source;
		bool Playing, Prepared;
	};
	typedef std::vector<TAudioInfo> TStreams;
	TStreams FStreams;

	bool WriteAudioBuf(TAudioInfo &Info);

public:
	TAudioPlayer();
	~TAudioPlayer();

	int Init(int ARate, int AChannels, int ABits, TAudioSource *ASource = NULL);
	void SetSource(unsigned int AStream, TAudioSource *ASource);
	void SetWindow(HWND AHandle) { FHandle = AHandle; };
	void Prepare();
	void Start();
	void Stop();
	unsigned int GetAudioBufOut(unsigned int AStream);
	unsigned int GetCount();
	bool WndProc(Messages::TMessage &Message);
};

#endif

