#ifndef FIREISTATUS_H
#define FIREISTATUS_H

#include <types.h>

#pragma once

// Copied from NTDDK.H
#define FACILITY_IO_ERROR_CODE           0x4
#define STATUS_SEVERITY_ERROR            0x3
#define STATUS_SUCCESS                   (0L)

#define MAKE_FIREi_ERROR_CODE(code)     \
    (((((ULONG)(STATUS_SEVERITY_ERROR))<<30) | (1<<29) | (((ULONG)FACILITY_IO_ERROR_CODE)<<16)| (code)))

typedef enum tagFIREi_STATUS
{
    // General error codes
    FIREi_STATUS_SUCCESS                    = STATUS_SUCCESS,
    FIREi_STATUS_INVALID_PARAMETER          = MAKE_FIREi_ERROR_CODE(0x0A01L),
    FIREi_STATUS_NO_MEMORY                  = MAKE_FIREi_ERROR_CODE(0x0A02L),
    FIREi_STATUS_INTERNAL_ERROR             = MAKE_FIREi_ERROR_CODE(0x0A03L),
    FIREi_STATUS_ACCESS_VIOLATION           = MAKE_FIREi_ERROR_CODE(0x0A04L),
    FIREi_STATUS_UNSUCCESSFUL               = MAKE_FIREi_ERROR_CODE(0x0A05L),
    FIREi_BUFFER_TOO_SMALL                  = MAKE_FIREi_ERROR_CODE(0x0A06L),
    // Display Engine error codes
    FIREi_STATUS_DDRAWINITFAILED            = MAKE_FIREi_ERROR_CODE(0x0D01L),
    FIREi_STATUS_WINDOW_TOO_SMALL           = MAKE_FIREi_ERROR_CODE(0x0D02L),
    FIREi_STATUS_DISPLAY_TOO_SMALL          = MAKE_FIREi_ERROR_CODE(0x0D03L),
    FIREi_STATUS_NO_STRETCHING_SUPPORT      = MAKE_FIREi_ERROR_CODE(0x0D04L),
    // IsochEngine error codes
    FIREi_STATUS_TIMEOUT                    = MAKE_FIREi_ERROR_CODE(0x0E01L),

    FIREi_CHANNEL_ALLOCATION_FAILED         = MAKE_FIREi_ERROR_CODE(0x0E02L),
    // For backwards source compatibility
    FIREi_CHANNEL_ALOCATION_FAILED          = FIREi_CHANNEL_ALLOCATION_FAILED,

    FIREi_STATUS_COULD_NOT_QUEUE_FRAMES     = MAKE_FIREi_ERROR_CODE(0x0E03L),
    FIREi_NO_FRAMES_RECEIVED                = MAKE_FIREi_ERROR_CODE(0x0E04L),
    FIREi_STATUS_BAD_FRAME                  = MAKE_FIREi_ERROR_CODE(0x0E05L),
    FIREi_STATUS_NO_FRAMES_ALOCATED         = MAKE_FIREi_ERROR_CODE(0x0E06L),
    FIREi_STATUS_ENGINE_STARTED             = MAKE_FIREi_ERROR_CODE(0x0E07L),
    FIREi_STATUS_FRAMES_ALREADY_ALLOCATED   = MAKE_FIREi_ERROR_CODE(0x0E08L),
    FIREi_STATUS_LONG_PACKET                = MAKE_FIREi_ERROR_CODE(0x0E09L),
    // CameraControl error codes
    FIREi_STATUS_BUS_RESET                  = MAKE_FIREi_ERROR_CODE(0x0C01L),
    FIREi_STATUS_ADAPTER_ERROR              = MAKE_FIREi_ERROR_CODE(0x0C02L),
    FIREi_STATUS_CAMERA_READ_FAIL           = MAKE_FIREi_ERROR_CODE(0x0C03L),
    FIREi_STATUS_CAMERA_WRITE_FAIL          = MAKE_FIREi_ERROR_CODE(0x0C04L),
    FIREi_STATUS_CAMERA_ALREADY_RUNNING     = MAKE_FIREi_ERROR_CODE(0x0C05L),
    FIREi_STATUS_CAMERA_UNSUPPORTED_FEATURE = MAKE_FIREi_ERROR_CODE(0x0C06L),
    FIREi_STATUS_FEATURE_INVALID_VALUE      = MAKE_FIREi_ERROR_CODE(0x0C07L),
    FIREi_STATUS_UNDEFINED_OID              = MAKE_FIREi_ERROR_CODE(0x0C08L),
}
FIREi_STATUS;

#endif

