#pragma once
#include "fiint.h"

#define ISOCH_CYCLE_TIME    0.125  // Duration of one isochronous cycle in milliseconds
#define SECOND              1000  

#define BITS_IN_BYTE 8

// Determine if a is num multiple of base
#define IsMultipleOf(base,num) (0 == (num % base))
#define ReduceToMultipleOf(base,num) (num - (num % base))
#define IncreaseToMultipleOf(base,num) ((num - (num % base)) + base )

#define FpsFromPacketSize(ImageSize , PacketSize) ((double)(SECOND / ((double)(ImageSize / PacketSize ) * ISOCH_CYCLE_TIME)))

#if !defined(FICOMMON)
#ifdef FICOMMON_DLL_BUILD
#define FICOMMON_DLL_SPEC __declspec(dllexport)
#else
#define FICOMMON_DLL_SPEC __declspec(dllimport)
#endif
#define FICOMMON(type) extern "C" FICOMMON_DLL_SPEC type WINAPI
#endif

#ifdef UNICODE
#define GetSafeFileSize         GetSafeFileSizeW
#define GetFreeDiskSpaceInKB    GetFreeDiskSpaceInKBW
#define OpenFileDialog          OpenFileDialogW
#define SaveBitmap              SaveBitmapW
#else
#define GetSafeFileSize         GetSafeFileSizeA
#define GetFreeDiskSpaceInKB    GetFreeDiskSpaceInKBA
#define OpenFileDialog          OpenFileDialogA
#define SaveBitmap              SaveBitmapA
#endif

FICOMMON(DWORDLONG) GetSafeFileSizeA(LPCSTR tach);
FICOMMON(DWORDLONG) GetSafeFileSizeW(LPCWSTR tach);
FICOMMON(long) GetFreeDiskSpaceInKBA(LPCSTR pFile);
FICOMMON(long) GetFreeDiskSpaceInKBW(LPCWSTR pFile);

FICOMMON(BOOL) OpenFileDialogA(HWND hWnd, LPSTR pszName, int cb, LONG a_nCamIdx);
FICOMMON(BOOL) OpenFileDialogW(HWND hWnd, LPWSTR pszName, int cb, LONG a_nCamIdx);

FICOMMON(BOOL) FlipHorizontally(BYTE * pBuffer, BITMAPINFOHEADER *pbih);
FICOMMON(BOOL) FlipVertically(BYTE * pBuffer, BITMAPINFOHEADER *pbih);
FICOMMON(BOOL) NegativeImage(BYTE * pBuffer, BITMAPINFOHEADER *pbih);
FICOMMON(BOOL) TimeStamp(BYTE *pBuffer, BITMAPINFOHEADER *pbih, WCHAR *timeStamp,
                         LOGFONT *logfont, COLORREF color, ULONG xPos, ULONG yPos);
FICOMMON(BOOL) SaveBitmapA(BYTE *pBuffer, BITMAPINFOHEADER *pbih, LPCSTR szFileName);
FICOMMON(BOOL) SaveBitmapW(BYTE *pBuffer, BITMAPINFOHEADER *pbih, LPCWSTR szFileName);
FICOMMON(wchar_t*) GetEncoderExtention(CLSID* pClsid);
FICOMMON(int) GetEncoderClsid(unsigned long a_saveFlags, CLSID* pClsid);
FICOMMON(BOOL) IsEncoderTIFF(CLSID* pClsid);
