/*===========================================================================
    Fire-i API(TM) Source Code Samples                                  
    Copyright Unibrain S.A. 1999-2007
                                                                        
    This code and information is provided "AS IS" without warranty of   
    any kind, either expressed or implied, including but not limited to 
    the implied warranties of merchantability and/or fitness for a      
    particular purpose.   
 ===========================================================================*/

#pragma once

#include "fiint.h"
#include <CommCtrl.h>

#if !defined(FICOMMON)
#ifdef FICOMMON_DLL_BUILD
#define FICOMMON_DLL_SPEC __declspec(dllexport)
#else
#define FICOMMON_DLL_SPEC __declspec(dllimport)
#endif
#define FICOMMON(type) extern "C" FICOMMON_DLL_SPEC type WINAPI
#endif

#define BASIC_FUNC_INQ          0xf0f00400
#define CUR_MEM_CH              0xf0f00624
#define MEM_SAVE_CH             0xf0f00620
#define MEM_SAVE_CH_CMD         0xf0f00618
#define COLOR_BARS_OFFSET       0xf0f00f04

#define COLOR_BARS_ON           0x80000000
#define COLOR_BARS_OFF          0x00000000

#define OFFSET_GAP              10
#define EXPO_PROPERTIES_OFFSET  0
#define COLOR_PROPERTIES_OFFSET (EXPO_PROPERTIES_OFFSET + OFFSET_GAP)
#define BASIC_PROPERTIES_OFFSET (COLOR_PROPERTIES_OFFSET + OFFSET_GAP)

#ifdef UNICODE
#define FiEnumerateDevices              FiEnumerateDevicesW
#define FiAddFilter                     FiAddFilterW
#define FiGetRegisteredFilterHandle     FiGetRegisteredFilterHandleW
#define FiAddRegisteredFilter           FiAddRegisteredFilterW
#define FiCreateGraphWritingSection     FiCreateGraphWritingSectionW
#define FiInsertFilter                  FiInsertFilterW
#define FiInterceptFilter               FiInterceptFilterW
#define FiNukeDownstream                FiNukeDownstreamW
#define FiIsFilterInList                FiIsFilterInListW
#define FiDisplayPropertyPages          FiDisplayPropertyPagesW
#define FiGetCameraDescription          FiGetCameraDescriptionW
#define FiSaveFrame                     FiSaveFrameW
#define FiAllocCaptureFile              FiAllocCaptureFileW
#define FiCopyCaptureFile               FiCopyCaptureFileW
#define FiSetCaptureFileName            FiSetCaptureFileNameW
#define FiSetFileName                   FiSetFileNameW
#define FiTriggerModeString             FiTriggerModeStringW
#define FiTriggerSourceString           FiTriggerSourceStringW
#define FiTimeUnitString                FiTimeUnitStringW
#define FiPixelFormatString             FiPixelFormatStringW
#define FiResolutionString              FiResolutionStringW
#define FiFpsString                     FiFpsStringW
#define FiLicenceTypeString             FiLicenceTypeStringW
#define FiGetCameraModel                FiGetCameraModelW
#define FiShowVFWCompressorProperties   FiShowVFWCompressorPropertiesW
#define FiGetCameraImageIndex           FiGetCameraImageIndexW
#define FiDisplayStreamConfigPages      FiDisplayStreamConfigPagesW
#else
#define FiEnumerateDevices              FiEnumerateDevicesA
#define FiAddFilter                     FiAddFilterA
#define FiGetRegisteredFilterHandle     FiGetRegisteredFilterHandleA
#define FiAddRegisteredFilter           FiAddRegisteredFilterA
#define FiCreateGraphWritingSection     FiCreateGraphWritingSectionA
#define FiInsertFilter                  FiInsertFilterA
#define FiInterceptFilter               FiInterceptFilterA
#define FiNukeDownstream                FiNukeDownstreamA
#define FiIsFilterInList                FiIsFilterInListA
#define FiDisplayPropertyPages          FiDisplayPropertyPagesA
#define FiGetCameraDescription          FiGetCameraDescriptionA
#define FiSaveFrame                     FiSaveFrameA
#define FiAllocCaptureFile              FiAllocCaptureFileA
#define FiCopyCaptureFile               FiCopyCaptureFileA
#define FiSetCaptureFileName            FiSetCaptureFileNameA
#define FiSetFileName                   FiSetFileNameA
#define FiTriggerModeString             FiTriggerModeStringA
#define FiTriggerSourceString           FiTriggerSourceStringA
#define FiTimeUnitString                FiTimeUnitStringA
#define FiPixelFormatString             FiPixelFormatStringA
#define FiResolutionString              FiResolutionStringA
#define FiFpsString                     FiFpsStringA
#define FiLicenceTypeString             FiLicenceTypeStringA
#define FiGetCameraModel                FiGetCameraModelA
#define FiShowVFWCompressorProperties   FiShowVFWCompressorPropertiesA
#define FiGetCameraImageIndex           FiGetCameraImageIndexA
#define FiDisplayStreamConfigPages      FiDisplayStreamConfigPagesA
#endif

FICOMMON(HRESULT) FiEnumerateDevicesA(IBaseFilter **a_pDeviceArray,
                           REFCLSID a_clsidDeviceClass,
                           LPCSTR *a_szMatchArray,
                           LPCSTR *a_szNoMatchArray,
                           ULONG *a_puPresentDevices,
						   ULONG *a_puLongestName,
                           CHAR **a_szNameArray);
FICOMMON(HRESULT) FiEnumerateDevicesW(IBaseFilter **a_pDeviceArray,
                           REFCLSID a_clsidDeviceClass,
                           LPCWSTR *a_szMatchArray,
                           LPCWSTR *a_szNoMatchArray,
                           ULONG *a_puPresentDevices,
                           ULONG *a_puLongestName,
                           WCHAR **a_szNameArray);

FICOMMON(HRESULT) FiCreateCaptureGraphBuilder(ICaptureGraphBuilder2 **a_ppBuilder, 
                                    IGraphBuilder **a_ppFilterGraph);
FICOMMON(HRESULT) FiAddFilterA(IGraphBuilder *a_pFilterGraph, IBaseFilter* a_pFilter, LPSTR a_pNickname);
FICOMMON(HRESULT) FiAddFilterW(IGraphBuilder *a_pFilterGraph, IBaseFilter* a_pFilter, LPWSTR a_pNickname);
FICOMMON(HRESULT) FiGetRegisteredFilterHandleA(LPCSTR a_szFilterName, IBaseFilter** a_ppFilter, REFCLSID a_clsidDeviceClass);
FICOMMON(HRESULT) FiGetRegisteredFilterHandleW(LPCWSTR a_szFilterName, IBaseFilter** a_ppFilter, REFCLSID a_clsidDeviceClass);
FICOMMON(HRESULT) FiAddRegisteredFilterA(IGraphBuilder *a_pFilterGraph,
                              LPCSTR a_szFilterName,
                              REFCLSID a_clsidDeviceClass,
                              IBaseFilter** a_ppFilter,
                              LPSTR a_pNickname);
FICOMMON(HRESULT) FiAddRegisteredFilterW(IGraphBuilder *a_pFilterGraph,
                                         LPCWSTR a_szFilterName,
                                         REFCLSID a_clsidDeviceClass,
                                         IBaseFilter** a_ppFilter,
                                         LPWSTR a_pNickname);
FICOMMON(HRESULT) FiRemoveFilter(IGraphBuilder *a_pFilterGraph, IBaseFilter* a_pFilter);
FICOMMON(HRESULT) FiGraphRender(ICaptureGraphBuilder2 *a_pBuilder,
                      const GUID *a_pCategory,
                      const GUID *a_pType,
                      IUnknown *a_pSource,
                      IBaseFilter *a_pIntermediate,
                      IBaseFilter *a_pSink);
FICOMMON(HRESULT) FiCreateGraphWritingSectionA(ICaptureGraphBuilder2 *a_pBuilder,
                                    const GUID *a_pType,
                                    LPSTR a_szCaptureFile,
                                    IBaseFilter **a_ppMultiplexer,
                                    IFileSinkFilter **a_ppSink);
FICOMMON(HRESULT) FiCreateGraphWritingSectionW(ICaptureGraphBuilder2 *a_pBuilder,
                                    const GUID *a_pType,
                                    LPWSTR a_szCaptureFile,
                                    IBaseFilter **a_ppMultiplexer,
                                    IFileSinkFilter **a_ppSink);

FICOMMON(HRESULT) FiGetPin(IBaseFilter *a_pFilter,
                 PIN_DIRECTION a_DirRequired,
                 int a_iNum,
                 IPin **a_ppPin);

FICOMMON(IPin *) FiGetInPin(IBaseFilter *a_pFilter, int a_iNum);
FICOMMON(IPin *) FiGetOutPin(IBaseFilter *a_pFilter, int a_iNum);
FICOMMON(HRESULT) FiConnectFilter(IBaseFilter   *a_pFilter,
                        ULONG          a_InPinIdx,
                        IBaseFilter   *a_pUpFilter, 
                        ULONG          a_OutPinIdx,
                        IGraphBuilder *a_pGraph);

FICOMMON(HRESULT) FiInsertFilterA(IBaseFilter *a_pFilter,
                       LPSTR a_pNickname,
                       IBaseFilter *a_pUpperFilter,
                       IGraphBuilder *a_pGraph);
FICOMMON(HRESULT) FiInsertFilterW(IBaseFilter *a_pFilter,
                       LPWSTR a_pNickname,
                       IBaseFilter *a_pUpperFilter,
                       IGraphBuilder *a_pGraph);

FICOMMON(HRESULT) FiInterceptFilterA(IBaseFilter *a_pFilter,
                          LPSTR a_pNickname,
                          IBaseFilter *a_pUpFilter,
                          IGraphBuilder *a_pGraph);
FICOMMON(HRESULT) FiInterceptFilterW(IBaseFilter *a_pFilter,
                          LPWSTR a_pNickname,
                          IBaseFilter *a_pUpFilter,
                          IGraphBuilder *a_pGraph);

FICOMMON(void) FiNukeDownstreamA(IBaseFilter *a_pFilter, 
                                 IGraphBuilder *a_pFilterGraph,
                                 CHAR ** a_excludeList, 
                                 ULONG a_excludeListSize);
FICOMMON(void) FiNukeDownstreamW(IBaseFilter *a_pFilter, 
                                 IGraphBuilder *a_pFilterGraph,
                                 WCHAR ** a_excludeList, 
                                 ULONG a_excludeListSize);

FICOMMON(HRESULT) FiGetStreamFormatsNumber(IBaseFilter *pCam, ICaptureGraphBuilder2 *a_pBuilder, ULONG *a_puStreamFormats);
FICOMMON(HRESULT) FiGetStreamAndVideoFormats(IBaseFilter *a_pCam, ICaptureGraphBuilder2 *a_pBuilder,
                                   ULONG a_uStreamFormats,
                                   AM_MEDIA_TYPE *a_pStreamFormatArray[],
                                   VIDEO_STREAM_CONFIG_CAPS a_VideoCapsArray[]);
FICOMMON(HRESULT) FiGetCurrentStreamFormat(IBaseFilter *a_pCam, ICaptureGraphBuilder2 *a_pBuilder, AM_MEDIA_TYPE **a_ppCurrentFormat);
FICOMMON(HRESULT) FiSetStreamFormat(IBaseFilter *a_pCam, ICaptureGraphBuilder2 *a_pBuilder, AM_MEDIA_TYPE *a_pStreamFormat);
FICOMMON(HRESULT) FiGetDefaultFormat(IBaseFilter *a_pCam,  ULONG *a_uFormatIndex);
FICOMMON(HRESULT) FiSetDefaultFormat(IBaseFilter *a_pCam,  ULONG a_pFormatIndex);
FICOMMON(HRESULT) FiSetCurrentFps(IBaseFilter *a_pCam,  ULONG a_uFormatIndex, FIREi_FPS a_Fps);
FICOMMON(HRESULT) FiGetCurrentFps(IBaseFilter *a_pCam,  ULONG a_uFormatIndex, FIREi_FPS *a_pFps);
FICOMMON(HRESULT) FiGetFrameRates(IBaseFilter *a_pCam, LONG a_iIndex, SIZE a_Dimensions,
                        LONG *a_plListSize, LONGLONG **a_ppllFrameRates);
FICOMMON(HRESULT) FiGetVideoFormatList(IBaseFilter *a_pCam, PFi_VIDEO_FORMAT_INFO *a_pVideoFormatList, 
                             ULONG *a_pFormatNum);
FICOMMON(HRESULT) FiFreeVideoFormatlist(IBaseFilter *a_pCam, PFi_VIDEO_FORMAT_INFO a_pVideoFormatList);
FICOMMON(HRESULT) FiSetCaptureFileCompatibilityIndex(IBaseFilter *a_pAviMuxFilter, BOOL a_bEnable);

FICOMMON(HRESULT) FiSetTriggerMode(IBaseFilter *a_pCam, BOOL a_bTriggerOn);

FICOMMON(HRESULT) FiDisplayPropertyPagesA(IBaseFilter *a_pFilter,
                                          LPSTR a_szFilterDescription,
                                          BYTE a_byBlockMask,
                                          UINT a_x,
                                          UINT a_y,
                                          HWND a_hParent);
FICOMMON(HRESULT) FiDisplayPropertyPagesW(IBaseFilter *a_pFilter,
                                          LPWSTR a_szFilterDescription,
                                          BYTE a_byBlockMask,
                                          UINT a_x,
                                          UINT a_y,
                                          HWND a_hParent);

FICOMMON(HRESULT) FiDisplayStreamConfigPagesA(IBaseFilter *a_pFilter,
                                          LPSTR a_szFilterDescription,
                                          UINT a_x,
                                          UINT a_y,
                                          HWND a_hParent);
FICOMMON(HRESULT) FiDisplayStreamConfigPagesW(IBaseFilter *a_pFilter,
                                          LPWSTR a_szFilterDescription,
                                          UINT a_x,
                                          UINT a_y,
                                          HWND a_hParent);

FICOMMON(HRESULT) FiGetCameraDescriptionA(IBaseFilter *a_pCam, ULONG *a_puCameraDescriptionSize, LPSTR *a_pszCameraDescription);
FICOMMON(HRESULT) FiGetCameraDescriptionW(IBaseFilter *a_pCam, ULONG *a_puCameraDescriptionSize, LPWSTR *a_pszCameraDescription);
FICOMMON(HRESULT) FiGetMaxMemoryChannel(IBaseFilter *a_pCam, ULONG *a_uMaxChannel);
FICOMMON(HRESULT) FiLoadCameraMemory(IBaseFilter *a_pCam, USHORT a_uMemoryChannel);
FICOMMON(HRESULT) FiSaveCameraMemory(IBaseFilter *a_pCam, USHORT a_uMemoryChannel);

FICOMMON(HRESULT) FiEnableOverlays(IBaseFilter *a_pYuv2RgbFilter, BOOL a_bEnable);
FICOMMON(HRESULT) FiSaveFrameA(IBaseFilter *a_pYuv2RgbFilter, LPSTR a_szSavePath, GUID *a_encoderClsid);
FICOMMON(HRESULT) FiSaveFrameW(IBaseFilter *a_pYuv2RgbFilter, LPWSTR a_szSavePath, GUID *a_encoderClsid);

FICOMMON(HRESULT) FiEnableVideoWindow(IGraphBuilder *a_pFilterGraph, OAHWND a_hWindow);
FICOMMON(HRESULT) FiDisableVideoWindow(IGraphBuilder *a_pFilterGraph);
FICOMMON(HRESULT) FiVideoWindowFullScreen(IGraphBuilder *a_pFilterGraph, BOOL a_bEnable);
FICOMMON(HRESULT) FiSetVideoWindowPosition(IGraphBuilder *a_pFilterGraph, LONG a_lLeft, LONG a_lTop, LONG a_lWidth, LONG a_lHeight);

FICOMMON(HRESULT) FiAllocCaptureFileA(ICaptureGraphBuilder2 *a_pBuilder, LPSTR a_szCaptureFile, DWORDLONG a_dwlFileSize);
FICOMMON(HRESULT) FiAllocCaptureFileW(ICaptureGraphBuilder2 *a_pBuilder, LPWSTR a_szCaptureFile, DWORDLONG a_dwlFileSize);
FICOMMON(HRESULT) FiCopyCaptureFileA(ICaptureGraphBuilder2 *a_pBuilder,
                                     LPSTR a_szExistingFile,
                                     LPSTR a_szNewFile,
                                     IAMCopyCaptureFileProgress *a_pProg);
FICOMMON(HRESULT) FiCopyCaptureFileW(ICaptureGraphBuilder2 *a_pBuilder,
                                     LPWSTR a_szExistingFile,
                                     LPWSTR a_szNewFile,
                                     IAMCopyCaptureFileProgress *a_pProg);

FICOMMON(HRESULT) FiStartCameraPreview(IGraphBuilder *a_pFilterGraph);
FICOMMON(HRESULT) FiStopCameraPreview(IGraphBuilder *a_pFilterGraph);
FICOMMON(HRESULT) FiStartCameraCapture(IGraphBuilder *a_pFilterGraph, ICaptureGraphBuilder2 *a_pBuilder);
FICOMMON(HRESULT) FiStopCameraCapture(IGraphBuilder *a_pFilterGraph);
FICOMMON(HRESULT) FiPauseCamera(IGraphBuilder *a_pFilterGraph);
FICOMMON(HRESULT) FiSetCaptureFileNameA(IGraphBuilder *a_pfilterGraph, LPSTR a_szCaptureFile);
FICOMMON(HRESULT) FiSetCaptureFileNameW(IGraphBuilder *a_pfilterGraph, LPWSTR a_szCaptureFile);

FICOMMON(HRESULT) FiGetCameraProperty(IBaseFilter *a_pBaseFilter, LONG a_lProperty, float *a_plValue);
FICOMMON(HRESULT) FiGetCameraAbsProperty(IBaseFilter *a_pBaseFilter, LONG a_lProperty, float *a_plValue);
FICOMMON(HRESULT) FiGetCameraPropertyFlags(IBaseFilter *a_pBaseFilter,
                                 LONG   a_lProperty,
                                 float *a_plValue,
                                 PLONG  a_plFlags);
FICOMMON(HRESULT) FiGetCameraPropertyRange(IBaseFilter *a_pBaseFilter, LONG a_lProperty, float *a_plMinValue, float *a_plMaxValue);
FICOMMON(HRESULT) FiGetCameraPropertyAbsRange(IBaseFilter *a_pBaseFilter, LONG a_lProperty, float *a_plMinValue, float *a_plMaxValue);
FICOMMON(HRESULT) FiSetCameraProperty(IBaseFilter *a_pBaseFilter, LONG a_lProperty, float a_lValue);
FICOMMON(HRESULT) FiSetCameraAbsProperty(IBaseFilter *a_pBaseFilter, LONG a_lProperty, float a_lValue);
FICOMMON(HRESULT) FiSetCameraPropertyFlags(IBaseFilter *a_pBaseFilter,
                                 LONG a_lProperty,
                                 float a_lValue,
                                 LONG a_lFlags);

FICOMMON(HRESULT)       FiRunGraph(IGraphBuilder *a_pFilterGraph);
FICOMMON(HRESULT)       FiStopGraph(IGraphBuilder *a_pFilterGraph);
FICOMMON(HRESULT)       FiPauseGraph(IGraphBuilder *a_pFilterGraph);
FICOMMON(const CHAR*)   FiPixelFormatStringA(FIREi_PIXEL_FORMAT a_PixelFormat);
FICOMMON(const WCHAR*)  FiPixelFormatStringW(FIREi_PIXEL_FORMAT a_PixelFormat);
FICOMMON(const CHAR*)   FiResolutionStringA(FIREi_RES a_Resolution);
FICOMMON(const WCHAR*)  FiResolutionStringW(FIREi_RES a_Resolution);
FICOMMON(const CHAR*)   FiFpsStringA(FIREi_FPS a_Fps);
FICOMMON(const WCHAR*)  FiFpsStringW(FIREi_FPS a_Fps);
FICOMMON(const GUID*)   FiPixelFormatGuid(FIREi_PIXEL_FORMAT a_PixelFormat);
FICOMMON(const SIZE*)   FiResolutionSize(FIREi_RES a_Resolution);
FICOMMON(BOOL)          FiIsScalableFormat(VIDEO_STREAM_CONFIG_CAPS *a_pConfigCaps);
FICOMMON(HRESULT) FiSetupFormat(IBaseFilter *a_pCam,  ULONG a_uFormatIndex, VIDEOINFOHEADER  *a_pVideoInfoHeader);
FICOMMON(HRESULT) FiSetF7PacketSize(IBaseFilter *a_pCam,  ULONG a_uFormatIndex, ULONG a_PacketSize);
FICOMMON(HRESULT) FiGetF7PacketInfo(IBaseFilter *a_pCam,  ULONG a_uFormatIndex, Fi_PACKET_INFO *a_pPacketInfo);
FICOMMON(HRESULT) FiGetF7PacketSize(IBaseFilter *a_pCam,  ULONG a_uFormatIndex, ULONG *a_pPacketSize);
FICOMMON(HRESULT) FiGetF7ColorFilter(IBaseFilter *a_pCam,  ULONG a_uFormatIndex, PFIREi_RAW_MODE a_ColorFilter);
FICOMMON(HRESULT) FiGetRegister(IBaseFilter *a_pCam, LONG a_Offset, LONG *a_pRegValue);
FICOMMON(HRESULT) FiSetRegister(IBaseFilter *a_pCam, LONG a_Offset, LONG a_RegValue);
FICOMMON(HRESULT) FiGetCommandRegBase(IBaseFilter *a_pCam, LONG *a_CommandRegBase);
FICOMMON(HRESULT) FiSetBufferSamples(IBaseFilter *a_pSampleGrabberFilter, BOOL a_bBufferThem);
FICOMMON(HRESULT) FiSetPort(IBaseFilter *a_pNetDumpFilter, DWORD a_XmitPort);
FICOMMON(HRESULT) FiSetProfile(IBaseFilter *a_pNetDumpFilter, ULONG a_ProfileIdx);
FICOMMON(int)     FiPreviewRemoteStream(HWND a_PreviewWindow, LPRECT a_PreviewRect, WCHAR *a_RemoteURL);
FICOMMON(HRESULT) FiSetRawMode(IBaseFilter *a_pYuv2RgbFilter, FIREi_RAW_MODE a_RawMode);
FICOMMON(HRESULT) FiGetRawMode(IBaseFilter *a_pYuv2RgbFilter, FIREi_RAW_MODE *a_RawMode);
FICOMMON(HRESULT) FiSetRawModeConversion(IBaseFilter *a_pYuv2RgbFilter, FIREi_RAW_MODE_CONVERSION a_RawModeConversion);
FICOMMON(HRESULT) FiGetRawModeConversion(IBaseFilter *a_pYuv2RgbFilter, FIREi_RAW_MODE_CONVERSION *a_RawModeConversion);
FICOMMON(HRESULT) FiSetRawConversionCoefficients(IBaseFilter *a_pYuv2RgbFilter, float a_RCoeff, float a_GCoeff, float a_BCoeff);
FICOMMON(HRESULT) FiGetLicenceType(IBaseFilter *a_pCam, FIREi_LICENCE_TYPE *a_LicenceType);
FICOMMON(const CHAR*) FiLicenceTypeStringA(FIREi_LICENCE_TYPE a_LicenceType);
FICOMMON(const WCHAR*) FiLicenceTypeStringW(FIREi_LICENCE_TYPE a_LicenceType);
FICOMMON(HRESULT) FiRelativeToAbsolute(IBaseFilter *a_pBaseFilter, LONG a_lProperty, float a_RelatriveValue, float *a_AbsoluteValue);
FICOMMON(HRESULT) FiAbsoluteToRelative(IBaseFilter *a_pBaseFilter, LONG a_lProperty, float a_AbsoluteValue, float *a_RelativeValue);
//FICOMMON(HRESULT) FiSaveFrameWithStamp(IBaseFilter *a_pYuv2RgbFilter, LPSTR a_szSavePath,
    //WCHAR *a_wszStamp, LPLOGFONT a_pLogFont, COLORREF a_Color, ULONG a_xPos, ULONG a_yPos);
FICOMMON(HRESULT) FiSetCallback(IBaseFilter*, YuvToRgbCallback, FIREi_PIXEL_FORMAT,void*);
FICOMMON(HRESULT) FiConnectFilters(IBaseFilter *,IBaseFilter *, IGraphBuilder *);
FICOMMON(HRESULT) FiFindFilter(IGraphBuilder *, LPCWSTR, IBaseFilter **);
FICOMMON(HRESULT) FiConnectFiltersDirect(IBaseFilter*, IBaseFilter*, FIREi_PIXEL_FORMAT, IGraphBuilder*);
FICOMMON(HRESULT) FiSetFileNameA(IBaseFilter *a_fileWriter,  CHAR *a_fileName, const AM_MEDIA_TYPE *pmt);
FICOMMON(HRESULT) FiSetFileNameW(IBaseFilter *a_fileWriter,  WCHAR *a_fileName, const AM_MEDIA_TYPE *pmt);
FICOMMON(BOOL) FiIsFilterInListA(IBaseFilter *a_filter, CHAR ** a_filterDescriptionList, ULONG a_filterListSize);
FICOMMON(BOOL) FiIsFilterInListW(IBaseFilter *a_filter, WCHAR ** a_filterDescriptionList, ULONG a_filterListSize);
FICOMMON(HRESULT) FiSetYMono16SignificantBits(IBaseFilter *, int);
FICOMMON(HRESULT) FiGetYMono16SignificantBits(IBaseFilter *, int *);
FICOMMON(HRESULT) FiEnable16BitSwap(IBaseFilter *a, BOOL);
FICOMMON(HRESULT) FiIs16BitSwapEnabled(IBaseFilter *, BOOL *);
//FICOMMON(HRESULT) FiGetTriggerInfo(IBaseFilter *, FIREi_TRIGGER_INFO *);
//FICOMMON(HRESULT) FiSetTriggerInfo(IBaseFilter *, FIREi_TRIGGER_INFO &);
//FICOMMON(HRESULT) FiGetTriggerCaps(IBaseFilter *, FIREi_TRIGGER_CAPS *);
//FICOMMON(HRESULT) FiSetSoftwareTrigger(IBaseFilter *, BOOL);
FICOMMON(const CHAR*) FiTriggerModeStringA(FIREi_TRIGGER_MODE a_TriggerMode);
FICOMMON(const WCHAR*) FiTriggerModeStringW(FIREi_TRIGGER_MODE a_TriggerMode);
FICOMMON(const CHAR*) FiTriggerSourceStringA(FIREi_TRIGGER_SOURCE a_TriggerSource);
FICOMMON(const WCHAR*) FiTriggerSourceStringW(FIREi_TRIGGER_SOURCE a_TriggerSource);
FICOMMON(HRESULT) FiReadBlock(IBaseFilter *, LONG, LONG, void *);
FICOMMON(HRESULT) FiWriteBlock(IBaseFilter *, LONG, LONG, void *);
FICOMMON(HRESULT) FiSetCustomRect(IBaseFilter *, ULONG, RECT &);
FICOMMON(HRESULT) FiGetCustomRect(IBaseFilter *, ULONG, RECT *);
FICOMMON(FIREi_CAMERA_MODEL) FiGetCameraModelA(LPCSTR a_szCameraDescription);
FICOMMON(FIREi_CAMERA_MODEL) FiGetCameraModelW(LPCWSTR a_szCameraDescription);
FICOMMON(const CHAR*) FiTimeUnitStringA(FIREi_TIME_UNIT a_TimeUnit);
FICOMMON(const WCHAR*) FiTimeUnitStringW(FIREi_TIME_UNIT a_TimeUnit);
FICOMMON(HRESULT) FiShowVFWCompressorPropertiesA(LPCSTR a_szCompressorName, HWND a_hwnd);
FICOMMON(HRESULT) FiShowVFWCompressorPropertiesW(LPCWSTR a_szCompressorName, HWND a_hwnd);
FICOMMON(int) FiGetTimeBaseFromID(FIREi_TIMEBASE_ID);
FICOMMON(ULONGLONG) FiAvgTPFFromPktSize(ULONG, ULONG);
FICOMMON(ULONG) FiGetCameraImageIndexA(LPCSTR a_szCameraDescription, PFIREi_1394_GUID a_pGUID);
FICOMMON(ULONG) FiGetCameraImageIndexW(LPCWSTR a_szCameraDescription, PFIREi_1394_GUID a_pGUID);
FICOMMON(BOOL) FiInitCameraImageList();
FICOMMON(HIMAGELIST) FiCreateCameraImageList(ULONG);
FICOMMON(BOOL) FiSelectCamera(PFIREi_1394_GUID a_pGUID);