#ifndef _CAMREGISTERS_H_
#define _CAMREGISTERS_H_

typedef struct _INITIALIZE_REGISTER {
        ULONG       Reserved:31;            // Bits 1-31
        ULONG       Initialize:1;           // Bit 0
} INITIALIZE_REGISTER, *PINITIALIZE_REGISTER;

typedef struct _V_FORMAT_INQ_REGISTER {
        ULONG       Reserved:24;            // Bits 8-31
        ULONG       Format7:1;              // Bit 7
        ULONG       Format6:1;              // Bit 6
        ULONG       FormatX:3;              // Bits 3-5
        ULONG       Format2:1;              // Bit 2
        ULONG       Format1:1;              // Bit 1
        ULONG       Format0:1;              // Bit 0
} V_FORMAT_INQ_REGISTER, *PV_FORMAT_INQ_REGISTER;

typedef struct _V_MODE_INQ_REGISTER {
        ULONG       Reserved:24;            // Bits 8-31
        ULONG       ModeX:2;                // Bits 6-7
        ULONG       Mode5:1;                // Bit 5
        ULONG       Mode4:1;                // Bit 4
        ULONG       Mode3:1;                // Bit 3
        ULONG       Mode2:1;                // Bit 2
        ULONG       Mode1:1;                // Bit 1
        ULONG       Mode0:1;                // Bit 0
} V_MODE_INQ_REGISTER, *PV_MODE_INQ_REGISTER;

typedef struct _V_RATE_INQ_REGISTER {
        ULONG       Reserved:24;            // Bits 8-31
        ULONG       FrameRateX:2;           // Bits 6-7
        ULONG       FrameRate5:1;           // Bit 5
        ULONG       FrameRate4:1;           // Bit 4
        ULONG       FrameRate3:1;           // Bit 3
        ULONG       FrameRate2:1;           // Bit 2
        ULONG       FrameRate1:1;           // Bit 1
        ULONG       FrameRate0:1;           // Bit 0
} V_RATE_INQ_REGISTER, *PV_RATE_INQ_REGISTER;


typedef struct _FEATURE_PRESENT1 {
        ULONG       Reserved:21;            // Bits 11-31
        ULONG       Focus:1;                // Bit 10
        ULONG       Iris:1;                 // Bit 9
        ULONG       Gain:1;                 // Bit 8
        ULONG       Shutter:1;              // Bit 7
        ULONG       Gamma:1;                // Bit 6
        ULONG       Saturation:1;           // Bit 5
        ULONG       Hue:1;                  // Bit 4
        ULONG       White_Balance:1;        // Bit 3
        ULONG       Sharpness:1;            // Bit 2
        ULONG       Exposure:1;             // Bit 1
        ULONG       Brightness:1;           // Bit 0
} FEATURE_PRESENT1, *PFEATURE_PRESENT1;

typedef struct _FEATURE_PRESENT2 {
        ULONG       Reserved:29;            // Bits 3-31
        ULONG       Tile:1;                 // Bit 2
        ULONG       Pan:1;                  // Bit 1
        ULONG       Zoom:1;                 // Bit 0
} FEATURE_PRESENT2, *PFEATURE_PRESENT2;

typedef struct _FEATURE_REGISTER {
        ULONG       MAX_Value:12;           // Bits 20-31
        ULONG       MIN_Value:12;           // Bits 8-19
        ULONG       ManualMode:1;           // Bit  7
        ULONG       AutoMode:1;             // Bit  6
        ULONG       OnOff:1;                // Bit  5
        ULONG       ReadOut_Inq:1;          // Bit  4
        ULONG       OnePush:1;              // Bit  3
        ULONG       Reserved:1;             // Bits 2
        ULONG       AbsControlInq:1;        // Bit  1
        ULONG       PresenceInq:1;          // Bit 0
} FEATURE_REGISTER, *PFEATURE_REGISTER;

typedef struct _BRIGHTNESS_REGISTER {
        ULONG       Value:12;               // Bits 20-31
        ULONG       Reserved1:12;           // Bits 8-19
        ULONG       AutoMode:1;             // Bit  7
        ULONG       OnOff:1;                // Bit  6
        ULONG       OnePush:1;              // Bit  5
        ULONG       Reserved2:3;            // Bits 2-4
        ULONG       AbsControl:1;           // Bit  1
        ULONG       PresenceInq:1;          // Bit  0
} BRIGHTNESS_REGISTER, *PBRIGHTNESS_REGISTER;

typedef struct _WHITE_BALANCE_REGISTER 
{
        ULONG       VValue:12;              // Bits 20-31
        ULONG       UValue:12;              // Bits 8-19
        ULONG       AutoMode:1;             // Bit  7
        ULONG       OnOff:1;                // Bit  6
        ULONG       OnePush:1;              // Bit  5
        ULONG       Reserved1:3;            // Bits 2-4
        ULONG       AbsControl:1;           // Bit  1
        ULONG       PresenceInq:1;          // Bit  0
} WHITE_BALANCE_REGISTER, *PWHITE_BALANCE_REGISTER;

typedef struct _ISO_ENABLE_REGISTER
{
        ULONG       Reserved:31;            // Bits 1..31
        ULONG       IsoEn:1;                // Bit  0
}ISO_ENABLE_REGISTER, *PISO_ENABLE_REGISTER;

typedef struct _CUR_V_FORMAT_REGISTER
{
        ULONG       Reserved:29;            // Bits 3..31
        ULONG       CurVFormat:3;           // Bits 0..2
}CUR_V_FORMAT_REGISTER , *PCUR_V_FORMAT_REGISTER;

typedef struct _CUR_V_MODE_REGISTER
{
        ULONG       Reserved:29;            // Bits 3..31
        ULONG       CurVMode:3;             // Bits 0..2
}CUR_V_MODE_REGISTER , *PCUR_V_MODE_REGISTER;

typedef struct _CUR_V_FRAME_RATE_REGISTER
{
        ULONG       Reserved:29;            // Bits 3..31
        ULONG       CurVFrameRate:3;        // Bits 0..2
}CUR_V_FRAME_RATE_REGISTER , *PCUR_V_FRAME_RATE_REGISTER;

typedef union
{
    struct
    {
        ULONG       IsoSpeedB:3;       // Bits 29..31
        ULONG       Reserved1:5;       // Bits 24..28
        ULONG       IsoChannelB:6;     // Bits 18..23
        ULONG       Reserved2:1;       // Bit  17
        ULONG       OperationMode:1;   // Bit  16
        ULONG       Reserved3:8;       // Bits 8..15
        ULONG       IsoSpeed:2;        // Bits 6..7
        ULONG       Reserved4:2;       // Bits 4..5 
        ULONG       IsoChannel:4;      // Bits 0..3  
    };
    ULONG AsULONG;
}CHANNEL_SPEED_REGISTER , *PCHANNEL_SPEED_REGISTER;

typedef union
{
    struct
    {
        ULONG       Reserved:21;                // Bits 11 - 31
        ULONG       Raw16:1;                    // Bit  10
        ULONG       Raw8:1;                     // Bit  9
        ULONG       SignedRGB16:1;              // Bit  8
        ULONG       SignedMono16:1;             // Bit  7
        ULONG       RGB16:1;                    // Bit  6
        ULONG       Mono16:1;                   // Bit  5
        ULONG       RGB8:1;                     // Bit  4
        ULONG       Y444:1;                     // Bit  3
        ULONG       Y422:1;                     // Bit  2
        ULONG       Y411:1;                     // Bit  1
        ULONG       Mono8:1;                    // Bit  0
    };
    ULONG   AsULONG;
}COLOR_CODING_INQ,*PCOLOR_CODING_INQ;

typedef union
{
    struct
    {
        ULONG       Reserved:24;                // Bits 8 - 31
        ULONG       Coding_ID:8;                // Bits 0 - 7
    };
    ULONG   AsULONG;
}COLOR_CODING_ID,*PCOLOR_CODING_ID;

typedef union
{
    struct
    {
        ULONG       Reserved:24;                // Bits 8 - 31
        ULONG       DataDepth:8;                // Bit  0 - 7
    };
    ULONG   AsULONG;
}DATA_DEPTH_INQ, *PDATA_DEPTH_INQ;

typedef union
{
    struct
    {
        ULONG       Reserved:24;                // Bits 16 - 31
        ULONG       PixelFormat:8;              // Bit  0  - 7
    };
    ULONG   AsULONG;
}COLOR_CODING_REG, *PCOLOR_CODING_REG;

typedef union
{
    struct
    {
        ULONG       Reserved:24;                // Bits 8 - 31
        ULONG       ColorFilter:8;              // Bit  0 - 7
    };
    ULONG   AsULONG;
}COLOR_FILTER_REG, *PCOLOR_FILTER_REG;

typedef union
{
    struct
    {
        ULONG       MaxVertical:16;             // Bits 16 - 31
        ULONG       MaxHorizontal:16;           // Bit  0  - 15
    };
    ULONG   AsULONG;
}F7_IMAGE_SIZE_INQ_REG, *PF7_IMAGE_SIZE_INQ_REG;

typedef union
{
    struct
    {
        ULONG       VerticalUnit:16;            // Bits 16 - 31
        ULONG       HorizontalUnit:16;          // Bit  0  - 15
    };
    ULONG   AsULONG;
}F7_UNIT_SIZE_INQ_REG, *PF7_UNIT_SIZE_INQ_REG;

typedef union
{
    struct
    {
        ULONG       TopPos:16;                  // Bits 16 - 31
        ULONG       LeftPos:16;                 // Bit  0  - 15
    };
    ULONG   AsULONG;
}F7_IMAGE_POS_REG, *PF7_IMAGE_POS_REG;

typedef union
{
    struct 
    {
        ULONG       ImageHeight:16;             // Bits 16 - 31
        ULONG       ImageWidth:16;              // Bit  0  - 15
    };
    ULONG   AsULONG;
}F7_IMAGE_SIZE_REG, *PF7_IMAGE_SIZE_REG;

typedef union
{
    struct 
    {
        ULONG       MaxBytesPerPacket:16;       // Bits 16 - 31
        ULONG       UnitBytesPerPacket:16;      // Bit  0  - 15
    };
    ULONG   AsULONG;
}F7_BYTES_PER_PACKET_INQ_REG, *PF7_BYTES_PER_PACKET_INQ_REG;

typedef union
{
    struct
    {
        ULONG       VerticalUnitPosition:16;    // Bits 16 - 31
        ULONG       HorizontalUnitPosition:16;  // Bit  0  - 15
    };
    ULONG   AsULONG;
}F7_UNIT_POS_INQ_REG, *PF7_UNIT_POS_INQ_REG;

typedef union
{
    struct
    {
        ULONG       RecPacketBytes:16;          // Bits 16 - 31
        ULONG       PacketSize:16;              // Bit  0  - 15
    };
    ULONG AsULONG;
}F7_BYTES_PER_PACKET_REG, *PF7_BYTES_PER_PACKET_REG;

typedef union
{
    struct
    {
        ULONG       Reserved2:22;               // Bit  10 - 31    
        ULONG       ErrorFlag_2:1;              // Bit  9
        ULONG       ErrorFlag_1:1;              // Bit  8
        ULONG       Reserved1:6;                // Bit  2 - 7
        ULONG       Setting_1:1;                // Bit  1
        ULONG       Presence:1;                 // Bit  0  
    };
    ULONG   AsULONG;
}F7_VALUE_SETTING_REG, *PF7_VALUE_SETTING_REG;

typedef union
{
    struct
    {
        ULONG       Parameter:12;               // Bit 20 - 31
        ULONG       Reserved0:4;                // Bit 16 - 19 
		ULONG       TriggerMode:4;              // Bit 12 - 15
		ULONG       TriggerValue:1;             // Bit 11
		ULONG       TriggerSource:3;            // Bit 8 - 10
		ULONG       TriggerPolarity:1;          // Bit 7
		ULONG       OnOff:1;                    // Bit 6
		ULONG       Reserved1:4;                // Bit 2  - 5
		ULONG       AbsControl:1;               // 1
		ULONG       Presence:1;                 // 0
    };
    ULONG   AsULONG;
}TRIGGER_REG, *PTRIGGER_REG;

typedef union
{
    struct
    {
        ULONG       TriggerMode:16;             // Bit 16 - 31
		ULONG       TriggerSource:8;            // Bit 8  - 15
		ULONG       ValueRead:1;                // Bit 7
		ULONG       Polarity:1;                 // Bit 6
		ULONG       OnOff:1;                    // Bit 5
		ULONG       ReadOut:1;                  // Bit 4
		ULONG       Reserved2:2;                // Bit 2 - 3
		ULONG       AbsControl:1;               // Bit 1
		ULONG       Presence:1;                 // Bit 0
    };
    ULONG   AsULONG;
}TRIGGER_INQ_REG, *PTRIGGER_INQ_REG;

typedef union
{
    struct
    {
		ULONG       Reserved:31;               // Bit 1 - 31
		ULONG       SoftwareTrigger:1;         // Bit 0
    };
    ULONG   AsULONG;
}SOFTWARE_TRIGGER_REG, *PSOFTWARE_TRIGGER_REG;

// A common structure so it is easier to access its elements.
typedef union _CAM_REGISTER
{
    INITIALIZE_REGISTER         Initialize;
    V_FORMAT_INQ_REGISTER       VFormat;
    V_MODE_INQ_REGISTER         VMode;
    V_RATE_INQ_REGISTER         VRate;
    BRIGHTNESS_REGISTER         Brightness;
    WHITE_BALANCE_REGISTER      WhiteBalance;
    FEATURE_REGISTER            Feature;
    FEATURE_PRESENT1            CameraCap1;
    FEATURE_PRESENT2            CameraCap2;
    F7_IMAGE_SIZE_INQ_REG       F7ImageSizeInq;
    F7_UNIT_SIZE_INQ_REG        F7UnitSizeInq;
    F7_IMAGE_POS_REG            F7ImagePos;
    F7_IMAGE_SIZE_REG           F7ImageSize;
    F7_BYTES_PER_PACKET_INQ_REG F7BytesPerPackInq;
    F7_BYTES_PER_PACKET_REG     F7BytesPerPacket;
    F7_UNIT_POS_INQ_REG         F7UnitPosInq;
    COLOR_CODING_INQ            ColorCodingInq;
    COLOR_CODING_REG            ColorCoding;
    COLOR_FILTER_REG            ColorFilterID;
    F7_VALUE_SETTING_REG        ValueSetting;
	TRIGGER_REG                 Trigger;
    ISO_ENABLE_REGISTER         IsoEnable;
    CUR_V_FORMAT_REGISTER       CurVFormat;
    CUR_V_MODE_REGISTER         CurVMode;
    CUR_V_FRAME_RATE_REGISTER   CurVFrameRate;
    CHANNEL_SPEED_REGISTER      ChannelSpeed;
    ULONG                       AsULONG;
} CAM_REGISTER, * PCAM_REGISTER;

//
// Structure of the camera's register space
//

typedef struct _CAMERA_REGISTER_MAP {
    INITIALIZE_REGISTER     Initialize;                 // @ 0
    //------------------------------------------------------------------
    ULONG                   Reserved1[63];              // @ 4
    //------------------------------------------------------------------
    V_FORMAT_INQ_REGISTER   VFormat;                    // @ 100
    //------------------------------------------------------------------
    ULONG                   Reserved2[31];              // @ 104
    //------------------------------------------------------------------
    V_MODE_INQ_REGISTER     VModeInq[8];                // @ 180-19f
    //------------------------------------------------------------------
    ULONG                   Reserved3[24];              // @ 1A0-1ff
    //------------------------------------------------------------------
    V_RATE_INQ_REGISTER     VRateInq[128];              // @ 200-3ff
    //------------------------------------------------------------------
    ULONG                   Reserved4;                  // @ 400-4ff
    //------------------------------------------------------------------
    FEATURE_PRESENT1        FeaturePresent1;            // @ 404
    FEATURE_PRESENT2        FeaturePresent2;            // @ 408
    //------------------------------------------------------------------
    ULONG                   Reserved4b[61];             // @ 40c-4ff
    //------------------------------------------------------------------
    FEATURE_REGISTER        Brightness_Inq;             // @ 500-503
    FEATURE_REGISTER        Exposure_Inq;               // @ 504
    FEATURE_REGISTER        Sharpness_Inq;              // @ 508
    FEATURE_REGISTER        WhiteBalance_Inq;           // @ 50c
    FEATURE_REGISTER        Hue_Inq;                    // @ 510
    FEATURE_REGISTER        Saturation_Inq;             // @ 514
    FEATURE_REGISTER        Gamma_Inq;                  // @ 518
    FEATURE_REGISTER        Shutter_Inq;                // @ 51c
    FEATURE_REGISTER        Gain_Inq;                   // @ 520
    FEATURE_REGISTER        Iris_Inq;                   // @ 524
    FEATURE_REGISTER        Focus_Inq;                  // @ 528
    ULONG                   Temperature_Ing;            // @ 52c
    ULONG                   Trigger_Inq;                // @ 530
    //------------------------------------------------------------------
    ULONG                   Resreved5[(0x580-0x534)/4]; // @ 534-57c
    //------------------------------------------------------------------
    FEATURE_REGISTER        Zoom_Inq;                   // @ 580
    FEATURE_REGISTER        Pan_Inq;                    // @ 584
    FEATURE_REGISTER        Tilt_Inq;                   // @ 588-58b
    //------------------------------------------------------------------
    ULONG                   Reserved6[(0x600-0x58c)/4]; // @ 58c-5ff
    //------------------------------------------------------------------
    //------------------------------------------------------------------
    // Status and control register for camera
    //------------------------------------------------------------------
    ULONG                   CurrentVFrmRate;            // @ 600
    ULONG                   CurrentVMode;               // @ 604
    ULONG                   CurrentVFormat;             // @ 608
    ULONG                   IsoChannel;                 // @ 60C
    ULONG                   CameraPower;                // @ 610
    ULONG                   IsoEnable;                  // @ 614
    ULONG                   MemorySave;                 // @ 618
    ULONG                   OneShot;                    // @ 61C
    ULONG                   MemorySaveChannel;          // @ 620
    ULONG                   CurrentMemChannel;          // @ 624
    ULONG                   VModeErrorStatus;           // @ 628
    ULONG                   SoftwareTrigger;            // @ 62C
    //------------------------------------------------------------------
    ULONG                   Reserved7[(0x700-0x630)/4]; // @ 630-6ff
    //------------------------------------------------------------------
    //------------------------------------------------------------------
    // Inquiry register for Absolute value CSR Offset address
    //------------------------------------------------------------------
    ULONG                   Brightness_Abs_Offset;      // @700
    ULONG                   Exposure_Abs_Offset;        // @704
    ULONG                   Sharpness_Abs_Offset;       // @708
    ULONG                   WhiteBalance_Abs_Offset;    // @70C
    ULONG                   Hue_Abs_Offset;             // @710
    ULONG                   Saturation_Abs_Offset;      // @714
    ULONG                   Gamma_Abs_Offset;           // @718
    ULONG                   Shutter_Abs_Offset;         // @71C
    ULONG                   Gain_Abs_Offset;            // @720
    ULONG                   Iris_Abs_Offset;            // @724
    ULONG                   Focus_Abs_Offset;           // @728
    ULONG                   Temperature_Abs_Offset;     // @72C
    ULONG                   Trigger_Abs_Offset;         // @730
    ULONG                   TriggerDelay_Abs_Offset;    // @734
    ULONG                   WhiteShading_Abs_Offset;    // @738
    ULONG                   FrameTime_Abs_Offset;       // @73C
    //------------------------------------------------------------------
    ULONG                   Reserved8[(0x780-0x740)/4]; // @ 740-77f
    //------------------------------------------------------------------
    ULONG                   Zoom_Abs_Offset;            // @780
    ULONG                   Pan_Abs_Offset;             // @784
    ULONG                   Tilt_Abs_Offset;            // @788
    ULONG                   OpticalFilter_Abs_Offset;   // @78C
    //------------------------------------------------------------------
    ULONG                   Reserved9[(0x7C0-0x790)/4]; // @ 790-7bf
    //------------------------------------------------------------------
    ULONG                   CaptureSize_Abs_Offset;     // @7C0
    ULONG                   CaptureQuality_Abs_Offset;  // @7C4
    //------------------------------------------------------------------
    ULONG                   Reserved10[(0x800-0x7C8)/4];// @ 7C8-7ff
    //------------------------------------------------------------------
    //------------------------------------------------------------------
    // Status and control register for feature
    //------------------------------------------------------------------
    BRIGHTNESS_REGISTER     Brightness;                 // @ 800
    BRIGHTNESS_REGISTER     Exposure;                   // @ 804
    BRIGHTNESS_REGISTER     Sharpness;                  // @ 808
    WHITE_BALANCE_REGISTER  WhiteBalance;               // @ 80C
    BRIGHTNESS_REGISTER     Hue;                        // @ 810
    BRIGHTNESS_REGISTER     Saturation;                 // @ 814
    BRIGHTNESS_REGISTER     Gamma;                      // @ 818
    BRIGHTNESS_REGISTER     Shutter;                    // @ 81C
    BRIGHTNESS_REGISTER     Gain;                       // @ 820
    BRIGHTNESS_REGISTER     Iris;                       // @ 824
    BRIGHTNESS_REGISTER     Focus;                      // @ 828
    BRIGHTNESS_REGISTER     Temperature;                // @ 82C
    BRIGHTNESS_REGISTER     Trigger;                    // @ 830
    //------------------------------------------------------------------
    ULONG                   Reserved11[(0x880-0x834)/4]; // @ 834-87c
    //------------------------------------------------------------------
    BRIGHTNESS_REGISTER     Zoom;                       // @ 880
    BRIGHTNESS_REGISTER     Pan;                        // @ 884
    BRIGHTNESS_REGISTER     Tilt;                       // @ 888
} CAMERA_REGISTER_MAP, *PCAMERA_REGISTER_MAP;

typedef struct _FORMAT_7_MODE_MAP
{
    F7_IMAGE_SIZE_INQ_REG       MaxImageSize_Inq;    // @ 000
    F7_UNIT_SIZE_INQ_REG        UnitSize_Inq;        // @ 004
    F7_IMAGE_POS_REG            ImagePosition;       // @ 008
    F7_IMAGE_SIZE_REG           ImageSize;           // @ 00C
    COLOR_CODING_ID             ColorCodingID;       // @ 010
    COLOR_CODING_INQ            ColorCoding_Inq;     // @ 014
    ULONG                       Reserved1[7];        // @ 018 - 033
    ULONG                       PixelNumber_Inq;     // @ 034
    ULONG                       TotalBytesHi_Inq;    // @ 038
    ULONG                       TotalBytesLo_Inq;    // @ 03C
    F7_BYTES_PER_PACKET_INQ_REG BytesPerPacket_Inq;  // @ 040
    F7_BYTES_PER_PACKET_REG     BytesPerPacket;      // @ 044
    ULONG                       PacketsPerFrame_Inq; // @ 048
    F7_UNIT_POS_INQ_REG         UnitPosition_Inq;    // @ 04c
    ULONG                       FrameInterval_Inq;   // @ 050
    DATA_DEPTH_INQ              DataDepth_Inq;       // @ 054
    COLOR_FILTER_REG            ColorFilterID;       // @ 058
    ULONG                       Reserved2[8];        // @ 05c - 07b
    F7_VALUE_SETTING_REG        ValueSetting;        // @ 07c
}FORMAT_7_MODE_MAP, *PFORMAT_7_MODE_MAP;

#define TIMEBASE_REG_OFFSET 0xf1000208

typedef union
{
    struct
    {
        ULONG       TimeBaseID:4;    // Bit  28 - 31    
        ULONG       Reserved:27;     // Bit  1  - 27
        ULONG       Presence:1;      // Bit  0  
    };
    ULONG   AsULONG;
}AVT_TIMEBASE_REG, *PAVT_TIMEBASE_REG;

typedef union
{
    struct 
    {
        ULONG CRC:16;    // Bits 16 - 31
        ULONG Length:16; // Bits  0 - 15
    };
    ULONG AsULONG;
}CONFIG_ROM_DIRECTORY_HEADER , *PCONFIG_ROM_DIRECTORY_HEADER;

typedef union
{
    struct 
    {
        ULONG Value:24;  // Bits  8 - 31
        ULONG Key:8;     // Bits  0 - 7
    };
    ULONG AsULONG;
}CONFIG_ROM_KEY_REGISTER , *PCONFIG_ROM_KEY_REGISTER;

typedef struct
{
    CONFIG_ROM_DIRECTORY_HEADER Header;
    CONFIG_ROM_KEY_REGISTER     Keys[1];
}CONFIG_ROM_DIRECTORY , *PCONFIG_ROM_DIRECTORY;

typedef struct
{
    CONFIG_ROM_DIRECTORY_HEADER Header;
    ULONG                       SpecID;
    ULONG                       LanguageID;
    UCHAR                       Text[1];
}CONFIG_ROM_TEXTUAL_LEAF , *PCONFIG_ROM_TEXTUAL_LEAF;

typedef struct
{
    BOOL IsoSize_S400_Inq;
    BOOL OnOff_S400;
    BOOL Set2Max_S400;
    USHORT MaxIsoSize_S400;
    BOOL IsoSize_S800_Inq;
    BOOL OnOff_S800;
    BOOL Set2Max_S800;
    USHORT MaxIsoSize_S800;
} JUMBO_PACKETS_CAPS, *PJUMBO_PACKETS_CAPS;

#endif //_CAMREGISTERS_H_
