//---------------------------------------------------------------------------
#include <stdlib.h>
#pragma hdrstop

#include "PrologSources.h"
#include "editing_esf.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
static char* BuiltInPrefix = "Built in ";

//---------------------------------------------------------------------------
TPrologSources::TPrologSources()
{
	Sources.push_back(editing_esf);
}

//---------------------------------------------------------------------------
char* TPrologSources::GetSource(unsigned int Index)
{
	if (Index < Sources.size())
	{
		return Sources[Index];
	}
	else
	{
		return NULL;
	}
}

//---------------------------------------------------------------------------
char* TPrologSources::GetSource(const char* Name)
{
	if (!IsBuiltIn(Name))
	{
		return NULL;
	}
	return GetSource(atoi(Name + strlen(BuiltInPrefix)));
}

//---------------------------------------------------------------------------
char* TPrologSources::GetBuiltInPrefix()
{
	return BuiltInPrefix;
}

//---------------------------------------------------------------------------
bool TPrologSources::IsBuiltIn(const char* Name)
{
	return !strncmp(BuiltInPrefix, Name, strlen(BuiltInPrefix));
}

