char* editing_esf = "\
\n\
\n\
test_person_activity_step(C, A, B, F, D) :-\n\
	(   A=<B\n\
	->  (   evaluate_person_activity(A, C, E)\n\
	    ->  export(graph, A, [ (color, D), (value, E)])\n\
	    ;   true\n\
	    ),\n\
	    G is A+F,\n\
	    test_person_activity_step(C, G, B, F, D)\n\
	).\n\
\n\
\n\
head(A, B, C) :-\n\
	head(A, B, _, _, _, _, _, _, _, C).\n\
\n\
\n\
realtime_step(A, D) :-\n\
	find_best_camera(A, B, C),\n\
	insert_output(A, B, C, D).\n\
\n\
\n\
person_rule(A, C, G, B, N) :-\n\
	A=p_past_head_moving,\n\
	rule_configuration(A, E, K, L),\n\
	camera(B, _, _, _, _, F, _),\n\
	step(D),\n\
	head_moves(C, -D, E, F, G, H),\n\
	sumlist(H, I),\n\
	J is I/E,\n\
	J>=K,\n\
	(   J>L\n\
	->  M is L\n\
	;   M is J\n\
	),\n\
	N is (M-K)/ (L-K).\n\
person_rule(A, C, G, B, N) :-\n\
	A=p_future_head_moving,\n\
	rule_configuration(A, E, K, L),\n\
	camera(B, _, _, _, _, F, _),\n\
	step(D),\n\
	head_moves(C, D, E, F, G, H),\n\
	sumlist(H, I),\n\
	J is I/E,\n\
	J>=K,\n\
	(   J>L\n\
	->  M is L\n\
	;   M is J\n\
	),\n\
	N is (M-K)/ (L-K).\n\
person_rule(A, C, G, B, Q) :-\n\
	A=p_future_past_head_moving,\n\
	rule_configuration(A, I, E, N, O),\n\
	camera(B, _, _, _, _, F, _),\n\
	step(D),\n\
	head_moves(C, D, E, F, G, H),\n\
	sumlist(H, K),\n\
	head_moves(C, -D, I, F, G, J),\n\
	sumlist(J, L),\n\
	M is (K+L)/ (E+I),\n\
	M>=N,\n\
	(   M>O\n\
	->  P is O\n\
	;   P is M\n\
	),\n\
	Q is (P-N)/ (O-N).\n\
person_rule(A, C, G, B, N) :-\n\
	A=p_past_hand_moving,\n\
	rule_configuration(A, E, K, L),\n\
	camera(B, _, _, _, _, F, _),\n\
	step(D),\n\
	hand_moves(C, -D, E, F, G, H),\n\
	sumlist(H, I),\n\
	J is I/E,\n\
	J>=K,\n\
	(   J>L\n\
	->  M is L\n\
	;   M is J\n\
	),\n\
	N is (M-K)/ (L-K).\n\
person_rule(A, C, G, B, N) :-\n\
	A=p_future_hand_moving,\n\
	rule_configuration(A, E, K, L),\n\
	camera(B, _, _, _, _, F, _),\n\
	step(D),\n\
	hand_moves(C, D, E, F, G, H),\n\
	sumlist(H, I),\n\
	J is I/E,\n\
	J>=K,\n\
	(   J>L\n\
	->  M is L\n\
	;   M is J\n\
	),\n\
	N is (M-K)/ (L-K).\n\
person_rule(A, C, G, B, Q) :-\n\
	A=p_future_past_hand_moving,\n\
	rule_configuration(A, I, E, N, O),\n\
	camera(B, _, _, _, _, F, _),\n\
	step(D),\n\
	hand_moves(C, D, E, F, G, H),\n\
	sumlist(H, K),\n\
	hand_moves(C, -D, I, F, G, J),\n\
	sumlist(J, L),\n\
	M is (K+L)/ (E+I),\n\
	M>=N,\n\
	(   M>O\n\
	->  P is O\n\
	;   P is M\n\
	),\n\
	Q is (P-N)/ (O-N).\n\
\n\
\n\
output_rule(A, B, C, D, E, _) :-\n\
	output_rule(A, B, C, D, E).\n\
output_rule(A, _, _, E, H1, C) :-\n\
	model_state(presentation),\n\
	A=o_pip_background_camera,\n\
	rule_configuration(A, B, Z, A1, B1, C1, D1, E1, F1, G1),\n\
	member((B, _), C),\n\
	not((\n\
	    member((D, _), C),\n\
	    (   is_empty_camera(D)\n\
	    ;   D==3\n\
	    ;   D=4\n\
	    )\n\
	    )),\n\
	member(('Camera', F), E),\n\
	F>=0,\n\
	perspective_virtual_camera(B, H, J, L, M, N, O, P, Q, _),\n\
	parent_camera(B, G),\n\
	camera(G, I, K),\n\
	R is H/I,\n\
	S is J/K,\n\
	T is L/I,\n\
	U is M/K,\n\
	V is N/I,\n\
	W is O/K,\n\
	X is P/I,\n\
	Y is Q/K,\n\
	append(E, [ ('EffectPBC1', 'StackPBC1'), ('StackPBC1Camera', 1000000), ('EffectPBC2', 'BasicPBC2'), ('BasicPBC2Camera', G), ('EffectPBC3', 'PerspectivePBC3'), ('PerspectivePBC3X1', R), ('PerspectivePBC3Y1', S), ('PerspectivePBC3X2', T), ('PerspectivePBC3Y2', U), ('PerspectivePBC3X3', V), ('PerspectivePBC3Y3', W), ('PerspectivePBC3X4', X), ('PerspectivePBC3Y4', Y), ('EffectPBC4', 'StackPBC4'), ('StackPBC4Camera', 1000001), ('EffectPBC5', 'BasicPBC5'), ('BasicPBC5Camera', 1000002), ('EffectPBC6', 'PIPPBC6'), ('PIPPBC6Camera', 1000001), ('PIPPBC6CenterX', Z), ('PIPPBC6CenterY', A1), ('PIPPBC6RatioX', B1), ('PIPPBC6RatioY', C1), ('EffectPBC7', 'PIPPBC7'), ('PIPPBC7Camera', 1000000), ('PIPPBC7CenterX', D1), ('PIPPBC7CenterY', E1), ('PIPPBC7RatioX', F1), ('PIPPBC7RatioY', G1)], H1).\n\
output_rule(A, _, _, B, I, _) :-\n\
	A=o_logo1,\n\
	rule_configuration(A, D, E, F, G, H),\n\
	member(('Camera', C), B),\n\
	not(is_empty_camera(C)),\n\
	model_state(presentation),\n\
	append(B, [ ('EffectL1', 'PIPL1'), ('PIPL1Camera', D), ('PIPL1CenterX', E), ('PIPL1CenterY', F), ('PIPL1RatioX', G), ('PIPL1RatioY', H), ('PIPL1Transparent', 1)], I).\n\
output_rule(A, _, _, B, I, _) :-\n\
	A=o_logo2,\n\
	rule_configuration(A, D, E, F, G, H),\n\
	member(('Camera', C), B),\n\
	not(is_empty_camera(C)),\n\
	model_state(presentation),\n\
	append(B, [ ('EffectL2', 'PIPL2'), ('PIPL2Camera', D), ('PIPL2CenterX', E), ('PIPL2CenterY', F), ('PIPL2RatioX', G), ('PIPL2RatioY', H), ('PIPL2Transparent', 1)], I).\n\
output_rule(A, _, _, B, I, _) :-\n\
	A=o_logo,\n\
	model_state(presentation),\n\
	member(('Camera', C), B),\n\
	not(is_empty_camera(C)),\n\
	bagof((D, E, F, G, H), D^E^F^G^H^rule_configuration(A, D, E, F, G, H), J),\n\
	output_rule_logo(B, I, J, 1).\n\
\n\
\n\
is_silverscreen_virtual_camera_id(A) :-\n\
	B is A mod 10000,\n\
	B>=400,\n\
	B<500.\n\
\n\
\n\
find_best_camera(A, E, B) :-\n\
	evaluate_cameras(A, B),\n\
	find_max_cameras(B, C),\n\
	length(C, D),\n\
	(   D=:=0\n\
	->  fail\n\
	;   D=:=1\n\
	->  nth0(0, C, (E, _))\n\
	;   last_output_optimized(A, F),\n\
	    member((F, _), C)\n\
	->  E=F\n\
	;   G is random(D),\n\
	    nth0(G, C, (E, _))\n\
	).\n\
\n\
\n\
test_person_rule(A, B) :-\n\
	test_person_rule(A, B, 0).\n\
\n\
\n\
set_virtual_camera_timeX(H) :-\n\
	ignore(forall((virtual_camera(B, A, C, D, E), is_moving_virtual_camera_id(A)), (retractall(virtual_camera(B, A, C, D, E)), retractall(virtual_camera_size(B, A, _, _))))),\n\
	ignore(forall((camera(F, _, _, _, _, B, _), B==F, once(moving_virtual_camera(_, F, _, _, _, _, _, _))), forall(person(G), (moving_virtual_camera_id(G, A), last_moving_virtual_camera(H, F, A, C, D, E, I, J)->assert(virtual_camera(F, A, C, D, E)), assert(virtual_camera_size(F, A, I, J));true)))).\n\
\n\
\n\
moving_virtual_camera_id(A, B) :-\n\
	char_type(A, xdigit(C)),\n\
	B is 200+C-10.\n\
\n\
\n\
start_speaking1(A, B) :-\n\
	person_interactivity(A, B, C),\n\
	get_parameter(C, interactivity, D),\n\
	(   D=talking\n\
	;   D=laughing\n\
	).\n\
\n\
\n\
hand(A, B, C, F, D, E) :-\n\
	hand(A, B, C, D, E, _, _, _, _, F).\n\
\n\
\n\
is_speaking(B, C, A) :-\n\
	bagof(A, is_speaking_all(B, C, A), D),\n\
	maxlist(D, A).\n\
\n\
\n\
head0(A, C, D, E, F, G, H, I, J, K) :-\n\
	event_head(A, B),\n\
	get_parameter(B, camera, C),\n\
	get_parameter(B, object, D),\n\
	get_parameter(B, centerx, E),\n\
	get_parameter(B, centery, F),\n\
	get_parameter(B, minx, G),\n\
	get_parameter(B, miny, H),\n\
	get_parameter(B, maxx, I),\n\
	get_parameter(B, maxy, J),\n\
	get_parameter(B, person, K).\n\
\n\
\n\
evaluation_est :-\n\
	clear_eval_value(shot_count),\n\
	clear_eval_value(shot_short),\n\
	clear_eval_value(shot_long),\n\
	clear_eval_value(shot_vsp),\n\
	clear_eval_value(shot_vpr),\n\
	clear_eval_value(shot_move),\n\
	begin(A),\n\
	end(B),\n\
	step(C),\n\
	ignore(evaluation_est_step(A, B, C)),\n\
	print_eval_value(shot_count),\n\
	print_eval_value(shot_short),\n\
	print_eval_value(shot_long),\n\
	print_eval_value(shot_vsp),\n\
	print_eval_value(shot_vpr),\n\
	print_eval_value(shot_move),\n\
	print_eval_perc2([shot_short, shot_long, shot_vsp, shot_vpr, shot_move], shot_count).\n\
\n\
\n\
pred_last_output(B, D, E, F) :-\n\
	once((\n\
	    output(A, C, _),\n\
	    A=<B\n\
	    )),\n\
	(   C\\=D\n\
	->  E=C,\n\
	    F is 0\n\
	;   once((\n\
		output(G, E, _),\n\
		G=<A,\n\
		E\\=C\n\
		))\n\
	->  findall(H, H^I^ (output(H, C, I), H>G, H=<A), J),\n\
	    last(J, K),\n\
	    F is B-K\n\
	;   fail\n\
	).\n\
\n\
\n\
person_interactivity(A, C, B) :-\n\
	(   event_person1_interactivity(A, B),\n\
	    C=a\n\
	;   event_person2_interactivity(A, B),\n\
	    C=b\n\
	;   event_person3_interactivity(A, B),\n\
	    C=c\n\
	;   event_person4_interactivity(A, B),\n\
	    C=d\n\
	).\n\
\n\
\n\
virtual_camera_percent_rel(A, B, C, D, G) :-\n\
	virtual_camera(A, B, C, E, H),\n\
	camera(A, _, _, F, I),\n\
	D is E/F,\n\
	G is H/I.\n\
\n\
\n\
init_silverscreen_virtual_cameras(_) :-\n\
	rule_configuration(s_silverscreen_virtual_cameras, M),\n\
	forall(silverscreen(_, B, E, F, G, H, I, J, K, L), (A=0, silverscreen_virtual_camera_id(A, C), retractall(virtual_camera(B, C, _, _, _)), assert(virtual_camera(B, C, 1, 0, 0)), virtual_camera_number(B, C, D), retractall(perspective_virtual_camera(D, _, _, _, _, _, _, _, _, _)), assert(perspective_virtual_camera(D, E, F, G, H, I, J, K, L, M)))).\n\
\n\
\n\
head_moves(C, D, A, G, H, B) :-\n\
	(   A=<0\n\
	->  B=[]\n\
	;   E is C+D,\n\
	    F is A-abs(D),\n\
	    head_moves(E, D, F, G, H, J),\n\
	    (   head_move(C, G, H, I)\n\
	    ->  B=[I|J]\n\
	    ;   B=J\n\
	    )\n\
	).\n\
\n\
\n\
update_person_count :-\n\
	retractall(person_count(_)),\n\
	findall(A, person(A), B),\n\
	length(B, C),\n\
	assert(person_count(C)).\n\
\n\
\n\
custom_real_time_generate(A) :-\n\
	test_mode([realtime]),\n\
	ignore(generate_esf_heads(A)).\n\
\n\
\n\
write_done :-\n\
	write(' done.'),\n\
	nl,\n\
	flush_output.\n\
\n\
\n\
init_virtual_cameras :-\n\
	retractall(virtual_camera(_, _, _, _, _)),\n\
	assert(moving_virtual_camera(0, 0, 0, 0, 0, 0, 0, 0)),\n\
	retractall(moving_virtual_camera(_, _, _, _, _, _, _, _)),\n\
	retractall(perspective_virtual_camera(_, _, _, _, _, _, _, _, _, _)),\n\
	retractall(head_full_positions_static(_, _, _, _, _, _)),\n\
	ignore((\n\
	    (   rule_configuration(s_fixed_virtual_cameras, _, _, _, _, _)\n\
	    *-> generate_fixed_virtual_cameras\n\
	    )\n\
	    )),\n\
	ignore((\n\
	    (   test_mode([offline, half_realtime]),\n\
		rule_configuration(s_moving_virtual_cameras, _, _, _, _, _, _, _, _, _, _)\n\
	    ->  generate_filtered_head_move,\n\
		generate_moving_virtual_cameras\n\
	    )\n\
	    )),\n\
	ignore((\n\
	    (   test_mode([offline, half_realtime]),\n\
		rule_configuration(s_silverscreen_virtual_cameras, _)\n\
	    ->  generate_silverscreen_virtual_cameras\n\
	    )\n\
	    )),\n\
	set_virtual_camera_time(0).\n\
\n\
\n\
insert_output(B, C, F, D) :-\n\
	findall(A, output_rule_order(A), E),\n\
	evaluate_output_step(B, C, [], D, E, F),\n\
	(   last_output_parameters(B, G, H)\n\
	->  true\n\
	;   G=[],\n\
	    H=[]\n\
	),\n\
	(   (   C\\=G\n\
	    ;   D\\=H\n\
	    )\n\
	->  asserta(output(B, C, D)),\n\
	    export(output, B, D),\n\
	    flush_output\n\
	;   fail\n\
	).\n\
\n\
\n\
is_empty_camera(A) :-\n\
	A<0.\n\
\n\
\n\
last_output_parameters(D, A, B) :-\n\
	once((\n\
	    output(C, A, B),\n\
	    C=<D\n\
	    )).\n\
\n\
\n\
past_person_visible(D, F, A, R) :-\n\
	fail,\n\
	camera(A, M, O, P, Q, B, _),\n\
	(   B<0\n\
	->  C is A\n\
	;   C is B\n\
	),\n\
	past_person_visible_window(E),\n\
	head_positions(D, 1, E, C, F, H),\n\
	findall(G, member((G, _), H), J),\n\
	findall(I, member((_, I), H), K),\n\
	list_aver(J, L),\n\
	list_aver(K, N),\n\
	L>=M,\n\
	N>=O,\n\
	L<M+P,\n\
	N<O+Q,\n\
	S is 1-abs(M+P/2-L)/ (P/2),\n\
	T is 1- (N-O)/Q,\n\
	R is (S+T)/2.\n\
\n\
\n\
head(A, B, E, C, D) :-\n\
	head(A, B, _, C, D, _, _, _, _, E).\n\
\n\
\n\
real_time_generate(A) :-\n\
	ignore(forall(custom_real_time_generate(A), true)),\n\
	ignore((\n\
	    (   test_mode([realtime])\n\
	    ->  step(B),\n\
		generate_all_head_move(A, B),\n\
		generate_all_hand_move(A, B)\n\
	    )\n\
	    )).\n\
\n\
\n\
import_esf :-\n\
	retractall(head(_, _, _, _, _, _, _, _, _, _)),\n\
	assert(person(a)),\n\
	retractall(person(_)),\n\
	assert(tmp_last_time(a, 0)),\n\
	retractall(tmp_last_time(_, _)),\n\
	begin(A),\n\
	end(B),\n\
	step(C),\n\
	ignore(generate_esf_heads_step(A, B, C)).\n\
\n\
\n\
run :-\n\
	init_main,\n\
	run_main.\n\
\n\
\n\
generate_all_head_move(A, B) :-\n\
	forall((bagof(C, get_head_move(A, -B, E, F, C), D), averlist(D, G)), assert(head_move(A, E, F, G))).\n\
\n\
\n\
stop_speaking1(C, A) :-\n\
	person_interactivity(D, A, B),\n\
	get_parameter(B, length, E),\n\
	C is D+E,\n\
	get_parameter(B, interactivity, F),\n\
	(   F=talking\n\
	;   F=laughing\n\
	).\n\
\n\
\n\
is_speakingX(A, B, C) :-\n\
	once(is_speaking_all(A, B, C)).\n\
\n\
\n\
evaluation_moving(C, D, A) :-\n\
	bagof(A, B^ (camera(B), not(is_virtual_camera(B)), not(is_empty_camera(B)), evaluation_head_moving(C, D, B, E), evaluation_hand_moving(C, D, B, F), A is max(E, F)), G),\n\
	maxlist(G, A),\n\
	A>0.\n\
\n\
\n\
init_history :-\n\
	retractall(output(_, _, _)),\n\
	retractall(outputz(_, _, _)).\n\
\n\
\n\
generate_filtered_head_move :-\n\
	rule_configuration(s_moving_virtual_cameras, _, _, _, _, _, H, E, _, _, _),\n\
	write_begin('generating filtered head move'),\n\
	retractall(head_full_positions_static(_, _, _, _, _, _)),\n\
	ignore((\n\
	    setof((B, C), A^head(A, B, C), D),\n\
	    forall(member((F, G), D), (generate_head_full_positions(1, E, F, G), generate_head_full_positions(-1, H, F, G)))\n\
	    )),\n\
	write_done.\n\
\n\
\n\
mult_camera_rule(A, B, C, G) :-\n\
	A=c_anti_quick,\n\
	last_output_optimized(B, D, E),\n\
	C\\==D,\n\
	rule_configuration(A, F, I),\n\
	(   E<F\n\
	->  G is 0\n\
	;   camera_exp_base(H),\n\
	    G is 1- (cos((1-exp(-H* ((E-F)/ (I-F))))*pi)+1)/2\n\
	).\n\
mult_camera_rule(A, B, C, G) :-\n\
	A=c_anti_lazy,\n\
	last_output_optimized(B, D, E),\n\
	C==D,\n\
	rule_configuration(A, F, I),\n\
	(   E<F\n\
	->  G is 1\n\
	;   camera_exp_base(H),\n\
	    J is 1e-005,\n\
	    G is max(1- (cos(exp(-H* ((E-F)/ (I-F)))*pi)+1)/2, J)\n\
	).\n\
mult_camera_rule(A, _, B, C) :-\n\
	A=c_virtual_supress_first,\n\
	rule_configuration(A),\n\
	parent_camera(B, _),\n\
	not(output(_, _, _)),\n\
	C is 0.\n\
mult_camera_rule(A, B, D, F) :-\n\
	A=c_virtual_parent_anti_lazy,\n\
	rule_configuration(A),\n\
	last_output_optimized(B, C),\n\
	parent_camera(C, E),\n\
	D==E,\n\
	mult_camera_rule(c_anti_lazy, B, C, F).\n\
mult_camera_rule(A, C, B, G) :-\n\
	A=c_virtual_supress_same_parent,\n\
	rule_configuration(A),\n\
	parent_camera(B, E),\n\
	last_output_optimized(C, D),\n\
	B\\==D,\n\
	parent_camera(D, F),\n\
	E==F,\n\
	G is 0.\n\
mult_camera_rule(A, C, B, G) :-\n\
	A=c_virtual_supress_other_parent,\n\
	rule_configuration(A),\n\
	parent_camera(B, D),\n\
	last_output_optimized(C, E),\n\
	D\\==E,\n\
	B\\==E,\n\
	(   pred_last_output(C, E, F, _)\n\
	->  F\\==B\n\
	;   true\n\
	),\n\
	G is 0.\n\
mult_camera_rule(A, _, B, D) :-\n\
	A=c_virtual_supress_parent,\n\
	rule_configuration(A, C),\n\
	camera(B, _, _, _, _, C, _),\n\
	C\\==B,\n\
	D is 0.\n\
mult_camera_rule(A, _, B, C) :-\n\
	A=c_intro_virtual_supress,\n\
	rule_configuration(A),\n\
	model_state(intro),\n\
	parent_camera(B, _),\n\
	C is 0.\n\
mult_camera_rule(A, _, B, C) :-\n\
	A=c_finish_virtual_supress,\n\
	rule_configuration(A),\n\
	model_state(finish),\n\
	parent_camera(B, _),\n\
	C is 0.\n\
mult_camera_rule(A, F, B, H) :-\n\
	A=c_intro_physical,\n\
	rule_configuration(A),\n\
	model_state(intro),\n\
	not(is_empty_camera(B)),\n\
	(   setof(D, C^E^ (output(C, D, E), C<F), G)\n\
	->  true\n\
	;   G=[]\n\
	),\n\
	member(B, G),\n\
	H is 0.\n\
mult_camera_rule(A, _, B, C) :-\n\
	A=c_summarization_supress,\n\
	rule_configuration(A),\n\
	B= -1,\n\
	not(output(_, _, _)),\n\
	C is 0.\n\
\n\
\n\
virtual_camera_percent(A, B, C, D, G) :-\n\
	virtual_camera(A, B, C, E, H),\n\
	camera(A, _, _, F, I),\n\
	D is E/F,\n\
	G is H/I.\n\
\n\
\n\
init_moving_virtual_cameras(G) :-\n\
	rule_configuration(s_moving_virtual_cameras, V, _, Y, Z1, A2, I, H, C1, S1, A),\n\
	B is A,\n\
	C is 1,\n\
	R1 is sqrt(B^2+C^2),\n\
	step(P1),\n\
	ignore(forall(person(F), forall((camera(D, T1, W1, U, W, E, _), D==E), ignore((moving_virtual_camera_id(F, Z), (test_mode([realtime])->head_full_positions(G, 1, H, E, F, K), head_full_positions(G, -1, I, E, F, J), append(J, K, M), findall(L, member((L, _, _, _, _, _), M), O), findall(N, member((_, _, _, N, _, _), M), P), averlist(O, S), averlist(P, T); (head_full_positions_static(G, 1, H, E, F, Q)->K=[Q];K=[]), (head_full_positions_static(G, -1, I, E, F, R)->J=[R];J=[]), append(J, K, M), findall(L, member((L, _), M), O), findall(N, member((_, N), M), P), averlist(O, S), averlist(P, T)), U1 is U/V/2, X is W/V/2, B1 is X*Y, (last_moving_virtual_camera(G, E, Z, Y1, O1, A1)->Q1 is A1-B1, D1 is G+C1, (test_mode([realtime])->head_full_positions(D1, 1, H, E, F, F1), head_full_positions(D1, -1, I, E, F, E1), append(E1, F1, G1), length(G1, H1), H1>0, findall(L, member((L, _, _, _, _, _), G1), I1), findall(N, member((_, _, _, N, _, _), G1), J1), averlist(I1, M1), averlist(J1, N1); (head_full_positions_static(D1, 1, H, E, F, K1)->F1=[K1];F1=[]), (head_full_positions_static(D1, -1, I, E, F, L1)->E1=[L1];E1=[]), append(E1, F1, G1), findall(L, member((L, _), G1), I1), findall(N, member((_, N), G1), J1), averlist(I1, M1), averlist(J1, N1)), V1 is O1+ (M1-O1)/ (C1/P1), X1 is Q1+ (N1-Q1)/ (C1/P1), (B* (M1-S)/U)^2+ (C* (N1-T)/W)^2> (R1*S1*C1)^2, L is round(min(max(T1+U1, V1), T1+U-U1)), N is round(min(max(W1+X, X1+B1), W1+W-X)), (O1==L, A1==N, Y1==V->fail;true), retractall(moving_virtual_camera(G, E, Z, _, _, _, _, _)), asserta(moving_virtual_camera(G, E, Z, V, L, N, Z1, A2));V1 is S, X1 is T, L is round(min(max(T1+U1, V1), T1+U-U1)), N is round(min(max(W1+X, X1+B1), W1+W-X)), retractall(moving_virtual_camera(G, E, Z, _, _, _, _, _)), asserta(moving_virtual_camera(G, E, Z, V, L, N, Z1, A2)))))))).\n\
\n\
\n\
head_positions(C, D, A, G, H, B) :-\n\
	(   A=<0\n\
	->  B=[]\n\
	;   E is C+D,\n\
	    F is A-abs(D),\n\
	    head_positions(E, D, F, G, H, K),\n\
	    (   head(C, G, H, I, J)\n\
	    ->  B=[ (I, J)|K]\n\
	    ;   B=K\n\
	    )\n\
	).\n\
\n\
\n\
generate_head_full_positions_step(C, D, E, F, A, B, N) :-\n\
	(   A=<B\n\
	->  ignore((\n\
		head_full_positions(A, C, D, E, F, H),\n\
		findall(G, member((G, _, _, _, _, _), H), J),\n\
		findall(I, member((_, _, _, I, _, _), H), K),\n\
		averlist(J, L),\n\
		averlist(K, M),\n\
		assert(head_full_positions_static(A, C, D, E, F, (L, M)))\n\
		)),\n\
	    O is A+N,\n\
	    generate_head_full_positions_step(C, D, E, F, O, B, N)\n\
	).\n\
\n\
\n\
init_person_activity :-\n\
	assert(person_activity(1, 2, 3)),\n\
	retractall(person_activity(_, _, _)),\n\
	(   test_mode([offline])\n\
	->  write_begin('generating persons actvity'),\n\
	    begin(A),\n\
	    end(B),\n\
	    step(C),\n\
	    ignore(generate_person_activity_step(A, B, C)),\n\
	    write_done\n\
	;   true\n\
	).\n\
\n\
\n\
is_moving_virtual_camera(A) :-\n\
	camera(A, _, _, _, _, B, C),\n\
	B\\==A,\n\
	is_moving_virtual_camera_id(C).\n\
\n\
\n\
virtual_camera_position(B, A) :-\n\
	A is 1- (cos(B*pi)+1)/2.\n\
\n\
\n\
evaluate_output_step(_, _, A, A, [], _).\n\
evaluate_output_step(B, C, D, G, [A|H], E) :-\n\
	(   output_rule(A, B, C, D, F, E)\n\
	->  evaluate_output_step(B, C, F, G, H, E)\n\
	;   evaluate_output_step(B, C, D, G, H, E)\n\
	).\n\
\n\
\n\
summarization_step(A, B, G) :-\n\
	(   A=<B\n\
	->  string_concat(output, '_', C),\n\
	    string_concat(C, A, D),\n\
	    string_concat(D, '.pl', E),\n\
	    tell(E),\n\
	    init_main,\n\
	    assert(temp_configuration(c_summarization1, A)),\n\
	    assert(temp_configuration(c_summarization2, A)),\n\
	    assert(temp_configuration(c_summarization3, A)),\n\
	    run_main,\n\
	    get_length(F),\n\
	    export(result, 0, [ (treshold, A), (length, F)]),\n\
	    told,\n\
	    H is A+G,\n\
	    summarization_step(H, B, G)\n\
	;   true\n\
	).\n\
\n\
\n\
slide_exchange(B, A) :-\n\
	is_silverscreen_camera(A),\n\
	camera(A, _, _, _, _, C, _),\n\
	slide(B, C).\n\
\n\
\n\
is_moving_virtual_camera_id(A) :-\n\
	B is A mod 10000,\n\
	B>=200,\n\
	B<300.\n\
\n\
\n\
export_virtual_camera_rectangles :-\n\
	begin(A),\n\
	end(B),\n\
	step(C),\n\
	(   export_virtual_camera_rectangles_step(A, B, C)\n\
	;   true\n\
	).\n\
\n\
\n\
get_parameter([ (A, D)|E], B, C) :-\n\
	(   A=B\n\
	->  C=D\n\
	;   get_parameter(E, B, C)\n\
	).\n\
\n\
\n\
do_step(A, B, C) :-\n\
	(   A=<B\n\
	->  ignore(main_step(A, _)),\n\
	    D is A+C,\n\
	    do_step(D, B, C)\n\
	).\n\
\n\
\n\
evaluation_max_moving(B, F) :-\n\
	bagof((C, A), A^ (person(A), evaluation_moving(B, A, C)), D),\n\
	sort(D, E),\n\
	reverse(E, F).\n\
\n\
\n\
generate_silverscreen_virtual_cameras :-\n\
	write_begin('generating silverscreen virtual cameras'),\n\
	ignore(init_silverscreen_virtual_cameras(0)),\n\
	write_done.\n\
\n\
\n\
evaluation_person_visible(B, A, F) :-\n\
	camera(A, P, R, S, T, E, U),\n\
	G is 520,\n\
	D is 520,\n\
	step(C),\n\
	head_positions(B, C, D, E, F, I),\n\
	head_positions(B, -C, G, E, F, H),\n\
	append(H, I, K),\n\
	findall(J, member((J, _), K), M),\n\
	findall(L, member((_, L), K), N),\n\
	averlist(M, O),\n\
	averlist(N, Q),\n\
	O>=P,\n\
	Q>=R,\n\
	O<P+S,\n\
	Q<R+T,\n\
	(   is_moving_virtual_camera(A)\n\
	->  moving_virtual_camera_id(F, U)\n\
	;   true\n\
	).\n\
\n\
\n\
sooner_same_camera(C, [A|D], E, G) :-\n\
	(I, B)=A,\n\
	(   B=C\n\
	->  sooner_same_camera(C, D, F, H)\n\
	->  E=F,\n\
	    G is H+1\n\
	;   E=I,\n\
	    G is 0\n\
	).\n\
\n\
\n\
export_all :-\n\
	A='all_esf.pl',\n\
	B='editing_esf.pl',\n\
	consult(A),\n\
	tell(B),\n\
	listing,\n\
	told,\n\
	halt.\n\
\n\
\n\
head(A, B, C, F, D, E) :-\n\
	head(A, B, C, D, E, _, _, _, _, F).\n\
\n\
\n\
update_last_output_optimized(A) :-\n\
	retractall(last_output_actual(_, _, _)),\n\
	ignore((\n\
	    last_output(A, B, C),\n\
	    assert(last_output_actual(A, B, C))\n\
	    )).\n\
\n\
\n\
generate_all_persons :-\n\
	write_begin('generating persons'),\n\
	retractall(person(_)),\n\
	(   setof(B, A^start_speaking(A, B), C)\n\
	;   C=[]\n\
	),\n\
	(   setof(B, A^stop_speaking(A, B), D)\n\
	;   D=[]\n\
	),\n\
	(   setof(B, A^E^F^hand(A, E, F, B), G)\n\
	;   G=[]\n\
	),\n\
	(   setof(B, A^E^head(A, E, B), H)\n\
	;   H=[]\n\
	),\n\
	union(C, D, I),\n\
	union(G, H, J),\n\
	union(I, J, K),\n\
	forall(member(L, K), assert(person(L))),\n\
	write_done.\n\
\n\
\n\
set_model_state(A) :-\n\
	retractall(model_state(_)),\n\
	assert(model_state(A)).\n\
\n\
\n\
inc_eval_value(A) :-\n\
	eval_value(A, B),\n\
	retractall(eval_value(A, _)),\n\
	C is B+1,\n\
	assert(eval_value(A, C)).\n\
\n\
\n\
evaluate_cameras(A, D) :-\n\
	ignore((\n\
	    (   test_mode([realtime])\n\
	    ->  init_moving_virtual_cameras(A)\n\
	    )\n\
	    )),\n\
	ignore((\n\
	    (   test_mode([realtime])\n\
	    ->  init_silverscreen_virtual_cameras(A)\n\
	    )\n\
	    )),\n\
	ignore((\n\
	    (   test_mode([half_realtime, realtime])\n\
	    ->  generate_person_activity(A)\n\
	    )\n\
	    )),\n\
	update_last_output_optimized(A),\n\
	update_model_state(A),\n\
	set_virtual_camera_time(A),\n\
	bagof(B, camera(B), C),\n\
	evaluate_cameras(A, C, D),\n\
	ignore(garbage_collector(A)).\n\
\n\
\n\
init_main :-\n\
	init_history,\n\
	retractall(temp_configuration(_, _)),\n\
	set_model_state(undefined),\n\
	ignore((\n\
	    (   setup_events(A)\n\
	    ->  export(setup, 0, A)\n\
	    )\n\
	    )),\n\
	ignore((\n\
	    (   test_mode([half_realtime, realtime])\n\
	    ->  retractall(person_activity(_, _, _))\n\
	    )\n\
	    )).\n\
\n\
\n\
evaluate_camera(B, C, G) :-\n\
	bagof(D, A^add_camera_rule(A, B, C, D), E),\n\
	sumlist(E, H),\n\
	(   bagof(D, A^mult_camera_rule(A, B, C, D), F)\n\
	->  multlist(F, I),\n\
	    G is H*I\n\
	;   G is H\n\
	).\n\
\n\
\n\
generate_all_head_move_step(A, B, C) :-\n\
	(   A=<B\n\
	->  ignore(generate_all_head_move(A, C)),\n\
	    D is A+C,\n\
	    generate_all_head_move_step(D, B, C)\n\
	).\n\
\n\
\n\
person_translate(A, B) :-\n\
	(   fixed_person_translate(A, B)\n\
	->  true\n\
	;   B=A\n\
	).\n\
\n\
\n\
model_rule(A, _, undefined, intro) :-\n\
	A=m_undefined_intro,\n\
	rule_configuration(A).\n\
model_rule(A, E, intro, presentation) :-\n\
	A=m_intro_presentation,\n\
	rule_configuration(A),\n\
	(   setof(C, B^D^ (output(B, C, D), B<E), F)\n\
	->  true\n\
	;   F=[]\n\
	),\n\
	(   setof(C, (camera(C), not(is_empty_camera(C)), not(is_virtual_camera(C))), G)\n\
	->  true\n\
	;   G=[]\n\
	),\n\
	subset(G, F).\n\
model_rule(A, B, intro, presentation) :-\n\
	A=m_intro_presentation,\n\
	rule_configuration(A, D),\n\
	begin(C),\n\
	B-C>=D.\n\
model_rule(A, C, presentation, finish) :-\n\
	A=m_presentation_finish,\n\
	rule_configuration(A, D),\n\
	end(B),\n\
	B-C=<D.\n\
\n\
\n\
future_past_person_position(C, F, A, N, P) :-\n\
	camera(A, Q, R, S, T, B, _),\n\
	A==B,\n\
	rule_configuration(s_person_visible_window, G, E),\n\
	step(D),\n\
	head_positions(C, D, E, B, F, I),\n\
	head_positions(C, -D, G, B, F, H),\n\
	append(H, I, K),\n\
	findall(J, member((J, _), K), M),\n\
	findall(L, member((_, L), K), O),\n\
	averlist(M, N),\n\
	averlist(O, P),\n\
	N>=Q,\n\
	P>=R,\n\
	N<Q+S,\n\
	P<R+T.\n\
\n\
\n\
minlist([B], A) :-\n\
	A is B.\n\
minlist([C|A], D) :-\n\
	minlist(A, B),\n\
	(   B<C\n\
	->  D is B\n\
	;   D is C\n\
	).\n\
\n\
\n\
is_speaking(A, B) :-\n\
	is_speaking(A, B, _).\n\
\n\
\n\
runf :-\n\
	runf('output.pl').\n\
\n\
\n\
evaluate_est(A, _, _) :-\n\
	step(B),\n\
	C is A-B,\n\
	last_output(C, _, D),\n\
	(   D=<1000\n\
	->  inc_eval_value(shot_short)\n\
	).\n\
evaluate_est(A, _, _) :-\n\
	step(B),\n\
	C is A-B,\n\
	last_output(C, _, D),\n\
	(   D>=30000\n\
	->  inc_eval_value(shot_long)\n\
	).\n\
evaluate_est(_, A, B) :-\n\
	is_virtual_camera(A, C),\n\
	is_virtual_camera(B, D),\n\
	(   C==D\n\
	->  inc_eval_value(shot_vsp)\n\
	).\n\
evaluate_est(D, C, A) :-\n\
	is_virtual_camera(A, B),\n\
	B\\==C,\n\
	step(E),\n\
	F is D-E,\n\
	(   pred_last_output(F, C, G, _)\n\
	->  G\\==A\n\
	;   true\n\
	),\n\
	inc_eval_value(shot_vpr).\n\
evaluate_est(B, E, A) :-\n\
	A==3,\n\
	step(C),\n\
	D is B-C,\n\
	pred_last_output(D, E, F, _),\n\
	F\\==A,\n\
	last_output(D, _, G),\n\
	I is B-G,\n\
	(   once((\n\
		person(H),\n\
		evaluation_person_visible(B, A, H),\n\
		evaluation_person_visible(I, E, H)\n\
		))\n\
	->  fail\n\
	;   true\n\
	),\n\
	inc_eval_value(shot_move).\n\
\n\
\n\
on_camera0(D, B, A, E) :-\n\
	event_head_enter_camera(C, A, B),\n\
	C=<D,\n\
	not(later_event_head_leave_camera(C, D, A, B)),\n\
	E is D-C.\n\
\n\
\n\
hand(A, B, C, D) :-\n\
	hand(A, B, C, _, _, _, _, _, _, D).\n\
\n\
\n\
is_speaking_all(C, A, E) :-\n\
	start_speaking(B, A),\n\
	B=<C,\n\
	not(stop_speaking(B, A)),\n\
	not((\n\
	    stop_speaking(D, A),\n\
	    D>=B,\n\
	    D=<C,\n\
	    not(start_speaking(D, A))\n\
	    )),\n\
	E is C-B.\n\
\n\
\n\
generate_fixed_virtual_cameras :-\n\
	write_begin('generating fixed virtual cameras'),\n\
	ignore(forall(rule_configuration(s_fixed_virtual_cameras, A, B, C, D, E), assert(virtual_camera(A, B, C, D, E)))),\n\
	write_done.\n\
\n\
\n\
import_step_internal :-\n\
	forall(event_prezentation_exchange(B, A), (get_parameter(A, camera, C), assert(slide(B, C)))),\n\
	forall(event_head(B, A), (get_parameter(A, camera, C), get_parameter(A, object, D), get_parameter(A, centerx, E), get_parameter(A, centery, F), get_parameter(A, minx, G), get_parameter(A, miny, H), get_parameter(A, maxx, I), get_parameter(A, maxy, J), get_parameter(A, person, K), assert(head(B, C, D, E, F, G, H, I, J, K)))),\n\
	forall(event_hand(B, A), (get_parameter(A, camera, C), get_parameter(A, object, D), get_parameter(A, centerx, E), get_parameter(A, centery, F), get_parameter(A, minx, G), get_parameter(A, miny, H), get_parameter(A, maxx, I), get_parameter(A, maxy, J), get_parameter(A, person, K), assert(hand(B, C, D, E, F, G, H, I, J, K)))),\n\
	forall(event_silverscreen(B, A), (get_parameter(A, camera, C), get_parameter(A, x1, L), get_parameter(A, y1, M), get_parameter(A, x2, N), get_parameter(A, y2, O), get_parameter(A, x3, P), get_parameter(A, y3, Q), get_parameter(A, x4, R), get_parameter(A, y4, S), assert(silverscreen(B, C, L, M, N, O, P, Q, R, S)))),\n\
	forall(event_prezentation_board(B, A), (get_parameter(A, camera, C), get_parameter(A, x1, L), get_parameter(A, y1, M), get_parameter(A, x2, N), get_parameter(A, y2, O), get_parameter(A, x3, P), get_parameter(A, y3, Q), get_parameter(A, x4, R), get_parameter(A, y4, S), assert(silverscreen(B, C, L, M, N, O, P, Q, R, S)))),\n\
	forall(event_teacher(B, A), (get_parameter(A, camera, C), get_parameter(A, object, D), get_parameter(A, centerx, E), get_parameter(A, centery, F), get_parameter(A, divergencex, T), get_parameter(A, divergencey, U), get_parameter(A, size, V), assert(teacher(B, C, D, E, F, T, U, V)))),\n\
	forall(event_start_speaking(B, A), (get_parameter(A, person, W), person_translate(W, X), assert(start_speaking(B, X)))),\n\
	forall(event_stop_speaking(B, A), (get_parameter(A, person, W), person_translate(W, X), assert(stop_speaking(B, X)))),\n\
	forall(event_sit(B, A), (get_parameter(A, individual, W), person_translate(W, X), assert(movement(B, X, sit)))),\n\
	forall(event_off_camera(B, A), (get_parameter(A, individual, W), person_translate(W, X), assert(movement(B, X, off_camera)))),\n\
	forall(event_take_notes(B, A), (get_parameter(A, individual, W), person_translate(W, X), assert(movement(B, X, take_notes)))),\n\
	forall(event_stand_whiteboard(B, A), (get_parameter(A, individual, W), person_translate(W, X), assert(movement(B, X, stand_whiteboard)))),\n\
	forall(event_stand_screen(B, A), (get_parameter(A, individual, W), person_translate(W, X), assert(movement(B, X, stand_screen)))),\n\
	forall(event_other(B, A), (get_parameter(A, individual, W), person_translate(W, X), assert(movement(B, X, other)))),\n\
	forall(event_move(B, A), (get_parameter(A, individual, W), person_translate(W, X), assert(movement(B, X, move)))),\n\
	init_import.\n\
\n\
\n\
evaluation_tech :-\n\
	clear_eval_value(speaking_hit),\n\
	clear_eval_value(speaking_miss),\n\
	clear_eval_value(speaking_hit2),\n\
	clear_eval_value(speaking_miss2),\n\
	clear_eval_value(moving_hit),\n\
	clear_eval_value(moving_miss),\n\
	clear_eval_value(moving_hit2),\n\
	clear_eval_value(moving_miss2),\n\
	clear_eval_value(moving_hit3),\n\
	clear_eval_value(moving_miss3),\n\
	clear_eval_value(moving_hit4),\n\
	clear_eval_value(moving_miss4),\n\
	begin(A),\n\
	end(B),\n\
	step(C),\n\
	ignore(evaluation_tech_step(A, B, C)),\n\
	print_eval_value(speaking_hit),\n\
	print_eval_value(speaking_miss),\n\
	print_eval_perc(speaking_hit, speaking_miss),\n\
	print_eval_value(speaking_hit2),\n\
	print_eval_value(speaking_miss2),\n\
	print_eval_perc(speaking_hit2, speaking_miss2),\n\
	print_eval_value(moving_hit),\n\
	print_eval_value(moving_miss),\n\
	print_eval_perc(moving_hit, moving_miss),\n\
	print_eval_value(moving_hit2),\n\
	print_eval_value(moving_miss2),\n\
	print_eval_perc(moving_hit2, moving_miss2),\n\
	print_eval_value(moving_hit3),\n\
	print_eval_value(moving_miss3),\n\
	print_eval_perc(moving_hit3, moving_miss3),\n\
	print_eval_value(moving_hit4),\n\
	print_eval_value(moving_miss4),\n\
	print_eval_perc(moving_hit4, moving_miss4).\n\
\n\
\n\
setup_events(C) :-\n\
	bagof((A, B), rule_configuration(setup, A, B), C).\n\
\n\
\n\
generate_person_activity(A) :-\n\
	ignore(forall(person(B), (evaluate_person_activity(A, B, C), assert(person_activity(A, B, C))))).\n\
\n\
\n\
print_eval_value(A) :-\n\
	eval_value(A, B),\n\
	write(A),\n\
	tab(1),\n\
	write(B),\n\
	nl.\n\
\n\
\n\
custom_init :-\n\
	write_begin('import esf'),\n\
	ignore(import_esf),\n\
	write_done.\n\
\n\
\n\
init :-\n\
	assert(rule_configuration_user(0, 1, 2)),\n\
	retractall(rule_configuration_user(0, 1, 2)),\n\
	assert(rule_configuration_user(0, 1)),\n\
	retractall(rule_configuration_user(0, 1)),\n\
	init_import,\n\
	import,\n\
	forall(custom_init, true),\n\
	init_head,\n\
	init_hand,\n\
	init_persons,\n\
	init_virtual_cameras,\n\
	init_person_activity,\n\
	init_main.\n\
\n\
\n\
parent_camera(A, B) :-\n\
	(   fixed_parent_camera(A, B)\n\
	->  true\n\
	;   is_virtual_camera(A, B)\n\
	).\n\
\n\
\n\
clear_eval_value(A) :-\n\
	retractall(eval_value(A, _)),\n\
	assert(eval_value(A, 0)).\n\
\n\
\n\
on_camera(A, B, C) :-\n\
	on_camera(A, B, C, _).\n\
\n\
\n\
import_esf2 :-\n\
	retractall(head(_, _, _, _, _, _, _, _, _, _)),\n\
	setof((B, C), A^D^E^F^G^H^teacher(A, B, C, D, E, F, G, H), I),\n\
	forall(member((B, C), I), generate_esf_heads(B, C)).\n\
\n\
\n\
is_virtual_camera(A) :-\n\
	is_virtual_camera(A, _).\n\
\n\
\n\
get_length(D) :-\n\
	begin(A),\n\
	end(B),\n\
	step(C),\n\
	get_length_step(A, B, C, -1, D).\n\
\n\
\n\
import_step :-\n\
	set_prolog_flag(unknown, warning),\n\
	ignore(import_step_internal),\n\
	set_prolog_flag(unknown, error).\n\
\n\
\n\
generate_esf_heads_step(A, B, C) :-\n\
	(   A=<B\n\
	->  ignore(generate_esf_heads(A)),\n\
	    D is A+C,\n\
	    generate_esf_heads_step(D, B, C)\n\
	).\n\
\n\
\n\
export_virtual_camera_rectangles(G) :-\n\
	forall((camera(B, C, E, D, F, A, _), A\\==B, B==20202), (H is C+D, I is E+F, export(virtual_camera, G, [ (camera, A), (object, B), (minx, C), (miny, E), (maxx, H), (maxy, I)]))).\n\
\n\
\n\
pred_last_outputX(C, H, I, J) :-\n\
	findall((A, B), (output(A, B, _), A=<C), D),\n\
	sort(D, E),\n\
	reverse(E, F),\n\
	nth0(0, F, (_, G)),\n\
	(   G\\=H\n\
	->  I=G,\n\
	    J is 0\n\
	;   sooner_same_camera(G, F, K, L),\n\
	    J is C-K,\n\
	    M is L+1,\n\
	    nth0(M, F, (_, I))\n\
	).\n\
\n\
\n\
maxlist([B], A) :-\n\
	A is B.\n\
maxlist([C|A], D) :-\n\
	maxlist(A, B),\n\
	(   B>C\n\
	->  D is B\n\
	;   D is C\n\
	).\n\
\n\
\n\
runf(A) :-\n\
	tell(A),\n\
	run,\n\
	told.\n\
\n\
\n\
last_output_parameters(D, A, J, B) :-\n\
	once((\n\
	    output(C, A, B),\n\
	    C=<D\n\
	    )),\n\
	(   once((\n\
		output(E, F, _),\n\
		E=<C,\n\
		F\\=A\n\
		))\n\
	->  true\n\
	;   E is-1000000\n\
	),\n\
	findall(G, G^H^ (output(G, A, H), G>E, G=<C), I),\n\
	last(I, K),\n\
	J is D-K.\n\
\n\
\n\
evaluation_head_moving(B, F, A, J) :-\n\
	G is 5000,\n\
	D is 5000,\n\
	camera(A, _, _, _, _, E, _),\n\
	step(C),\n\
	head_moves(B, C, D, E, F, H),\n\
	head_moves(B, -C, G, E, F, I),\n\
	sumlist(H, K),\n\
	sumlist(I, L),\n\
	J is (K+L)/ (D+G).\n\
\n\
\n\
generate_moving_virtual_cameras_step(A, B, C) :-\n\
	(   A=<B\n\
	->  init_moving_virtual_cameras(A),\n\
	    D is A+C,\n\
	    generate_moving_virtual_cameras_step(D, B, C)\n\
	).\n\
\n\
\n\
set_virtual_camera_time(A) :-\n\
	(   begin(A)\n\
	->  ignore(forall((virtual_camera(C, B, D, E, F), is_moving_virtual_camera_id(B)), (retractall(virtual_camera(C, B, D, E, F)), retractall(virtual_camera_size(C, B, _, _)))))\n\
	;   true\n\
	),\n\
	ignore(forall((camera(G, _, _, _, _, C, _), C==G), forall(person(H), (moving_virtual_camera_id(H, B), moving_virtual_camera(A, G, B, D, E, F, I, J)->retractall(virtual_camera(C, B, _, _, _)), retractall(virtual_camera_size(C, B, _, _)), assert(virtual_camera(G, B, D, E, F)), assert(virtual_camera_size(G, B, I, J));true)))).\n\
\n\
\n\
future_person_visible(D, F, A, R) :-\n\
	fail,\n\
	camera(A, M, O, P, Q, B, _),\n\
	(   B<0\n\
	->  C is A\n\
	;   C is B\n\
	),\n\
	future_person_visible_window(E),\n\
	head_positions(D, 1, E, C, F, H),\n\
	findall(G, member((G, _), H), J),\n\
	findall(I, member((_, I), H), K),\n\
	list_aver(J, L),\n\
	list_aver(K, N),\n\
	L>=M,\n\
	N>=O,\n\
	L<M+P,\n\
	N<O+Q,\n\
	S is 1-abs(M+P/2-L)/ (P/2),\n\
	T is 1- (N-O)/Q,\n\
	R is (S+T)/2.\n\
\n\
\n\
evaluation_tech_step(A, B, C) :-\n\
	(   A=<B\n\
	->  set_virtual_camera_time(A),\n\
	    findall(_, evaluate_tech(A), _),\n\
	    D is A+C,\n\
	    evaluation_tech_step(D, B, C)\n\
	).\n\
\n\
\n\
camera(A, B, C, D, E) :-\n\
	camera(A, B, C, D, E, _, _).\n\
\n\
\n\
person_movement(D, A, B) :-\n\
	movement(C, A, B),\n\
	C=<D,\n\
	not((\n\
	    movement(E, A, _),\n\
	    E=<D,\n\
	    E>C\n\
	    )).\n\
\n\
\n\
last_moving_virtual_camera(A, B, C, D, E, F, G, H) :-\n\
	(   moving_virtual_camera(A, B, C, D, E, F, G, H)\n\
	->  true\n\
	;   once((\n\
		moving_virtual_camera(I, B, C, D, E, F, G, H),\n\
		I=<A\n\
		))\n\
	).\n\
\n\
\n\
print_eval_perc(A, B) :-\n\
	eval_value(A, C),\n\
	eval_value(B, D),\n\
	(   C+D>0\n\
	->  E is 100*C/ (C+D),\n\
	    write(A),\n\
	    write('_percent'),\n\
	    tab(1),\n\
	    write(E),\n\
	    nl\n\
	;   write(error),\n\
	    nl\n\
	).\n\
\n\
\n\
export_all(A, B) :-\n\
	consult(A),\n\
	tell(B),\n\
	listing,\n\
	told,\n\
	halt.\n\
\n\
\n\
evaluate_cameras(_, [], []).\n\
evaluate_cameras(A, [C|B], F) :-\n\
	evaluate_cameras(A, B, E),\n\
	(   evaluate_camera(A, C, D),\n\
	    D>0\n\
	->  append(E, [ (C, D)], F)\n\
	;   F=E\n\
	).\n\
\n\
\n\
camera(A, D, E, B, C, F, G) :-\n\
	(   camera(A, B, C),\n\
	    D is 0,\n\
	    E is 0,\n\
	    F=A,\n\
	    G is 1\n\
	;   virtual_camera(F, G, J, H, K),\n\
	    camera(F, I, L),\n\
	    virtual_camera_number(F, G, A),\n\
	    D is H-I/2/J,\n\
	    B is I/J,\n\
	    E is K-L/2/J,\n\
	    C is L/J\n\
	;   A is-1,\n\
	    D is-1,\n\
	    E is-1,\n\
	    B is-1,\n\
	    C is-1,\n\
	    F is-1,\n\
	    G is-1\n\
	).\n\
\n\
\n\
init_head :-\n\
	retractall(head_move(_, _, _, _)),\n\
	(   test_mode([offline, half_realtime])\n\
	->  write_begin('generating head_move'),\n\
	    begin(A),\n\
	    end(B),\n\
	    step(C),\n\
	    ignore(generate_all_head_move_step(A, B, C)),\n\
	    write_done\n\
	;   true\n\
	).\n\
\n\
\n\
test_mult_camera_rule_step(C, D, A, B, G, E) :-\n\
	(   A=<B\n\
	->  (   mult_camera_rule(C, A, D, F)\n\
	    ->  export(graph, A, [ (color, E), (value, F)])\n\
	    ;   true\n\
	    ),\n\
	    H is A+G,\n\
	    test_mult_camera_rule_step(C, D, H, B, G, E)\n\
	).\n\
\n\
\n\
get_length_step(A, B, F, E, H) :-\n\
	(   A<B\n\
	->  (   output(A, C, _)\n\
	    ->  D=C\n\
	    ;   D=E\n\
	    ),\n\
	    G is A+F,\n\
	    get_length_step(G, B, F, D, I),\n\
	    (   D<0\n\
	    ->  H is I\n\
	    ;   H is I+F\n\
	    )\n\
	;   H is 0\n\
	).\n\
\n\
\n\
generate_esf_heads2(A, B) :-\n\
	D is 1000,\n\
	step(G),\n\
	forall((teacher(F, A, B, J, H, _, _, C), C>=D), ((tmp_last_time(E)->true;E is 0), I is F//G*G, K is H, ignore(esf_heads_step(E, I, G, A, B, J, K)), retractall(tmp_last_time(_)), assert(tmp_last_time(I)))).\n\
\n\
\n\
output_rule(A, _, C, _, B) :-\n\
	A=o_basic,\n\
	B=[ ('Camera', C)].\n\
output_rule(A, C, _, B, M) :-\n\
	A=o_summarization_fadeX,\n\
	rule_configuration(A, F),\n\
	member(('Camera', D), B),\n\
	pred_last_output(C, D, J, E),\n\
	E<F,\n\
	(   D= -1\n\
	->  G is 100* (E/F),\n\
	    K is G,\n\
	    step(H),\n\
	    L is min(100* ((E+H)/F), 100),\n\
	    delete(B, (camera, D), I),\n\
	    append(I, [ (camera, J), (effect1, fade), (fadepercent, G), (fadecolor, '0x00ffffff'), (audioeffect1, audiofade), (audiofadepercentbegin, K), (audiofadepercentend, L)], M)\n\
	;   J= -1\n\
	->  G is 100* ((F-E)/F),\n\
	    K is G,\n\
	    step(H),\n\
	    L is max(100* ((F-E-H)/F), 0),\n\
	    append(B, [ (effect1, fade), (fadepercent, G), (fadecolor, '0x00ffffff'), (audioeffect1, audiofade), (audiofadepercentbegin, K), (audiofadepercentend, L)], M)\n\
	).\n\
output_rule(A, C, _, B, L) :-\n\
	A=o_summarization_fade_out,\n\
	rule_configuration(A, F),\n\
	model_state(presentation),\n\
	member(('Camera', D), B),\n\
	pred_last_output_parameters(C, D, _, E, I),\n\
	E<F,\n\
	D= -1,\n\
	G is 100* (E/F),\n\
	J is G,\n\
	step(H),\n\
	K is min(100* ((E+H)/F), 100),\n\
	append(I, [ ('Effect', 'Fade1'), ('Fade1Percent', G), ('Fade1Color', '0x00ffffff'), ('AudioEffect', 'AudioFade1'), ('AudioFade1PercentBegin', J), ('AudioFade1Percentend', K)], L).\n\
output_rule(A, E, _, B, P) :-\n\
	A=o_summarization_fade_in,\n\
	rule_configuration(A, K),\n\
	model_state(presentation),\n\
	member(('Camera', C), B),\n\
	not(is_empty_camera(C)),\n\
	once((\n\
	    output(D, F, _),\n\
	    D<E,\n\
	    is_empty_camera(F)\n\
	    )),\n\
	(   once((\n\
		output(G, H, _),\n\
		G>D,\n\
		not(is_empty_camera(H)),\n\
		not((\n\
		    output(I, _, _),\n\
		    I>D,\n\
		    I<G\n\
		    ))\n\
		))\n\
	->  J is E-G\n\
	;   J is 0\n\
	),\n\
	J<K,\n\
	L is 100* ((K-J)/K),\n\
	N is L,\n\
	step(M),\n\
	O is max(100* ((K-J-M)/K), 0),\n\
	append(B, [ ('Effect', 'Fade1'), ('Fade1Percent', L), ('Fade1Color', '0x00ffffff'), ('AudioEffect', 'AudioFade1'), ('AudioFade1PercentBegin', N), ('AudioFade1Percentend', O)], P).\n\
output_rule(A, D, B, N, P) :-\n\
	A=o_pip_in_third_camera,\n\
	rule_configuration(A),\n\
	camera(B, _, _, _, _, C, _),\n\
	C\\==3,\n\
	pred_last_output(D, B, E, _),\n\
	E==3,\n\
	K is 0.2,\n\
	findall(G, F^H^ (person(F), future_past_person_position(D, F, E, G, H)), I),\n\
	I\\==[],\n\
	camera(E, J, _),\n\
	(   forall(member(G, I), G>=J/2)\n\
	->  L is K,\n\
	    M= (C==2)\n\
	;   forall(member(G, I), G<J/2)\n\
	->  L is 1-K,\n\
	    M= (C==1)\n\
	;   fail\n\
	),\n\
	(   M\n\
	->  append(N, [ (effect3, hmirror)], O)\n\
	;   O=N\n\
	),\n\
	append(O, [ (effect4, stack), (stackcamera, 1000000), (effect5, basic), (basiccamera, E), (effect6, pip), (pipcamera, 1000000), (pipcenterx, L), (pipcentery, '0.2'), (pipratio, '0.4')], P).\n\
output_rule(A, C, _, B, W) :-\n\
	A=o_virtual_cameras_zooming_moving,\n\
	rule_configuration(A, F, J, Y),\n\
	member(('Camera', D), B),\n\
	pred_last_output(C, D, G, E),\n\
	camera(D, _, _, _, _, H, K),\n\
	(   E<F\n\
	->  camera(G, _, _, _, _, I, X),\n\
	    (   D\\==H,\n\
		G==I,\n\
		H==I,\n\
		J\\==0\n\
	    ->  virtual_camera_percent(H, K, M, P, R),\n\
		O is 0.5,\n\
		Q is 0.5,\n\
		virtual_camera_position(E/F, L),\n\
		T is 1+L* (M-1),\n\
		N is L*M/ (L* (M-1)+1),\n\
		U is (1-N)*O+N*P,\n\
		V is (1-N)*Q+N*R,\n\
		delete(B, ('Camera', D), S),\n\
		append(S, [ ('Camera', H), (effect2, zoom), (zoomratio, T), (zoomcenterx, U), (zoomcentery, V)], W)\n\
	    ;   D==H,\n\
		G\\==I,\n\
		D==I,\n\
		J\\==0\n\
	    ->  virtual_camera_percent(I, X, M, P, R),\n\
		O is 0.5,\n\
		Q is 0.5,\n\
		virtual_camera_position(1-E/F, L),\n\
		T is 1+L* (M-1),\n\
		N is L*M/ (L* (M-1)+1),\n\
		U is (1-N)*O+N*P,\n\
		V is (1-N)*Q+N*R,\n\
		append(B, [ (effect2, zoom), (zoomratio, T), (zoomcenterx, U), (zoomcentery, V)], W)\n\
	    ;   D\\==H,\n\
		G\\==I,\n\
		H==I,\n\
		D\\==G,\n\
		Y\\==0\n\
	    ->  virtual_camera_percent(H, K, M, P, R),\n\
		virtual_camera_percent(I, X, Z, A1, B1),\n\
		virtual_camera_position(E/F, L),\n\
		T is (1-L)*Z+L*M,\n\
		U is (1-L)*A1+L*P,\n\
		V is (1-L)*B1+L*R,\n\
		delete(B, ('Camera', D), S),\n\
		append(S, [ ('Camera', H), (effect2, zoom), (zoomratio, T), (zoomcenterx, U), (zoomcentery, V)], W)\n\
	    ;   D\\==H,\n\
		virtual_camera_percent(H, K, T, U, V),\n\
		delete(B, ('Camera', D), S),\n\
		append(S, [ ('Camera', H), (effect2, zoom), (zoomratio, T), (zoomcenterx, U), (zoomcentery, V)], W)\n\
	    )\n\
	;   D\\==H,\n\
	    virtual_camera_percent(H, K, T, U, V),\n\
	    delete(B, ('Camera', D), S),\n\
	    append(S, [ ('Camera', H), (effect2, zoom), (zoomratio, T), (zoomcenterx, U), (zoomcentery, V)], W)\n\
	).\n\
output_rule(A, _, _, B, P) :-\n\
	A=o_virtual_cameras_simple,\n\
	rule_configuration(A),\n\
	member(('Camera', C), B),\n\
	camera(C, _, _, _, _, D, E),\n\
	C\\==D,\n\
	not(perspective_virtual_camera(C, _, _, _, _, _, _, _, _, _)),\n\
	virtual_camera_percent_rel(D, E, K, L, M),\n\
	(   virtual_camera_size(D, E, F, G)\n\
	->  H is (1-F)/2,\n\
	    I is (1-G)/2,\n\
	    N is 1-H,\n\
	    O is 1-I,\n\
	    delete(B, ('Camera', C), J),\n\
	    append(J, [ ('Camera', D), ('EffectVCS1', 'ZoomVCS1'), ('ZoomVCS1Ratio', K), ('ZoomVCS1CenterX', L), ('ZoomVCS1CenterY', M), ('EffectVCS2', 'CropVCS2'), ('CropVCS2Left', H), ('CropVCS2Top', I), ('CropVCS2Right', N), ('CropVCS2Bottom', O)], P)\n\
	;   delete(B, ('Camera', C), J),\n\
	    append(J, [ ('Camera', D), ('EffectVCS1', 'ZoomVCS1'), ('ZoomVCS1Ratio', K), ('ZoomVCS1CenterX', L), ('ZoomVCS1CenterY', M)], P)\n\
	).\n\
output_rule(A, _, _, B, Y) :-\n\
	A=o_perspective_cameras_simple,\n\
	rule_configuration(A),\n\
	member(('Camera', C), B),\n\
	camera(C, _, _, _, _, D, _),\n\
	C\\==D,\n\
	perspective_virtual_camera(C, E, G, I, J, K, L, M, N, X),\n\
	parent_camera(C, D),\n\
	camera(D, F, H),\n\
	P is E/F,\n\
	Q is G/H,\n\
	R is I/F,\n\
	S is J/H,\n\
	T is K/F,\n\
	U is L/H,\n\
	V is M/F,\n\
	W is N/H,\n\
	delete(B, ('Camera', C), O),\n\
	append(O, [ ('Camera', D), ('EffectPCS1', 'PerspectivePCS1'), ('PerspectivePCS1X1', P), ('PerspectivePCS1Y1', Q), ('PerspectivePCS1X2', R), ('PerspectivePCS1Y2', S), ('PerspectivePCS1X3', T), ('PerspectivePCS1Y3', U), ('PerspectivePCS1X4', V), ('PerspectivePCS1Y4', W), ('PerspectivePCS1AspectRatio', X)], Y).\n\
\n\
\n\
import :-\n\
	retractall(head(_, _, _, _, _, _, _, _, _, _)),\n\
	retractall(hand(_, _, _, _, _, _, _, _, _, _)),\n\
	assert(start_speaking(1, 2)),\n\
	retractall(start_speaking(_, _)),\n\
	assert(stop_speaking(1, 2)),\n\
	retractall(stop_speaking(_, _)),\n\
	retractall(movement(_, _, _)),\n\
	retractall(silverscreen(_, _, _, _, _, _, _, _, _, _)),\n\
	retractall(teacher(_, _, _, _, _, _, _, _)),\n\
	retractall(slide(_, _)),\n\
	assert(silverscreen(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)),\n\
	retractall(silverscreen(_, _, _, _, _, _, _, _, _, _)),\n\
	assert(teacher(1, 2, 3, 4, 5, 6, 7, 8)),\n\
	retractall(teacher(_, _, _, _, _, _, _, _)),\n\
	write_begin(importing),\n\
	import_step,\n\
	write_done.\n\
\n\
\n\
person_rule(C, D, E, H) :-\n\
	bagof(F, A^B^ (camera(A, _, _, _, _, B, _), A=B, person_rule(C, D, E, A, F)), G),\n\
	maxlist(G, H).\n\
person_rule(A, _, B, C) :-\n\
	A=p_const,\n\
	rule_configuration_dynamic(A, B, C).\n\
person_rule(A, B, C, D) :-\n\
	A=p_past_speaking_exp,\n\
	rule_configuration(A, G),\n\
	is_speaking(B, C, F),\n\
	speaking_exp_base(E),\n\
	D is 1-exp(- (E* (F/G))).\n\
person_rule(A, B, C, D) :-\n\
	A=p_past_speaking_inv_exp,\n\
	rule_configuration(A, G),\n\
	is_speaking(B, C, F),\n\
	speaking_exp_base(E),\n\
	D is exp(- (E* (F/G))).\n\
person_rule(A, B, C, D) :-\n\
	A=p_past_speaking_cos,\n\
	rule_configuration(A, F),\n\
	is_speaking(B, C, E),\n\
	D is 1- (cos(min(E, F)/F*pi)+1)/2.\n\
person_rule(A, B, C, F) :-\n\
	A=p_future_speaking_exp,\n\
	rule_configuration(A, E),\n\
	will_speak(B, C, D),\n\
	speaking_exp_base(G),\n\
	D<E,\n\
	F is 1-exp(- (G* ((E-D)/E))).\n\
person_rule(A, B, C, F) :-\n\
	A=p_future_speaking_cos,\n\
	rule_configuration(A, E),\n\
	will_speak(B, C, D),\n\
	D<E,\n\
	F is 1- (cos((E-D)/E*pi)+1)/2.\n\
person_rule(A, B, C, H) :-\n\
	A=p_future_past_speaking_exp,\n\
	rule_configuration(A, E, J),\n\
	(   will_speak(B, C, D)\n\
	->  D<E,\n\
	    F is E-D\n\
	;   is_speaking(B, C, G)\n\
	->  F is E+G\n\
	;   fail\n\
	),\n\
	speaking_exp_base(I),\n\
	H is 1-exp(- (I* (F/ (E+J)))).\n\
person_rule(A, B, C, D) :-\n\
	A=square_speaking,\n\
	rule_configuration(A),\n\
	is_speaking(B, C),\n\
	D is 1.\n\
\n\
\n\
silverscreen_virtual_camera_id(B, A) :-\n\
	A is 400+B.\n\
\n\
\n\
export_virtual_camera_rectangles_step(A, B, C) :-\n\
	(   A=<B\n\
	->  set_virtual_camera_time(A),\n\
	    ignore(export_virtual_camera_rectangles(A)),\n\
	    D is A+C,\n\
	    export_virtual_camera_rectangles_step(D, B, C)\n\
	).\n\
\n\
\n\
last_output_parametersXX(D, A, H, B) :-\n\
	once((\n\
	    output(C, A, B),\n\
	    C=<D\n\
	    )),\n\
	(   once((\n\
		output(E, F, _),\n\
		E=<C,\n\
		F\\=A\n\
		))\n\
	->  true\n\
	;   E is-1000000\n\
	),\n\
	once((\n\
	    outputz(G, A, _),\n\
	    G>E,\n\
	    G=<C\n\
	    )),\n\
	H is D-G.\n\
\n\
\n\
test_person_rule(A, B, F) :-\n\
	begin(C),\n\
	end(D),\n\
	step(E),\n\
	(   test_person_rule_step(A, B, C, D, E, F)\n\
	;   true\n\
	).\n\
\n\
\n\
multlist([B], A) :-\n\
	A is B.\n\
multlist([C|A], B) :-\n\
	multlist(A, D),\n\
	B is C*D.\n\
\n\
\n\
virtual_camera_number(B, C, A) :-\n\
	A is B*10000+C.\n\
\n\
\n\
evaluation_est_step(A, B, C) :-\n\
	(   A=<B\n\
	->  ignore((\n\
		D is A-C,\n\
		last_output(A, E),\n\
		last_output(D, F),\n\
		E\\==F,\n\
		inc_eval_value(shot_count),\n\
		once(evaluate_est(A, F, E))\n\
		)),\n\
	    G is A+C,\n\
	    evaluation_est_step(G, B, C)\n\
	).\n\
\n\
\n\
speaking_exp_base(A) :-\n\
	A is-log(0.01).\n\
\n\
\n\
get_hand_move(A, D, B, C, G) :-\n\
	hand(A, B, F, C, I, K),\n\
	E is A+D,\n\
	hand(E, B, F, C, H, J),\n\
	G is sqrt((H-I)**2+ (J-K)**2).\n\
\n\
\n\
find_max_cameras([], []).\n\
find_max_cameras([D|A], C) :-\n\
	find_max_cameras(A, B),\n\
	(   B==[]\n\
	->  C=[D]\n\
	;   (_, G)=D,\n\
	    nth0(0, B, E),\n\
	    (_, F)=E,\n\
	    (   F<G\n\
	    ->  C=[D]\n\
	    ;   F>G\n\
	    ->  C=B\n\
	    ;   append(B, [D], C)\n\
	    )\n\
	).\n\
\n\
\n\
last_output(A, B, C) :-\n\
	last_output_parameters(A, B, C, _).\n\
\n\
\n\
last_moving_virtual_camera(A, B, C, D, E, F) :-\n\
	last_moving_virtual_camera(A, B, C, D, E, F, _, _).\n\
\n\
\n\
stop_speaking0(A, C) :-\n\
	event_stop_speaking(A, B),\n\
	get_parameter(B, person, C).\n\
\n\
\n\
update_model_state(A) :-\n\
	model_state(B),\n\
	(   model_rule(_, A, B, C)\n\
	*-> set_model_state(C)\n\
	;   true\n\
	).\n\
\n\
\n\
export(A, B, C) :-\n\
	write(event_),\n\
	write(A),\n\
	write('('),\n\
	write(B),\n\
	write(', ['),\n\
	export_parameters(C),\n\
	write(']).'),\n\
	nl.\n\
\n\
\n\
evaluate_tech(A) :-\n\
	forall(is_speaking(A, C), (last_output(A, B), evaluation_person_visible(A, B, C)->inc_eval_value(speaking_hit);inc_eval_value(speaking_miss))).\n\
evaluate_tech(A) :-\n\
	bagof(B, is_speaking(A, B), C),\n\
	(   once((\n\
		member(E, C),\n\
		last_output(A, D),\n\
		evaluation_person_visible(A, D, E)\n\
		))\n\
	->  inc_eval_value(speaking_hit2)\n\
	;   inc_eval_value(speaking_miss2)\n\
	).\n\
evaluate_tech(A) :-\n\
	evaluation_max_moving(A, B),\n\
	nth0(0, B, (_, D)),\n\
	last_output(A, C),\n\
	(   evaluation_person_visible(A, C, D)\n\
	->  inc_eval_value(moving_hit),\n\
	    inc_eval_value(moving_hit2),\n\
	    inc_eval_value(moving_hit3),\n\
	    inc_eval_value(moving_hit4)\n\
	;   inc_eval_value(moving_miss),\n\
	    nth0(1, B, (_, E)),\n\
	    evaluation_person_visible(A, C, E)\n\
	->  inc_eval_value(moving_hit2),\n\
	    inc_eval_value(moving_hit3),\n\
	    inc_eval_value(moving_hit4)\n\
	;   inc_eval_value(moving_miss2),\n\
	    nth0(2, B, (_, F)),\n\
	    evaluation_person_visible(A, C, F)\n\
	->  inc_eval_value(moving_hit3),\n\
	    inc_eval_value(moving_hit4)\n\
	;   inc_eval_value(moving_miss3),\n\
	    nth0(3, B, (_, G)),\n\
	    evaluation_person_visible(A, C, G)\n\
	->  inc_eval_value(moving_hit4)\n\
	;   inc_eval_value(moving_miss4)\n\
	).\n\
\n\
\n\
test_mode(B) :-\n\
	rule_configuration_dynamic(s_mode, A),\n\
	member(A, B).\n\
\n\
\n\
print_eval_perc2(B, A) :-\n\
	eval_value(A, F),\n\
	findall(D, (member(C, B), eval_value(C, D)), E),\n\
	sumlist(E, G),\n\
	(   F>0\n\
	->  H is 100*G/F,\n\
	    write(A),\n\
	    write('_percent'),\n\
	    tab(1),\n\
	    write(H),\n\
	    nl\n\
	;   write(error),\n\
	    nl\n\
	).\n\
\n\
\n\
sooner_on_camera0(A, B, C, E) :-\n\
	on_camera0(A, B, C, D),\n\
	D>E.\n\
\n\
\n\
init_hand :-\n\
	retractall(hand_move(_, _, _, _)),\n\
	(   test_mode([offline, half_realtime])\n\
	->  write_begin('generating head_move'),\n\
	    begin(A),\n\
	    end(B),\n\
	    step(C),\n\
	    ignore(generate_all_hand_move_step(A, B, C)),\n\
	    write_done\n\
	;   true\n\
	).\n\
\n\
\n\
test_person_activityf(C, F) :-\n\
	A=activity,\n\
	string_concat(A, '_', B),\n\
	string_concat(B, C, D),\n\
	string_concat(D, '.pl', E),\n\
	tell(E),\n\
	test_person_activity(C, F),\n\
	told.\n\
\n\
\n\
add_camera_rule(A, B, D, G) :-\n\
	A=c_anti_swap,\n\
	rule_configuration(A, F),\n\
	last_output_optimized(B, C, E),\n\
	C=D,\n\
	E<F,\n\
	G is 1.\n\
add_camera_rule(A, _, B, C) :-\n\
	A=c_const,\n\
	rule_configuration_dynamic(A, B, C).\n\
add_camera_rule(A, _, B, C) :-\n\
	A=c_const_model,\n\
	rule_configuration(A, B, C, D),\n\
	model_state(D).\n\
add_camera_rule(A, _, B, C) :-\n\
	A=c_initial_random_camera,\n\
	rule_configuration(A),\n\
	not(is_empty_camera(B)),\n\
	not(output(_, _, _)),\n\
	C is 1.\n\
add_camera_rule(A, _, B, C) :-\n\
	A=c_random_camera,\n\
	rule_configuration(A),\n\
	not(is_empty_camera(B)),\n\
	C is 1.\n\
add_camera_rule(A, C, B, I) :-\n\
	A=c_person_activity,\n\
	rule_configuration(A),\n\
	not(is_empty_camera(B)),\n\
	findall(G, (person_activity(C, E, D), (D>0->person_visible(C, E, B, F);F is 0), G is D*F), H),\n\
	(   H=[]\n\
	->  fail\n\
	;   sumlist(H, J)\n\
	),\n\
	person_count(K),\n\
	I is J/K.\n\
add_camera_rule(A, F, B, I) :-\n\
	A=c_intro_physical,\n\
	rule_configuration(A),\n\
	model_state(intro),\n\
	not(is_empty_camera(B)),\n\
	(   setof(D, C^E^ (output(C, D, E), C<F), G)\n\
	->  true\n\
	;   G=[]\n\
	),\n\
	not(member(B, G)),\n\
	(   add_camera_rule(c_person_activity, F, B, H)\n\
	->  true\n\
	;   H is 0\n\
	),\n\
	I is 2* (1-H).\n\
add_camera_rule(A, F, B, K) :-\n\
	A=c_summarization1,\n\
	B= -1,\n\
	rule_configuration(A, E),\n\
	(   temp_configuration(A, C)\n\
	->  D=C\n\
	;   D=E\n\
	),\n\
	findall(G, person_activity(F, _, G), H),\n\
	sumlist(H, I),\n\
	person_count(J),\n\
	L is I/J,\n\
	K is (1-L)*D.\n\
add_camera_rule(A, F, B, L) :-\n\
	A=c_summarization2,\n\
	B= -1,\n\
	rule_configuration(A, E),\n\
	(   temp_configuration(A, C)\n\
	->  D=C\n\
	;   D=E\n\
	),\n\
	findall(G, person_activity(F, _, G), H),\n\
	sumlist(H, I),\n\
	person_count(J),\n\
	K is I/J,\n\
	K<D,\n\
	L is 1.\n\
add_camera_rule(A, F, B, P) :-\n\
	A=c_summarization3,\n\
	B= -1,\n\
	rule_configuration(A, E),\n\
	(   temp_configuration(A, C)\n\
	->  D=C\n\
	;   D=E\n\
	),\n\
	findall(G, person_activity(F, _, G), H),\n\
	sumlist(H, I),\n\
	person_count(J),\n\
	Q is I/J,\n\
	step(K),\n\
	L is F-K,\n\
	findall(M, person_activity(L, _, M), N),\n\
	sumlist(N, O),\n\
	R is O/J,\n\
	P is (1-abs(Q-R))*D.\n\
add_camera_rule(A, C, B, H) :-\n\
	A=c_summarization4,\n\
	B= -1,\n\
	rule_configuration(A),\n\
	findall(D, (person_activity(C, _, E), D is E), F),\n\
	sumlist(F, G),\n\
	G=0,\n\
	H is 100.\n\
add_camera_rule(A, D, B, H) :-\n\
	A=c_past_slide_exp,\n\
	rule_configuration(A, E),\n\
	is_silverscreen_camera(B),\n\
	bagof(C, (slide_exchange(C, B), C=<D, C>D-E), F),\n\
	maxlist(F, G),\n\
	J is E- (D-G),\n\
	speaking_exp_base(I),\n\
	H is 1-exp(- (I* (J/E))).\n\
add_camera_rule(A, D, B, H) :-\n\
	A=c_future_slide_exp,\n\
	rule_configuration(A, E),\n\
	is_silverscreen_camera(B),\n\
	bagof(C, (slide_exchange(C, B), C>D, C=<D+E), F),\n\
	minlist(F, G),\n\
	J is G-D,\n\
	speaking_exp_base(I),\n\
	H is 1-exp(- (I* ((E-J)/E))).\n\
\n\
\n\
last_output_parametersX(C, G, J, I) :-\n\
	findall((A, B), (output(A, B, _), A=<C), D),\n\
	sort(D, E),\n\
	reverse(E, F),\n\
	nth0(0, F, (H, G)),\n\
	output(H, G, I),\n\
	sooner_same_camera(G, F, K, _),\n\
	J is C-K.\n\
\n\
\n\
averlist(A, C) :-\n\
	sumlist(A, D),\n\
	length(A, B),\n\
	B>0,\n\
	C is D/B.\n\
\n\
\n\
generate_esf_heads(A) :-\n\
	C is 1500,\n\
	step(I),\n\
	forall((teacher(A, D, E, F, G, _, _, B), B>=C), (H=a, assert(head(A, D, E, F, G, F, G, F, G, H)), (not(person(H))->assert(person(H)), update_person_count;true))),\n\
	J is A-I,\n\
	forall((head(J, D, E, F, G, F, G, F, G, H), not(head(A, D, E, _, _, _, _, _, _, H))), assert(head(A, D, E, F, G, F, G, F, G, H))).\n\
\n\
\n\
test_person_rule_step(C, D, A, B, G, E) :-\n\
	(   A=<B\n\
	->  (   person_rule(C, A, D, F)\n\
	    ->  export(graph, A, [ (color, E), (value, F)])\n\
	    ;   true\n\
	    ),\n\
	    H is A+G,\n\
	    test_person_rule_step(C, D, H, B, G, E)\n\
	).\n\
\n\
\n\
main_step(A, D) :-\n\
	real_time_generate(A),\n\
	find_best_camera(A, B, C),\n\
	insert_output(A, B, C, D).\n\
\n\
\n\
future_past_person_visible(B, F, A, X) :-\n\
	camera(A, P, R, S, T, E, U),\n\
	rule_configuration(s_person_visible_window, G, D),\n\
	step(C),\n\
	head_positions(B, C, D, E, F, I),\n\
	head_positions(B, -C, G, E, F, H),\n\
	append(H, I, K),\n\
	findall(J, member((J, _), K), M),\n\
	findall(L, member((_, L), K), N),\n\
	averlist(M, O),\n\
	averlist(N, Q),\n\
	O>=P,\n\
	Q>=R,\n\
	O<P+S,\n\
	Q<R+T,\n\
	(   is_moving_virtual_camera(A)\n\
	->  moving_virtual_camera_id(F, U)\n\
	;   true\n\
	),\n\
	W is 1-abs(P+S/2-O)/ (S/2),\n\
	(   E=3\n\
	->  V is 1-min((Q*0.5-R)/T, 1)\n\
	;   V is 1-min((Q*1-R)/T, 1)\n\
	),\n\
	Y is (W+V)/2,\n\
	X is min(Y, 1).\n\
\n\
\n\
generate_all_hand_move(A, B) :-\n\
	forall((bagof(C, get_hand_move(A, -B, E, F, C), D), averlist(D, G)), assert(hand_move(A, E, F, G))).\n\
\n\
\n\
esf_heads_step(A, B, H, C, D, E, F, G) :-\n\
	(   A=<B\n\
	->  assert(head(A, C, D, E, F, E, F, E, F, G)),\n\
	    I is A+H,\n\
	    esf_heads_step(I, B, H, C, D, E, F, G)\n\
	).\n\
\n\
\n\
do_stepXXX(A, B, E) :-\n\
	(   A=<B\n\
	->  ignore((\n\
		real_time_generate(A),\n\
		find_best_camera(A, C, D),\n\
		insert_output(A, C, D)\n\
		)),\n\
	    F is A+E,\n\
	    do_step(F, B, E)\n\
	).\n\
\n\
\n\
will_speak(A, B, F) :-\n\
	not(is_speaking(A, B)),\n\
	start_speaking(C, B),\n\
	C>A,\n\
	not(stop_speaking(C, B)),\n\
	not((\n\
	    start_speaking(D, B),\n\
	    D>A,\n\
	    D<C,\n\
	    not(stop_speaking(D, B))\n\
	    )),\n\
	not((\n\
	    stop_speaking(E, B),\n\
	    E>A,\n\
	    E<C,\n\
	    not(start_speaking(E, B))\n\
	    )),\n\
	F is C-A.\n\
\n\
\n\
generate_person_activity_step(A, B, C) :-\n\
	(   A=<B\n\
	->  generate_person_activity(A),\n\
	    D is A+C,\n\
	    generate_person_activity_step(D, B, C)\n\
	).\n\
\n\
\n\
last_output_optimized(A, B) :-\n\
	last_output_actual(A, B, _).\n\
\n\
\n\
last_output(A, B) :-\n\
	last_output_parameters(A, B, _).\n\
\n\
\n\
hand_moves(C, D, A, G, H, B) :-\n\
	(   A=<0\n\
	->  B=[]\n\
	;   E is C+D,\n\
	    F is A-abs(D),\n\
	    hand_moves(E, D, F, G, H, J),\n\
	    (   hand_move(C, G, H, I)\n\
	    ->  B=[I|J]\n\
	    ;   B=J\n\
	    )\n\
	).\n\
\n\
\n\
garbage_collector(A) :-\n\
	rule_configuration(s_garbage_collector, B),\n\
	D is A-B,\n\
	(   output(C, _, _),\n\
	    C>=D\n\
	->  forall((output(E, _, _), E<D), retractall(output(E, _, _)))\n\
	;   true\n\
	),\n\
	(   slide(F, _),\n\
	    F>=D\n\
	->  forall((slide(F, _), F<D), retractall(slide(F, _)))\n\
	;   true\n\
	),\n\
	forall((head(G, _, _, _, _, _, _, _, _, _), G<D), retractall(head(G, _, _, _, _, _, _, _, _, _))),\n\
	forall((head_move(H, _, _, _), H<D), retractall(head_move(H, _, _, _))),\n\
	forall((hand_move(I, _, _, _), I<D), retractall(hand_move(I, _, _, _))).\n\
\n\
\n\
generate_all_hand_move_step(A, B, C) :-\n\
	(   A=<B\n\
	->  ignore(generate_all_hand_move(A, C)),\n\
	    D is A+C,\n\
	    generate_all_hand_move_step(D, B, C)\n\
	).\n\
\n\
\n\
start_speaking0(A, C) :-\n\
	event_start_speaking(A, B),\n\
	get_parameter(B, person, C).\n\
\n\
\n\
export_parameters([]).\n\
export_parameters([ (A, B)|C]) :-\n\
	write('('),\n\
	write(A),\n\
	write(', '),\n\
	write(B),\n\
	write(')'),\n\
	(   C\\==[]\n\
	->  write(', ')\n\
	;   true\n\
	),\n\
	export_parameters(C).\n\
\n\
\n\
evaluation_techf(A) :-\n\
	string_concat(A, '.tech.txt', B),\n\
	tell(B),\n\
	evaluation_tech,\n\
	told.\n\
\n\
\n\
last_output_optimized(A, B, C) :-\n\
	(   last_output_actual(A, B, C)\n\
	->  true\n\
	;   last_output(A, B, C)\n\
	).\n\
\n\
\n\
person_visible(C, A, B, G) :-\n\
	(   fixed_visible(A, B, H)\n\
	->  (   person_movement(C, A, E),\n\
		fixed_visibility_regarding_state(B, D, F, I),\n\
		member(A, D),\n\
		member(E, F)\n\
	    ->  G is min(max(H*I, 0), 1)\n\
	    ;   G is H\n\
	    )\n\
	;   future_past_person_visible(C, A, B, G)\n\
	).\n\
\n\
\n\
output_rule_logo(A, A, [], _).\n\
output_rule_logo(D, R, [A|S], B) :-\n\
	(G, I, K, M, O)=A,\n\
	string_concat('EffectL', B, E),\n\
	string_concat('PIPL', B, C),\n\
	string_concat(C, 'Camera', F),\n\
	string_concat(C, 'CenterX', H),\n\
	string_concat(C, 'CenterY', J),\n\
	string_concat(C, 'RatioX', L),\n\
	string_concat(C, 'RatioY', N),\n\
	string_concat(C, 'Transparent', P),\n\
	append(D, [ (E, C), (F, G), (H, I), (J, K), (L, M), (N, O), (P, 1)], Q),\n\
	T is B+1,\n\
	output_rule_logo(Q, R, S, T).\n\
\n\
\n\
head_full_positions(C, E, A, H, I, B) :-\n\
	(   A=<0\n\
	->  B=[]\n\
	;   step(D),\n\
	    F is C+D*E,\n\
	    G is A-abs(D),\n\
	    head_full_positions(F, E, G, H, I, P),\n\
	    (   head(C, H, _, J, K, L, M, N, O, I)\n\
	    ->  B=[ (J, K, L, M, N, O)|P]\n\
	    ;   B=P\n\
	    )\n\
	).\n\
\n\
\n\
is_virtual_camera(A, B) :-\n\
	camera(A, _, _, _, _, B, _),\n\
	B\\==A.\n\
\n\
\n\
on_camera(A, B, C, D) :-\n\
	on_camera0(A, B, C, D),\n\
	not(sooner_on_camera0(A, B, C, D)).\n\
\n\
\n\
init_persons :-\n\
	(   test_mode([offline, half_realtime])\n\
	->  ignore(generate_all_persons)\n\
	;   true\n\
	),\n\
	update_person_count.\n\
\n\
\n\
test_person_activity(A, E) :-\n\
	begin(B),\n\
	end(C),\n\
	step(D),\n\
	(   test_person_activity_step(A, B, C, D, E)\n\
	;   true\n\
	).\n\
\n\
\n\
is_silverscreen_camera(A) :-\n\
	is_silverscreen_virtual_camera_id(A).\n\
\n\
\n\
pred_last_output_parameters(B, D, E, F, G) :-\n\
	once((\n\
	    output(A, C, H),\n\
	    A=<B\n\
	    )),\n\
	(   C\\=D\n\
	->  E=C,\n\
	    F is 0,\n\
	    G=H\n\
	;   once((\n\
		output(I, E, _),\n\
		I=<A,\n\
		E\\=C\n\
		))\n\
	->  findall(J, J^K^ (output(J, C, K), J>I, J=<A), L),\n\
	    last(L, M),\n\
	    output(I, E, G),\n\
	    F is B-M\n\
	;   fail\n\
	).\n\
\n\
\n\
output_rule_order(o_basic).\n\
output_rule_order(o_summarization_fadeX).\n\
output_rule_order(o_virtual_cameras_zooming_moving).\n\
output_rule_order(o_virtual_cameras_simple).\n\
output_rule_order(o_pip_in_third_camera).\n\
output_rule_order(o_pip_background_camera).\n\
output_rule_order(o_perspective_cameras_simple).\n\
output_rule_order(o_logo).\n\
output_rule_order(o_summarization_fade_out).\n\
output_rule_order(o_summarization_fade_in).\n\
\n\
\n\
test_person_rulef(A, C, H) :-\n\
	string_concat(A, '_', B),\n\
	string_concat(B, C, D),\n\
	string_concat(D, '_', E),\n\
	F=E,\n\
	string_concat(F, '.pl', G),\n\
	tell(G),\n\
	test_person_rule(A, C, H),\n\
	told.\n\
test_person_rulef(A, B, C) :-\n\
	test_person_rulef(A, B, C, 0).\n\
\n\
\n\
do_realtime_step(A, D) :-\n\
	once(find_best_camera(A, C)),\n\
	findall(B, output_rule_order(B), E),\n\
	evaluate_output_step(A, C, [], D, E),\n\
	(   last_output_parameters(A, F, G)\n\
	->  true\n\
	;   F=[],\n\
	    G=[]\n\
	),\n\
	(   (   C\\=F\n\
	    ;   D\\=G\n\
	    )\n\
	->  asserta(output(A, C, D))\n\
	;   fail\n\
	).\n\
\n\
\n\
init_import :-\n\
	(   test_mode([realtime])\n\
	->  retractall(event_head(_, _)),\n\
	    retractall(event_hand(_, _)),\n\
	    retractall(event_start_speaking(_, _)),\n\
	    retractall(event_stop_speaking(_, _)),\n\
	    retractall(event_teacher(_, _)),\n\
	    retractall(event_silverscreen(_, _)),\n\
	    retractall(event_prezentation_board(_, _)),\n\
	    retractall(event_prezentation_exchange(_, _))\n\
	;   true\n\
	).\n\
\n\
\n\
evaluation_estf(A) :-\n\
	string_concat(A, '.est.txt', B),\n\
	tell(B),\n\
	evaluation_est,\n\
	told.\n\
\n\
\n\
evaluate_person_activity(B, A, F) :-\n\
	rule_configuration_dynamic(s_person_mult, A, G),\n\
	findall(C, person_rule(_, B, A, C), D),\n\
	(   D=[]\n\
	->  E is 0\n\
	;   maxlist(D, E)\n\
	),\n\
	F is min(E*G, 1.0).\n\
\n\
\n\
generate_moving_virtual_cameras :-\n\
	write_begin('generating moving virtual cameras'),\n\
	begin(A),\n\
	end(B),\n\
	step(C),\n\
	retractall(moving_virtual_camera(_, _, _, _, _, _, _, _)),\n\
	ignore(generate_moving_virtual_cameras_step(A, B, C)),\n\
	write_done.\n\
\n\
\n\
find_best_camera(A, B) :-\n\
	find_best_camera(A, B, _).\n\
\n\
\n\
evaluation_hand_moving(B, F, A, J) :-\n\
	G is 5000,\n\
	D is 5000,\n\
	camera(A, _, _, _, _, E, _),\n\
	step(C),\n\
	hand_moves(B, C, D, E, F, H),\n\
	hand_moves(B, -C, G, E, F, I),\n\
	sumlist(H, K),\n\
	sumlist(I, L),\n\
	J is (K+L)/ (D+G).\n\
\n\
\n\
last_output_parametersX(C, F, H) :-\n\
	findall((A, B), (output(A, B, _), A=<C), D),\n\
	sort(D, E),\n\
	last(E, (G, F)),\n\
	output(G, F, H).\n\
\n\
\n\
run_main :-\n\
	begin(A),\n\
	end(B),\n\
	step(C),\n\
	ignore(do_step(A, B, C)).\n\
\n\
\n\
camera(A) :-\n\
	camera(A, _, _, _, _, _, _).\n\
\n\
\n\
get_head_move(A, D, B, C, G) :-\n\
	head(A, B, F, C, I, K),\n\
	E is A+D,\n\
	head(E, B, F, C, H, J),\n\
	G is sqrt((H-I)**2+ (J-K)**2).\n\
\n\
\n\
write_begin(A) :-\n\
	write(A),\n\
	write(...),\n\
	flush_output.\n\
\n\
\n\
camera_exp_base(A) :-\n\
	A is-log(0.01).\n\
\n\
\n\
generate_head_full_positions(A, B, C, D) :-\n\
	retractall(head_full_positions_static(_, A, B, C, D, _)),\n\
	begin(E),\n\
	end(F),\n\
	step(G),\n\
	ignore(generate_head_full_positions_step(A, B, C, D, E, F, G)),\n\
	true.\n\
\n\
\n\
hand0(A, C, D, E, F, G, H, I, J, K) :-\n\
	event_hand(A, B),\n\
	get_parameter(B, camera, C),\n\
	get_parameter(B, object, D),\n\
	get_parameter(B, centerx, E),\n\
	get_parameter(B, centery, F),\n\
	get_parameter(B, minx, G),\n\
	get_parameter(B, miny, H),\n\
	get_parameter(B, maxx, I),\n\
	get_parameter(B, maxy, J),\n\
	get_parameter(B, person, K).\n\
";