
#ifndef _TIMEDTRIPLES_H
#define _TIMEDTRIPLES_H

#include <string>
#include <vector>
#include <iostream>

#include "SSXMLParser.h"

using namespace std;


typedef struct tagTimedTriple
{
	string time;
	string object;
	string attribute;
	string value;
	string inputStr;
}
TTimedTriple;

typedef vector<TTimedTriple>		TTripleVector;
typedef TTripleVector::iterator		TTripleVector_it;


class TTimedTriples
{
public:
	TTripleVector triples;
	string input;

	// Transforms input into timed triples
	void toTimedTriples();
	void toTimedTriples(const string& inp);

public:
	TTimedTriples();
	TTimedTriples(const string& inp);
	~TTimedTriples();

	void Add(const string& str);

	// Returns timed triple
	bool getTimedTriple(TTimedTriple& triple, unsigned long time);
	bool getTimedTriple(TTimedTriple& triple, const string& time);
	bool getTimedTriple(TTimedTriple& triple, const string &object,
		const string &attribute, const string &value);
};

#endif // _TIMEDTRIPLES_H

