//---------------------------------------------------------------------------
#ifndef ImpExpH
#define ImpExpH
//---------------------------------------------------------------------------
#include <string>
#include <sys/stat.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <libxml/tree.h>
#include <vector>
#include <string>
#include "avfile.h"
#include "Events.h"
#include "Client.h"
#include "TimedTriples.h"

//---------------------------------------------------------------------------
class TImpExp
{
public:
	typedef enum
	{
		tfTime,
		tfFrames
	}
	TTimeFormat;

	enum TDefaultEventType
	{
		detOutput,
		detStartSpeaking,
		detStopSpeaking,
		detGraph,
		detSetup,
		detDetector
	};

	class TSource
	{
	public:
		std::string FileName;
		int Camera, Offset, Length, Width, Height, Loop;
		TAVFile::TFrameRate FrameRate;

		TSource()
		{
			Camera = -1;
			Width = Height = Length = Offset = Loop = 0;
			FrameRate.Rate = FrameRate.Scale = 1;
		}

		int ConvertTimeFormat(int Value, TTimeFormat Old, TTimeFormat New)
		{
			if (New == Old)
			{
				return Value;
			}
			else if (Old == tfTime)
			{
				return TAVFile::Round((double(Value) * double(FrameRate.Rate) / (1000.0 * double(FrameRate.Scale))));
			}
			else
			{
				return TAVFile::Round(double(Value) * 1000.0 * double(FrameRate.Scale) / double(FrameRate.Rate));
			}
		}
	};

private:
	struct TDefaultEvent
	{
		char *Name;
		char *Key;
		char *Group;
		int GroupIndex;
	};
	static TDefaultEvent DefaultEvents[];

	class TID_Translate
	{
	public:
		int ID1;
		int ID2;
		TID_Translate(): ID1(0), ID2(0) {};
		TID_Translate(int _ID1, int _ID2): ID1(_ID1), ID2(_ID2) {};
	};

	ee::TEventTypeGroups Groups;
	TTimeFormat TimeFormat;
	ee::TEvents::iterator LastEvent, LastInsertedEvent;
	std::vector<std::string> MediaPath;

	int FindMessageID(const char *Name);
	int GetMessageID(const char *Name);

	int FindGroupID(const char *Desc);
	int GetGroupID(const char *Desc);
	int AddGroup(ee::TEventTypeGroup Group);

	int GetCameraOffset(int Camera);
	int ConvertCameraTime(int Camera, int Time, TTimeFormat Old, TTimeFormat New);

	bool GetFileParameters(const char *FileName, TSource &Source);

	int xmlGetPropInt(xmlNodePtr Node, const xmlChar *Name, const int Default);

	void FreeEvents();

	void LoadFromXml(const char *FileName, bool Import, bool UseCameraOffset, int ForceCamera);
	void LoadFromHub(const char *FileName, bool Import, bool UseCameraOffset, int ForceCamera);
	void SaveToXml(const char *FileName);
	void SaveToHub(const char *FileName);

	bool        UseXml;
	AnsiString  InputFileName;
	Client      *HubClient;

public:
	typedef std::vector<TSource> TSources;
	TSources Sources;
	ee::TEventTypes EventTypes;
	ee::TEvents Events;

	TImpExp();
	~TImpExp();

	void Clear();

	void AddMediaPath(const char *DirName);
	void ClearMediaPath();
	void UpdateMedia();

	void CreateMedia(const char *DirName);

	void UpdateConfig(const char *FileName, const char *Meeting);
	void LoadXML(const char *FileName, bool Import, bool UseCameraOffset, int ForceCamera);
	void Load(const char *FileName, bool Import, bool UseCameraOffset, int ForceCamera);
	void Save(const char *FileName);
	void ImportProlog(const char *FileName);
	void ExportProlog(const char *FileName);
	void ImportTranscription(const char *FileName);
	void ImportAnvil(const char *FileName);

	static AnsiString AnsiString2Prolog(AnsiString s, bool Event = false);
	AnsiString Event2Prolog(ee::TEvent *e);
	static AnsiString Event2Prolog(int Time, const char *Type, ee::TParameters Parameters);

	int FindDefaultMessageID(const TDefaultEventType Type);
	int GetDefaultMessageID(const TDefaultEventType Type);

	void InitializeInsertMessage();
	void InsertMessage(ee::TEvent *e);
	void InsertMessage(int Time, const char *Type, ee::TParameters Parameters);

	void CopyEvents(TImpExp &Source);

	void SetUseXml(bool useXml) { UseXml = useXml; }

	static TDefaultEvent GetDefaultEvent(TDefaultEventType Type);
};

#endif

