//
// File:   Client.h
// Author: chmelarp
//
// Created on 17. březen 2008, 21:33
//

#ifndef _CLIENT_H
#define	_CLIENT_H

// Default remote connection
#define DefaultPort 4000
#define DefaultHost "147.229.8.37"

// Default connection parameters
#define BUFSIZE 2000

// Include
#include <iostream>
#include <string>
#include <stdlib.h>

#include "SSXMLParser.h"

// Platform dependent includes
#ifdef _WIN32

#ifdef __BORLANDC__
#include <winsock.h>
#endif
#include <windows.h>
// #include <ws2tcpip.h>

#include <time.h>

#else // Linux, UNIX, (test) Symbian

#include <unistd.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>

#endif

// Using
using namespace std;


//
// Client
//
class Client {
protected:
    string  hostName; // = "localhost"
    int     port; // = 4000
    int     sock; // socket
    hostent*    host;
    sockaddr_in remote;
    
#ifdef _WIN32 // nejede...
    WORD wVersionRequested; // ��slo verze
    WSADATA data;                           // Struktura s info. o knihovn�
#endif
    
    
public:
    
    // Writes XML Header
    bool writeHeader();

    // Writes TimedTriple
    bool writeTimedTriple(                   const string object, \
                          const string attribute, const string value);

    // Writes TimedTriple
    bool writeTimedTriple(const string time, const string object, \
                          const string attribute, const string value);

    // Writes TimedTriple Query
    bool writeQuery(                        const string object, \
                          const string attribute, const string value);
    // Writes TimedTriple Query
    bool writeQuery(const int start, const int end, const string object, \
                    const string attribute, const string value);

    // Reads whole reply and returns it in a string
    SSXMLParser readReply();
    
    // Writes a text using send (returns sucess)
    bool write(const string msg);

    // Writes a line using send (returns sucess)
    bool writeln(const string msg);
    
    // Reads a line using rcv (or returns null)
    string read() { return rcv(); };

    // Parses first TimedTriple 
    // @return the position of last character (>) of the TimedTriple tag
    int parseTimedTriple(string& str, const bool trim,  \
                          string& time, string& object, \
                          string& attribute, string& value);
    
    // Constructor
    Client(const string h = DefaultHost, const int p = DefaultPort) {
		hostName = h;
		port = p;
		sock = -1;

	#ifdef _WIN32
		wVersionRequested = MAKEWORD(1,1);
	#endif
    };

    
    // Destructor
    ~Client() {
        cls();
    };
    
    // Connect to remote host
    // @return sucess
    bool conn();
    
    // Send
    // @return sucess
    bool snd(const string msg);
    
    // Receive
    // @return string (empty if no sucess)
    string rcv();
    
    // Close the connection
    void cls();

    // Validity
    bool vld() { return sock != -1; };
    
    // Error handler
    void error(const string message);
    
};


#endif	/* _CLIENT_H */


