:- include('configuration.basic.pl').

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% other setup
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% s_mode
% p1 - working mode (offline, realtime)
rule_configuration(s_mode, realtime).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% s_person_visible_window
% p1 - time before meeting end
rule_configuration(s_presentation_finish, 5000).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% s_person_visible_window
% p1 - past window
% p2 - future window
%rule_configuration(s_person_visible_window, 0, 5000).
rule_configuration(s_person_visible_window, 2000, 3000).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% s_person_mult
% p1 - person
% p2 - weight
rule_configuration(s_person_mult, a, 1).
rule_configuration(s_person_mult, b, 1).
rule_configuration(s_person_mult, c, 1).
rule_configuration(s_person_mult, d, 1).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% s_fixed_virtual_cameras
rule_configuration(s_fixed_virtual_cameras).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% s_moving_virtual_cameras
% p1 - zoom
% p2 - vertical offset
% p3 - past window
% p4 - future window
% p5 - time offset
% p6 - threshold
% rule_configuration(s_moving_virtual_cameras, 2, 1/2, 520, 520, 520, 0.05).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% output rules
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% o_summarization_fade
% p1 - length of fade
rule_configuration(o_summarization_fade, 240).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% o_virtual_cameras_zooming_moving
% p1 - length of the effect
% p2 - 1/0 = enable/disable zooming
% p3 - 1/0 = enable/disable moving
rule_configuration(o_virtual_cameras_zooming_moving, 1000, 1, 0).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% o_virtual_cameras_simple
%rule_configuration(o_virtual_cameras_simple).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% camera rules
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c_intro_virtual_supress
% c_intro_physical
rule_configuration(c_intro_virtual_supress).
rule_configuration(c_intro_physical).
rule_configuration(c_finish_virtual_supress).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c_anti_quick
% p1 - time when is impossible to cut to other camera
% p2 - time when is possible to cut to other camera with the same probability 
rule_configuration(c_anti_quick, 2000, 20000).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c_anti_lazy
% p1 - time from which selected camera is being suppressed
% p2 - time from which selected camera is suppressed to ~10%
rule_configuration(c_anti_lazy, 10000, 20000).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c_anti_swap
% minimum time of selection of one camera
rule_configuration(c_anti_swap, 240).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c_initial_random_camera
rule_configuration(c_initial_random_camera).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c_random_camera
%rule_configuration(c_random_camera).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% evaluation of persons activity
rule_configuration(c_person_activity).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% supress all virtual cameras at the beginning
rule_configuration(c_virtual_supress_first).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% appply the same anti_lazy rule to parent of selected virtual cemara 
rule_configuration(c_virtual_parent_anti_lazy).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% supress all other virtual cameras on the same parent camera
%rule_configuration(c_virtual_supress_same_parent).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% supress all virtual cameras except selected virtual camera and all
% virtual cameras on selected parent
%rule_configuration(c_virtual_supress_other_parent).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% forbide summarazation at the beginning
%rule_configuration(c_summarization_supress).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% summarization1
%rule_configuration(c_summarization1, 0.15).
%rule_configuration(c_summarization2, 0.15).
%rule_configuration(c_summarization3, 0.15).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c_const
% p1 - camera
% p2 - weight
%rule_configuration(c_const, 2200, 1).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% person rules
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% time from which rule is at least set to ~0.9
%
rule_configuration(p_past_speaking, 5000).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% time from which rule is at least set to ~0.9
%
rule_configuration(p_future_speaking, 2000).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p_past_head_moving
% p1 - size of time window
% p2 - minimal trashold
% p3 - saturaion
%rule_configuration(p_past_head_moving, 5000, 0.025, 0.25).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p_future_head_moving
% p1 - size of time window
% p2 - minimal trashold
% p3 - saturaion
%rule_configuration(p_future_head_moving, 2000, 0.025, 0.25).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p_future_past_head_moving
% p1 - size of past time window
% p2 - size of future time window
% p3 - minimal trashold
% p4 - saturaion
rule_configuration(p_future_past_head_moving, 2000, 3000, 0.025, 0.25).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p_past_hand_moving
% p1 - size of time window
% p2 - minimal trashold
% p3 - saturaion
%rule_configuration(p_past_hand_moving, 5000, 0.025, 0.25).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p_future_hand_moving
% p1 - size of time window
% p2 - minimal trashold
% p3 - saturaion
%rule_configuration(p_future_hand_moving, 2000, 0.025, 0.25).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p_future_past_hand_moving
% p1 - size of past time window
% p2 - size of future time window
% p3 - minimal trashold
% p4 - saturaion
rule_configuration(p_future_past_hand_moving, 2000, 3000, 0.025, 0.25).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p_const
% p1 - person
% p2 - weight
%rule_configuration(p_const, a, 0.5).
%rule_configuration(p_const, b, 1).
%rule_configuration(p_const, c, 1).
%rule_configuration(p_const, d, 1).
