%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Konfigurace
% configuration.pl
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- include('configuration.basic.pl').

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ostatn nastaven
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% s_mode
% p1 - mod cinnosti (offline, realtime)
%rule_configuration(s_mode, offline).
%rule_configuration(s_mode, online).
rule_configuration(s_mode, realtime).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% s_person_visible_window
% p1 - velikost okna v minulosti
% p2 - velikost okna v budoucnosti
%rule_configuration(s_person_visible_window, 2000, 3000).
rule_configuration(s_person_visible_window, 2000, 0).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% s_person_mult
% p1 - osoba
% p2 - vha
rule_configuration(s_person_mult, a, 1).
rule_configuration(s_person_mult, b, 1).
rule_configuration(s_person_mult, c, 1).
rule_configuration(s_person_mult, d, 1).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% s_fixed_virtual_cameras
rule_configuration(s_fixed_virtual_cameras, 1, 101, 2, 180, 276).
rule_configuration(s_fixed_virtual_cameras, 1, 102, 2, 500, 276).
rule_configuration(s_fixed_virtual_cameras, 2, 101, 2, 180, 276).
rule_configuration(s_fixed_virtual_cameras, 2, 102, 2, 500, 276).
%rule_configuration(s_fixed_virtual_cameras, 3, 101, 2, 180, 276).
%rule_configuration(s_fixed_virtual_cameras, 3, 102, 2, 540, 276).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% s_moving_virtual_cameras
% p1 - zoom
% p2 - vertikln offset
% p3 - velikost okna v minulosti
% p4 - velikost okna v budoucnosti
% p5 - asov offset
% p6 - prh
%rule_configuration(s_moving_virtual_cameras, 2, 1/2, 520, 520, 520, 0.05).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% vstupni pravidla
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% o_summarization_fade
% p1 - dlka pechodu
rule_configuration(o_summarization_fade, 240).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% o_pip_in_third_camera
rule_configuration(o_pip_in_third_camera).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% o_virtual_cameras_zooming_moving
% p1 - dlka pechodu
% p2 - 1/0 = enable/disable zooming
% p3 - 1/0 = enable/disable moving
rule_configuration(o_virtual_cameras_zooming_moving, 1000, 1, 0).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% o_virtual_cameras_simple
%rule_configuration(o_virtual_cameras_simple).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% kamerov pravidla
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c_intro_virtual_supress
% c_intro_physical
rule_configuration(c_intro_virtual_supress).
rule_configuration(c_intro_physical).
rule_configuration(c_finish_virtual_supress).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c_anti_quick
% p1 - as dokud nen mon pepnout na jinou kameru
% p2 - as kdy nen omezovno pepnut na jinou kameru
rule_configuration(c_anti_quick, 2000, 38000).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c_anti_lazy
% p1 - as kdy zane omezovn aktuln kamery
% p2 - as kdy aktuln kamera omezena na ~1% sv vhy
rule_configuration(c_anti_lazy, 10000, 30000).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c_anti_swap
% minimln as trvn zbru
rule_configuration(c_anti_swap, 240).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c_initial_random_camera
rule_configuration(c_initial_random_camera).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c_random_camera
%rule_configuration(c_random_camera).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rule_configuration(c_person_activity).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% potlaen virtulnch kamer na zatku poadu
rule_configuration(c_virtual_supress_first).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% aplikace stejnho anti lazy pravidla na korespondujc fyzickou kameru
% kamery virtuln
rule_configuration(c_virtual_parent_anti_lazy).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% potlaen ostatnch virtulnch kamer na stejn fyzick kamee
rule_configuration(c_virtual_supress_same_parent).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% potlaeni ostatnch virtulnch kamer na jin fyzick kamee
% krom dialogovch dvojic
rule_configuration(c_virtual_supress_other_parent).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% potlaeni virtulnch kamer na prv vybran fyzick kamee
rule_configuration(c_virtual_supress_parent, 3).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% potlaen sumarizan kamery v vodu
%rule_configuration(c_summarization_supress).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% sumarizace
%rule_configuration(c_summarization1, 0.15).
%rule_configuration(c_summarization2, 0.15).
%rule_configuration(c_summarization3, 0.15).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c_const
% p1 - kamera
% p2 - vha
%rule_configuration(c_const, 2200, 1).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% osobn pravidla
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p1 - as kdy je hodnota pravidla na ~0.99
rule_configuration(p_past_speaking_exp, 10000).
%rule_configuration(p_past_speaking_cos, 10000).
%rule_configuration(p_past_speaking_inv_exp, 10000).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p1 - as kdy pravidlo zane psobit (kon na ~0.99)
%rule_configuration(p_future_speaking_exp, 2000).
%rule_configuration(p_future_speaking_cos, 2000).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p_future_past_speaking_exp
% p1 - as kdy pravidlo zane psobit
% p2 - as kdy je hodnota pravidla na ~0.99
%rule_configuration(p_future_past_speaking_exp, 2000, 10000).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p_past_head_moving
% p1 - velikost okna
% p2 - minimln prh
% p3 - saturace
rule_configuration(p_past_head_moving, 2000, 0.025, 0.25).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p_future_head_moving
% p1 - velikost okna
% p2 - minimln prh
% p3 - saturace
%rule_configuration(p_future_head_moving, 2000, 0.025, 0.25).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p_future_past_head_moving
% p1 - velikost okna v minulosti
% p2 - velikost okna v budoucnosti
% p3 - minimln prh
% p4 - saturace
%rule_configuration(p_future_past_head_moving, 2000, 3000, 0.025, 0.25).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p_past_hand_moving
% p1 - velikost okna
% p2 - minimln prh
% p3 - saturace
rule_configuration(p_past_hand_moving, 2000, 0.025, 0.25).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p_future_hand_moving
% p1 - velikost okna
% p2 - minimln prh
% p3 - saturace
%rule_configuration(p_future_hand_moving, 2000, 0.025, 0.25).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p_future_past_hand_moving
% p1 - velikost okna v minulosti
% p2 - velikost okna v budoucnosti
% p3 - minimln prh
% p4 - saturace
%rule_configuration(p_future_past_hand_moving, 2000, 3000, 0.025, 0.25).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p_const
% p1 - osoba
% p2 - vha
%rule_configuration(p_const, a, 1).
%rule_configuration(p_const, b, 1).
%rule_configuration(p_const, c, 1).
%rule_configuration(p_const, d, 1).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% pravidla modelu
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rule_configuration(m_undefined_intro).
rule_configuration(m_intro_presentation).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% m_person_visible_window
% p1 - as ped koncem poadu
rule_configuration(m_presentation_finish, 5000).
