%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Sumarizace
% summarization.pl
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% zjitn dlky vygenerovanho poadu
get_length(Length) :-
  begin(B),
  end(E),
  step(S),
  get_length_step(B, E, S, -1, Length).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_length_step(Time, End, Step, Camera, Length) :-
  (   Time < End
  ->   (   output(Time, OC, _)
       ->  C = OC
       ;   C = Camera
       ),
      T is Time + Step,
      get_length_step(T, End, Step, C, L),
      ((C < 0) -> Length is L; Length is L + Step)
  ;   Length is 0
  ).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% iterativn sumarizace
summarization_step(Min, Max, Step):-
  (   Min =< Max 
  ->  string_concat('output', '_', File1), 
      string_concat(File1, Min, File2), 
      string_concat(File2, '.pl', File),
      tell(File),
      init_main,
      assert(temp_configuration(c_summarization1, Min)),
      assert(temp_configuration(c_summarization2, Min)),
      assert(temp_configuration(c_summarization3, Min)),
      run_main,
      get_length(Length),
      export('result', 0, [('treshold', Min), ('length', Length)]),
      told,
      M is Min + Step,
      summarization_step(M, Max, Step)
  ;   true
  ).

