%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Detekce eov aktivity
% speaking.pl
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
is_speaking_all(Time, Person, HowLong):-
  start_speaking(T, Person),
  T =< Time,
  not(stop_speaking(T, Person)),
  not((stop_speaking(T2, Person), T2 >= T, T2 =< Time, not(start_speaking(T2, Person)))),
  HowLong is Time - T.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% hovo dana osoba?
is_speaking(Time, Person, HowLong):-
  bagof(HowLong, is_speaking_all(Time, Person, HowLong), S),
  maxlist(S, HowLong).

is_speakingX(Time, Person, HowLong):-
  once(is_speaking_all(Time, Person, HowLong)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
is_speaking(Time, Person):-
	is_speaking(Time, Person, _).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% bude hovoit dan osoba?
will_speak(Time, Person, HowLong):-
  not(is_speaking(Time, Person)),
  start_speaking(T1, Person),
  T1 > Time,
  not(stop_speaking(T1, Person)),
  not((start_speaking(T2, Person), T2 > Time, T2 < T1, not(stop_speaking(T2, Person)))),
  not((stop_speaking(T3, Person), T3 > Time, T3 < T1, not(start_speaking(T3, Person)))),
  HowLong is T1 - Time.
