%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Pravidla pro zmnu stavu modelu
% rules_model.pl
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
model_rule(Name, _, undefined, intro) :-
  Name = 'm_undefined_intro',
  rule_configuration(Name).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
model_rule(Name, Time, intro, presentation) :-
  Name = 'm_intro_presentation',
  rule_configuration(Name),
  (setof(C, T^L^(output(T, C, L), T < Time), Cameras) -> true; Cameras = []),
  (setof(C, (camera(C), not(is_empty_camera(C)), not(is_virtual_camera(C))), P) -> true; P = []),
  subset(P, Cameras).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
model_rule(Name, Time, intro, presentation) :-
  Name = 'm_intro_presentation',
  rule_configuration(Name, Length),
  begin(Begin),
  Time - Begin >= Length.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
model_rule(Name, Time, presentation, finish) :-
  Name = 'm_presentation_finish',
  rule_configuration(Name, Length),
  end(End),
  End - Time =< Length.
