%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Import a export dat
% impexp.pl
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
init_import :-
  (   test_mode([realtime]) 
  ->  retractall(event_head(_, _)),
      retractall(event_hand(_, _)),
      retractall(event_start_speaking(_, _)),
      retractall(event_stop_speaking(_, _)),
      retractall(event_teacher(_, _)),
      retractall(event_silverscreen(_, _)),
      retractall(event_prezentation_board(_, _)),
      retractall(event_prezentation_exchange(_, _))
  ;   true
  ).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_parameter([(FirstName, FirstValue)|Tail], Name, Value) :-
  (FirstName = Name) -> Value = FirstValue;
  get_parameter(Tail, Name, Value).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
import:-
  retractall(head(_, _, _, _, _, _, _, _, _, _)),
  retractall(hand(_, _, _, _, _, _, _, _, _, _)),

  assert(start_speaking(1, 2)),
  retractall(start_speaking(_, _)),
  assert(stop_speaking(1, 2)),
  retractall(stop_speaking(_, _)),
  
  retractall(movement(_, _, _)),
  retractall(silverscreen(_, _, _, _, _, _, _, _, _, _)),
  retractall(teacher(_, _, _, _, _, _, _, _)),

  retractall(slide(_, _)),

  assert(silverscreen(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)),
  retractall(silverscreen(_, _, _, _, _, _, _, _, _, _)),
  assert(teacher(1, 2, 3, 4, 5, 6, 7, 8)),
  retractall(teacher(_, _, _, _, _, _, _, _)),
  
  
%  retractall(movement_sit(_, _)),
%  retractall(movement_stand_whiteboard(_, _)),
  write_begin('importing'),
  import_step,
  write_done.

import_step :-
  set_prolog_flag(unknown, warning),
  ignore(import_step_internal),
  set_prolog_flag(unknown, error).
  
import_step_internal :-
  forall(event_prezentation_exchange(T, P),
	 (get_parameter(P, camera, Camera),
	  assert(slide(T, Camera))
	 )),
	
  forall(event_head(T, P),
	 (get_parameter(P, camera, Camera),
	  get_parameter(P, object, Object),
	  get_parameter(P, centerx, CenterX),
	  get_parameter(P, centery, CenterY),
	  get_parameter(P, minx, MinX),
	  get_parameter(P, miny, MinY),
	  get_parameter(P, maxx, MaxX),
	  get_parameter(P, maxy, MaxY),
	  get_parameter(P, person, Person),
	  assert(head(T, Camera, Object, CenterX, CenterY, MinX, MinY, MaxX, MaxY, Person))
	 )),
  forall(event_hand(T, P),
	 (get_parameter(P, camera, Camera),
	  get_parameter(P, object, Object),
	  get_parameter(P, centerx, CenterX),
	  get_parameter(P, centery, CenterY),
	  get_parameter(P, minx, MinX),
	  get_parameter(P, miny, MinY),
	  get_parameter(P, maxx, MaxX),
	  get_parameter(P, maxy, MaxY),
	  get_parameter(P, person, Person),
	  assert(hand(T, Camera, Object, CenterX, CenterY, MinX, MinY, MaxX, MaxY, Person))
	 )),
  
  forall(event_silverscreen(T, P),
	 (get_parameter(P, camera, Camera),
	  get_parameter(P, x1, X1),
	  get_parameter(P, y1, Y1),
	  get_parameter(P, x2, X2),
	  get_parameter(P, y2, Y2),
	  get_parameter(P, x3, X3),
	  get_parameter(P, y3, Y3),
	  get_parameter(P, x4, X4),
	  get_parameter(P, y4, Y4),

	  assert(silverscreen(T, Camera, X1, Y1, X2, Y2, X3, Y3, X4, Y4))
	 )),

  forall(event_prezentation_board(T, P),
	 (get_parameter(P, camera, Camera),
	  get_parameter(P, x1, X1),
	  get_parameter(P, y1, Y1),
	  get_parameter(P, x2, X2),
	  get_parameter(P, y2, Y2),
	  get_parameter(P, x3, X3),
	  get_parameter(P, y3, Y3),
	  get_parameter(P, x4, X4),
	  get_parameter(P, y4, Y4),

	  assert(silverscreen(T, Camera, X1, Y1, X2, Y2, X3, Y3, X4, Y4))
	 )),

  forall(event_teacher(T, P),
	 (get_parameter(P, camera, Camera),
	  get_parameter(P, object, Object),
	  get_parameter(P, centerx, CenterX),
	  get_parameter(P, centery, CenterY),
	  get_parameter(P, divergencex, DivergenceX),
	  get_parameter(P, divergencey, DivergenceY),
	  get_parameter(P, size, Size),

	  assert(teacher(T, Camera, Object, CenterX, CenterY, DivergenceX, DivergenceY, Size))
	 )),

  forall(event_start_speaking(T, P),
	 (get_parameter(P, person, Person1),
	  person_translate(Person1, Person2),
	  assert(start_speaking(T, Person2))
	 )),
  forall(event_stop_speaking(T, P),
	 (get_parameter(P, person, Person1),
	  person_translate(Person1, Person2),
	  assert(stop_speaking(T, Person2))
	 )),
    
  forall(event_sit(T, P),
	 (get_parameter(P, individual, Person1),
	  person_translate(Person1, Person2),
	  assert(movement(T, Person2, sit))
	 )),

  forall(event_off_camera(T, P),
	 (get_parameter(P, individual, Person1),
	  person_translate(Person1, Person2),
	  assert(movement(T, Person2, off_camera))
	 )),
  
  forall(event_take_notes(T, P),
	 (get_parameter(P, individual, Person1),
	  person_translate(Person1, Person2),
	  assert(movement(T, Person2, take_notes))
	 )),

  forall(event_stand_whiteboard(T, P),
	 (get_parameter(P, individual, Person1),
	  person_translate(Person1, Person2),
	  assert(movement(T, Person2, stand_whiteboard))
	 )),
  
  forall(event_stand_screen(T, P),
	 (get_parameter(P, individual, Person1),
	  person_translate(Person1, Person2),
	  assert(movement(T, Person2, stand_screen))
	 )),

  forall(event_other(T, P),
	 (get_parameter(P, individual, Person1),
	  person_translate(Person1, Person2),
	  assert(movement(T, Person2, other))
	 )),
  
  forall(event_move(T, P),
	 (get_parameter(P, individual, Person1),
	  person_translate(Person1, Person2),
	  assert(movement(T, Person2, move))
	 )),
  
  
%  (   not((event_start_speaking(_, _); event_stop_speaking(_, _)))
%  ->  forall((person_interactivity(T, Person, P), 
%              get_parameter(P, interactivity, Interactivity), 
%	      (Interactivity = talking; Interactivity = laughing)
%	     ),
%	     (assert(start_speaking(T, Person)),
%	      get_parameter(P, length, Length),
%	      T2 is T + Length,
%	      assert(stop_speaking(T2, Person))
%	     ))
%  ;   true
%  ),
  init_import.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
export_parameters([]) :- true.
export_parameters([(FirstName, FirstValue)|Tail]) :-
  write('('), write(FirstName), write(', '), write(FirstValue), write(')'),
  ((Tail \== [])->write(', ');true),
  export_parameters(Tail).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
export(Event, Time, Parameters):-
  write('event_'), write(Event), 
  write('('), write(Time), write(', ['), 
  export_parameters(Parameters), 
  write(']).'), nl.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
head0(Time, Camera, Object, CenterX, CenterY, MinX, MinY, MaxX, MaxY, Person):-
  event_head(Time, P),
  get_parameter(P, camera, Camera),
  get_parameter(P, object, Object),
  get_parameter(P, centerx, CenterX),
  get_parameter(P, centery, CenterY),
  get_parameter(P, minx, MinX),
  get_parameter(P, miny, MinY),
  get_parameter(P, maxx, MaxX),
  get_parameter(P, maxy, MaxY),
  get_parameter(P, person, Person).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
hand0(Time, Camera, Object, CenterX, CenterY, MinX, MinY, MaxX, MaxY, Person):-
  event_hand(Time, P),
  get_parameter(P, camera, Camera),
  get_parameter(P, object, Object),
  get_parameter(P, centerx, CenterX),
  get_parameter(P, centery, CenterY),
  get_parameter(P, minx, MinX),
  get_parameter(P, miny, MinY),
  get_parameter(P, maxx, MaxX),
  get_parameter(P, maxy, MaxY),
  get_parameter(P, person, Person).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
start_speaking0(Time, Person):-
  event_start_speaking(Time, P),
  get_parameter(P, person, Person).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
stop_speaking0(Time, Person):-
  event_stop_speaking(Time, P),
  get_parameter(P, person, Person).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
person_interactivity(Time, Person, P):-
  (event_person1_interactivity(Time, P), Person = 'a');
  (event_person2_interactivity(Time, P), Person = 'b');
  (event_person3_interactivity(Time, P), Person = 'c');
  (event_person4_interactivity(Time, P), Person = 'd').

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
start_speaking1(Time, Person):-
  person_interactivity(Time, Person, P),
  get_parameter(P, interactivity, Interactivity),
  (Interactivity = talking; Interactivity = laughing).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
stop_speaking1(Time, Person):-
  person_interactivity(T, Person, P),
  get_parameter(P, length, Length),
  Time is T + Length,
  get_parameter(P, interactivity, Interactivity),
  (Interactivity = talking; Interactivity = laughing).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
person_translate(ID1, ID2) :-
  fixed_person_translate(ID1, ID2) -> true;
  ID2 = ID1.

