%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear_eval_value(Name):-
  retractall(eval_value(Name, _)),
  assert(eval_value(Name, 0)).

inc_eval_value(Name):-
  eval_value(Name, Value),
  retractall(eval_value(Name, _)),
  NewValue is Value + 1,
  assert(eval_value(Name, NewValue)).

print_eval_value(Name):-
  eval_value(Name, Value),
  write(Name), tab(1), write(Value), nl.

print_eval_perc(Name1, Name2):-
  eval_value(Name1, Value1),
  eval_value(Name2, Value2),
  (   (Value1 + Value2) > 0
  ->  Percent is 100 * Value1 / (Value1 + Value2),
      write(Name1), write('_percent'), tab(1), write(Percent), nl
  ;   write('error'), nl
  ).

print_eval_perc2(Names1, Name2):-
  eval_value(Name2, Value2),
  findall(Value1, (member(Name1, Names1), eval_value(Name1, Value1)), Values1),
  sumlist(Values1, Sum),
  (   Value2 > 0
  ->  Percent is 100 * Sum / Value2,
      write(Name2), write('_percent'), tab(1), write(Percent), nl
  ;   write('error'), nl
  ).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluation_techf(File):-
  string_concat(File, '.tech.txt', File1), 
  tell(File1),
  evaluation_tech,
  told. 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluation_tech:-
  clear_eval_value('speaking_hit'),
  clear_eval_value('speaking_miss'),
  clear_eval_value('speaking_hit2'),
  clear_eval_value('speaking_miss2'),
  clear_eval_value('moving_hit'),
  clear_eval_value('moving_miss'),
  clear_eval_value('moving_hit2'),
  clear_eval_value('moving_miss2'),
  clear_eval_value('moving_hit3'),
  clear_eval_value('moving_miss3'),
  clear_eval_value('moving_hit4'),
  clear_eval_value('moving_miss4'),

  begin(B),
  end(E),
%  E is 100000,
%  E is 50000,
  step(S),
  ignore(evaluation_tech_step(B, E, S)),

  print_eval_value('speaking_hit'),
  print_eval_value('speaking_miss'),
  print_eval_perc('speaking_hit', 'speaking_miss'),
  print_eval_value('speaking_hit2'),
  print_eval_value('speaking_miss2'),
  print_eval_perc('speaking_hit2', 'speaking_miss2'),
  print_eval_value('moving_hit'),
  print_eval_value('moving_miss'),
  print_eval_perc('moving_hit', 'moving_miss'),
  print_eval_value('moving_hit2'),
  print_eval_value('moving_miss2'),
  print_eval_perc('moving_hit2', 'moving_miss2'),
  print_eval_value('moving_hit3'),
  print_eval_value('moving_miss3'),
  print_eval_perc('moving_hit3', 'moving_miss3'),
  print_eval_value('moving_hit4'),
  print_eval_value('moving_miss4'),
  print_eval_perc('moving_hit4', 'moving_miss4').

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluation_tech_step(Time, End, Step):-
  (  Time =< End 
  -> set_virtual_camera_time(Time),
     findall(_, evaluate_tech(Time), _),
     T is Time + Step,
     evaluation_tech_step(T, End, Step)
  ).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluation_person_visible(Time, Camera, Person):-
  camera(Camera, Left, Top, Width, Height, Parent, ID),

  PastWindow is 520,
  FutureWindow is 520,
  
  step(Step),
  head_positions(Time, Step, FutureWindow, Parent, Person, LF),
  head_positions(Time, -Step, PastWindow, Parent, Person, LP),

  append(LP, LF, LC),
  findall(X, member((X, _), LC), Xs),
  findall(Y, member((_, Y), LC), Ys),
  averlist(Xs, AverX),
  averlist(Ys, AverY),

%  write(AverX), nl,
%  write(AverY), nl,
%  write(LC), nl,
%  write(Left), nl,
%  write(Top), nl,
%  R is Left+Width,
%  write(R), nl,
%  B is Top+Height,
%  write(B), nl,

  AverX >= Left,
  AverY >= Top,
  AverX < (Left + Width),
  AverY < (Top + Height),

  ((is_moving_virtual_camera(Camera)) -> moving_virtual_camera_id(Person, ID); true).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluation_hand_moving(Time, Person, Camera, Weight):-
  PastWindow is 5000, 
  FutureWindow is 5000,

  camera(Camera, _, _, _, _, Parent, _),
  step(Step),

  hand_moves(Time, Step, FutureWindow, Parent, Person, LF),
  hand_moves(Time, -Step, PastWindow, Parent, Person, LP),
  
  sumlist(LF, SF),
  sumlist(LP, SP),
  
  Weight is (SF + SP) / (FutureWindow + PastWindow).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluation_head_moving(Time, Person, Camera, Weight):-
  PastWindow is 5000, 
  FutureWindow is 5000,

  camera(Camera, _, _, _, _, Parent, _),
  step(Step),

  head_moves(Time, Step, FutureWindow, Parent, Person, LF),
  head_moves(Time, -Step, PastWindow, Parent, Person, LP),
  
  sumlist(LF, SF),
  sumlist(LP, SP),
  
  Weight is (SF + SP) / (FutureWindow + PastWindow).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluation_moving(Time, Person, Weight):-
  bagof(Weight, 
	Camera^(camera(Camera), 
		not(is_virtual_camera(Camera)), 
		not(is_empty_camera(Camera)), 
		evaluation_head_moving(Time, Person, Camera, Weight1),
		evaluation_hand_moving(Time, Person, Camera, Weight2),
		Weight is max(Weight1, Weight2)
	       ), 
	Ws),
  maxlist(Ws, Weight),
  Weight > 0.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluation_max_moving(Time, Weights):-
  bagof((Weight, P),
	P^(person(P),
	   evaluation_moving(Time, P, Weight)),
	Ps),
  sort(Ps, SPs),
  reverse(SPs, Weights).
%,  write(Weights), nl.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluate_tech(Time):-
  forall(is_speaking(Time, Person),
	 (   (last_output(Time, Camera), evaluation_person_visible(Time, Camera, Person))
	 ->  inc_eval_value('speaking_hit')
	 ;   inc_eval_value('speaking_miss')
	 )
	).

evaluate_tech(Time):-
  bagof(P, is_speaking(Time, P), Ps),
  (   once((member(Person, Ps), last_output(Time, Camera), evaluation_person_visible(Time, Camera, Person)))  
  ->  inc_eval_value('speaking_hit2')
  ;   inc_eval_value('speaking_miss2')
  ).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluate_tech(Time):-
  evaluation_max_moving(Time, Weights),
  nth0(0, Weights, (_, Person)),
  last_output(Time, Camera),
  (   evaluation_person_visible(Time, Camera, Person)
  ->  inc_eval_value('moving_hit'), inc_eval_value('moving_hit2'), inc_eval_value('moving_hit3'), inc_eval_value('moving_hit4')
  ;   inc_eval_value('moving_miss'),
      (nth0(1, Weights, (_, Person2)), evaluation_person_visible(Time, Camera, Person2))
  ->  inc_eval_value('moving_hit2'), inc_eval_value('moving_hit3'), inc_eval_value('moving_hit4')
  ;   inc_eval_value('moving_miss2'),
      (nth0(2, Weights, (_, Person3)), evaluation_person_visible(Time, Camera, Person3))
  ->  inc_eval_value('moving_hit3'), inc_eval_value('moving_hit4')
  ;   inc_eval_value('moving_miss3'),
      (nth0(3, Weights, (_, Person4)), evaluation_person_visible(Time, Camera, Person4))
  ->  inc_eval_value('moving_hit4')
  ;   inc_eval_value('moving_miss4')
%, write(Time), nl
  ).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluation_estf(File):-
  string_concat(File, '.est.txt', File1), 
  tell(File1),
  evaluation_est,
  told. 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluation_est:-
  clear_eval_value('shot_count'),
  clear_eval_value('shot_short'),
  clear_eval_value('shot_long'),
  clear_eval_value('shot_vsp'),
  clear_eval_value('shot_vpr'),
  clear_eval_value('shot_move'),

  begin(B),
  end(E),
%  E is 100000,
%  E is 50000,
  step(S),
  ignore(evaluation_est_step(B, E, S)),
  print_eval_value('shot_count'),
  print_eval_value('shot_short'),
  print_eval_value('shot_long'),
  print_eval_value('shot_vsp'),
  print_eval_value('shot_vpr'),
  print_eval_value('shot_move'),
  print_eval_perc2(['shot_short', 'shot_long', 'shot_vsp', 'shot_vpr', 'shot_move'], 'shot_count').


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluation_est_step(Time, End, Step):-
  (  Time =< End 
  -> ignore((PredTime is Time - Step,
             last_output(Time, Camera),
	     last_output(PredTime, PredCamera),
	     Camera \== PredCamera,
	     inc_eval_value('shot_count'),
	     %write(Time), tab(1), tab(1), write(PredCamera), tab(1), write(Camera), nl,
	     %findall(_, evaluate_est(Time, PredCamera, Camera), _)
	     once(evaluate_est(Time, PredCamera, Camera))
	    )),
     
     T is Time + Step,
     evaluation_est_step(T, End, Step)
  ).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluate_est(Time, _, _):-
  step(Step),
  PredTime is Time - Step,
  last_output(PredTime, _, HowLong),
  (   HowLong =< 1000
  ->  inc_eval_value('shot_short')
  ).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluate_est(Time, _, _):-
  step(Step),
  PredTime is Time - Step,
  last_output(PredTime, _, HowLong),
  (   HowLong >= 30000
  ->  inc_eval_value('shot_long')
  ).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluate_est(_, PredCamera, Camera):-
  is_virtual_camera(PredCamera, PredParent),
  is_virtual_camera(Camera, Parent),
  (   PredParent == Parent
  ->  inc_eval_value('shot_vsp')
  ).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluate_est(Time, PredCamera, Camera):-
  is_virtual_camera(Camera, Parent),
  Parent \== PredCamera,

  step(Step),
  PredTime is Time - Step,
  (   pred_last_output(PredTime, PredCamera, PredPredCamera, _)
  ->  PredPredCamera \== Camera
  ;   true
  ),
  inc_eval_value('shot_vpr').

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluate_est(Time, PredCamera, Camera):-
  Camera == 3,

  step(Step),
  PredTime is Time - Step,
  pred_last_output(PredTime, PredCamera, PredPredCamera, _),
  PredPredCamera \== Camera,

  last_output(PredTime, _, HowLong),
  PTime is Time - HowLong,
  (   once((person(Person),
	    evaluation_person_visible(Time,  Camera, Person),
	    evaluation_person_visible(PTime, PredCamera, Person)  
	   ))
  ->  fail
  ;   true
  ),

  inc_eval_value('shot_move').
