%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Prce s kamerami
% cameras.pl
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% vytvoen sla virtuln kamery
virtual_camera_number(Parent, ID, Camera) :-
	Camera is Parent * 10000 + ID.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% uren identifiktoru pohybliv virtuln kamery
moving_virtual_camera_id(Person, ID) :-
	char_type(Person, xdigit(A)),
	ID is 200 + A - 10.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% jedn se o pohyblivou virtuln kameru
is_moving_virtual_camera_id(ID) :-
	X is ID mod 10000,
	X >= 200,
	X < 300.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% uren identifiktoru virtuln kamery pltna
silverscreen_virtual_camera_id(Number, ID) :-
	ID is 400 + Number.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% jedn se o pohyblivou virtuln kameru pltna
is_silverscreen_virtual_camera_id(ID) :-
	X is ID mod 10000,
	X >= 400,
	X < 500.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% jedn se o kameru pltna (zatm pouze virtuln)
is_silverscreen_camera(Camera) :-
	is_silverscreen_virtual_camera_id(Camera).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% zmna slajdu na kamee pltna
% pesunout do samostatnho modulu
slide_exchange(Time, Camera) :-
	is_silverscreen_camera(Camera),
	camera(Camera, _, _, _, _, Parent, _),
	slide(Time, Parent).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% jedn se o virtuln kameru
is_virtual_camera(Camera) :-
	is_virtual_camera(Camera, _).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% jedn se o virtuln kameru
is_virtual_camera(Camera, Parent) :-
	camera(Camera, _, _, _, _, Parent, _),
	Parent \== Camera.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% jedn se o pohyblivou virtuln kameru
is_moving_virtual_camera(Camera) :-
	camera(Camera, _, _, _, _, Parent, ID),
	Parent \== Camera,
	is_moving_virtual_camera_id(ID).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% jedn se o sumarizan (przdnou) kameru
is_empty_camera(Camera) :-
	Camera < 0.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% zjitn nadazen kamery
parent_camera(Camera, Parent) :-
	fixed_parent_camera(Camera, Parent) -> true;
	is_virtual_camera(Camera, Parent).   

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% dostupn kamery
camera(Camera, Left, Top, Width, Height, Parent, ID) :-
	(camera(Camera, Width, Height),
	 Left is 0,
	 Top is 0,
	 Parent = Camera,
	 ID is 1);
	(virtual_camera(Parent, ID, Zoom, CenterX, CenterY),
	 camera(Parent, ParentWidth, ParentHeight),
	 virtual_camera_number(Parent, ID, Camera),
	 Left is CenterX - (ParentWidth / 2) / Zoom,
	 Width is ParentWidth / Zoom,
	 Top is CenterY - (ParentHeight / 2) / Zoom,
	 Height is ParentHeight / Zoom
	);
	(Camera is -1,
	 Left is -1,
	 Top is -1,
	 Width is -1,
	 Height is -1,
	 Parent is -1,
	 ID is -1
	).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% dostupn kamery
camera(Camera, Left, Top, Width, Height) :-
	camera(Camera, Left, Top, Width, Height, _, _).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% dostupn kamery
camera(Camera) :-
	camera(Camera, _, _, _, _, _, _).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% inicializace virtualnch kamer
init_virtual_cameras :-
	retractall(virtual_camera(_, _, _, _, _)),
	assert(moving_virtual_camera(0, 0, 0, 0, 0, 0, 0, 0)),
	retractall(moving_virtual_camera(_, _, _, _, _, _, _, _)),
	retractall(perspective_virtual_camera(_, _, _, _, _, _, _, _, _, _)),
	retractall(head_full_positions_static(_, _, _, _, _, _)),
	
	
	ignore((rule_configuration(s_fixed_virtual_cameras, _, _, _, _, _)*->generate_fixed_virtual_cameras)),
	ignore(((test_mode([offline, half_realtime]), rule_configuration(s_moving_virtual_cameras, _, _, _, _, _, _, _, _, _, _))->generate_filtered_head_move,generate_moving_virtual_cameras)),
	
	ignore(((test_mode([offline, half_realtime]), rule_configuration(s_silverscreen_virtual_cameras, _)) -> generate_silverscreen_virtual_cameras)),
	set_virtual_camera_time(0).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% generovn pevnch virtualnch kamer
generate_fixed_virtual_cameras :-
	write_begin('generating fixed virtual cameras'),
	ignore(forall(rule_configuration(s_fixed_virtual_cameras, Parent, ID, Zoom, CenterX, CenterY),
		      assert(virtual_camera(Parent, ID, Zoom, CenterX, CenterY))
		     )
	      ),
	write_done.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% generovn virtulnch kamer pro pltno
% pro jednu kameru by mla bt definovna max. jedno pltno
% rozsirit napr. platno + tabule na jedne kamere!
generate_silverscreen_virtual_cameras :-
	write_begin('generating silverscreen virtual cameras'),
	ignore(init_silverscreen_virtual_cameras(0)),
	write_done.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
init_silverscreen_virtual_cameras(Time) :-
	rule_configuration(s_silverscreen_virtual_cameras, Ratio),
	forall(silverscreen(_, Parent, X1, Y1, X2, Y2, X3, Y3, X4, Y4),
	       (Number = 0,
		silverscreen_virtual_camera_id(Number, ID),
		retractall(virtual_camera(Parent, ID, _, _, _)),
		assert(virtual_camera(Parent, ID, 1, 0, 0)),
		virtual_camera_number(Parent, ID, Camera),
		retractall(perspective_virtual_camera(Camera, _, _, _, _, _, _, _, _, _)),
		assert(perspective_virtual_camera(Camera, X1, Y1, X2, Y2, X3, Y3, X4, Y4, Ratio))
	       )
	      ).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% filtrace pohybu osoby
% nunt pro vpoet pohyblivch kamer
generate_filtered_head_move :-
	rule_configuration(s_moving_virtual_cameras, Zoom, HorizontalOffset, VerticalOffset, HorizontalSize, VerticalSize, PastWindow, FutureWindow, TimeOffset, Threshold, Ratio),	
	write_begin('generating filtered head move'),
	retractall(head_full_positions_static(_, _, _, _, _, _)),
	ignore((  setof((Camera, Person), Time^head(Time, Camera, Person), CP),
		  forall(member((C, P), CP), (generate_head_full_positions(1, FutureWindow, C, P), generate_head_full_positions(-1, PastWindow, C, P)))
	       )),
	write_done.
	
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% generovn pohyblivch virtualnch kamer
generate_moving_virtual_cameras :-
	write_begin('generating moving virtual cameras'),
	begin(B),
	end(E),
	step(S),
	retractall(moving_virtual_camera(_, _, _, _, _, _, _, _)),
	ignore(generate_moving_virtual_cameras_step(B, E, S)),
	write_done.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
generate_moving_virtual_cameras_step(Time, End, Step) :-
	(   Time =< End
	->  init_moving_virtual_cameras(Time),
	    T is Time + Step,
	    generate_moving_virtual_cameras_step(T, End, Step)
	).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% uren pozice pohybliv virtuln kamery v danm okamiku
init_moving_virtual_cameras(Time) :-
  rule_configuration(s_moving_virtual_cameras, Zoom, HorizontalOffset, VerticalOffset, HorizontalSize, VerticalSize, PastWindow, FutureWindow, TimeOffset, Threshold, Ratio),
  
  HorizontalWeight is Ratio,
  VerticalWeight is 1,
  Weight is sqrt(HorizontalWeight^2 + VerticalWeight^2),
  
  %write(Weight), nl,
  
  step(Step),
  ignore(forall(person(Person),
		(forall((camera(Camera, Left, Top, Width, Height, Parent, _), Camera == Parent),
			(ignore((moving_virtual_camera_id(Person, ID),

				 (   test_mode([realtime]) 
				 ->  head_full_positions(Time, 1, FutureWindow, Parent, Person, LF),
				     head_full_positions(Time, -1, PastWindow, Parent, Person, LP),
				     append(LP, LF, LC),
				     %length(LC, L1),
				     %L1 > 0,
				     findall(X, member((X, _, _, _, _, _), LC), Xs),
				     findall(Y, member((_, _, _, Y, _, _), LC), Ys),
				     averlist(Xs, X1),
				     averlist(Ys, Y1)
				       

				 ;   (head_full_positions_static(Time, 1, FutureWindow, Parent, Person, PosF) -> LF = [PosF]; LF = []),
				     (head_full_positions_static(Time, -1, PastWindow, Parent, Person, PosL) -> LP = [PosL]; LP = []),
				     append(LP, LF, LC),
				     findall(X, member((X, _), LC), Xs),
				     findall(Y, member((_, Y), LC), Ys),
				     averlist(Xs, X1),
				     averlist(Ys, Y1)
				 ),
				 				 
				 VW is Width / Zoom / 2,
				 VH is Height / Zoom / 2,
				 YOffset is VH * (VerticalOffset),
				 

				 (   last_moving_virtual_camera(Time, Parent, ID, LZoom, LX, LY)
				 ->  (LY2 is LY - YOffset,
				     
				      Time2 is Time + TimeOffset,
				      (	  test_mode([realtime]) 
				      ->  head_full_positions(Time2, 1, FutureWindow, Parent, Person, LF2),
					  head_full_positions(Time2, -1, PastWindow, Parent, Person, LP2),
					  append(LP2, LF2, LC2),
					  length(LC2, L2),
					  L2 > 0,
					  findall(X, member((X, _, _, _, _, _), LC2), Xs2),
					  findall(Y, member((_, _, _, Y, _, _), LC2), Ys2),
					  averlist(Xs2, X2),
					  averlist(Ys2, Y2)
					  				 
				      ;	  (head_full_positions_static(Time2, 1, FutureWindow, Parent, Person, PosF2) -> LF2 = [PosF2]; LF2 = []),
					  (head_full_positions_static(Time2, -1, PastWindow, Parent, Person, PosL2) -> LP2 = [PosL2]; LP2 = []),
					  append(LP2, LF2, LC2),
					  findall(X, member((X, _), LC2), Xs2),
					  findall(Y, member((_, Y), LC2), Ys2),
					  averlist(Xs2, X2),
					  averlist(Ys2, Y2)
				      ),

				      AverX is LX + (X2 - LX) / (TimeOffset / Step),
				      AverY is LY2 + (Y2 - LY2) / (TimeOffset / Step),
				      
				      %((X2 - X1)^2 + (Y2 - Y1)^2) > ((Threshold * TimeOffset)^2),
				      
				      ((HorizontalWeight * (X2 - X1) / Width)^2 + (VerticalWeight * (Y2 - Y1) / Height)^2) > ((Weight * Threshold * TimeOffset)^2),

				      X is round(min(max(Left + VW, AverX), Left + Width - VW)),
				      Y is round(min(max(Top + VH, AverY + YOffset), Top + Height - VH)),

				      ((LX == X, LY == Y, LZoom == Zoom) -> fail; true),

				      retractall(moving_virtual_camera(Time, Parent, ID, _, _, _, _, _)),
				      asserta(moving_virtual_camera(Time, Parent, ID, Zoom, X, Y, HorizontalSize, VerticalSize))
				     )
				 ;   (AverX is X1,
				      AverY is Y1,
				      X is round(min(max(Left + VW, AverX), Left + Width - VW)),
				      Y is round(min(max(Top + VH, AverY + YOffset), Top + Height - VH)),
				      retractall(moving_virtual_camera(Time, Parent, ID, _, _, _, _, _)),
				      asserta(moving_virtual_camera(Time, Parent, ID, Zoom, X, Y, HorizontalSize, VerticalSize))
				     ))
				))
			)
		       )
		)
  )).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% pedchoz parametry virtuln kamery
last_moving_virtual_camera(Time, Parent, ID, Zoom, X, Y) :-
	last_moving_virtual_camera(Time, Parent, ID, Zoom, X, Y, _, _).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% pedchoz parametry virtuln kamery
last_moving_virtual_camera(Time, Parent, ID, Zoom, X, Y, HorizontalSize, VerticalSize) :-
	moving_virtual_camera(Time, Parent, ID, Zoom, X, Y, HorizontalSize, VerticalSize) -> true; 
	(once((moving_virtual_camera(T, Parent, ID, Zoom, X, Y, HorizontalSize, VerticalSize), T =< Time))).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% aktualizace pohyblivch virtualnch kamer
set_virtual_camera_timeX(Time) :-
	ignore(forall((virtual_camera(Parent, ID, Zoom, X, Y), is_moving_virtual_camera_id(ID)),
		      (   retractall(virtual_camera(Parent, ID, Zoom, X, Y)),
			  retractall(virtual_camera_size(Parent, ID, _, _)))
		     )
	      ),
	ignore(forall((camera(Camera, _, _, _, _, Parent, _),
		       Parent == Camera,
		       once(moving_virtual_camera(_, Camera, _, _, _, _, _, _))
		      ), 
		      (forall(person(Person), 
			      ((   moving_virtual_camera_id(Person, ID), last_moving_virtual_camera(Time, Camera, ID, Zoom, X, Y, HorizontalSize, VerticalSize)
			       ->  (
				   assert(virtual_camera(Camera, ID, Zoom, X, Y)),
				    assert(virtual_camera_size(Camera, ID, HorizontalSize, VerticalSize))
				   )
			       ;   true
			       )
			      ))
		      ))
	      ).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% aktualizace pohyblivch virtualnch kamer 
% mus bt volno sekvenn
set_virtual_camera_time(Time) :-
	(begin(Time) ->   
	ignore(forall((virtual_camera(Parent, ID, Zoom, X, Y), is_moving_virtual_camera_id(ID)),
		      (   retractall(virtual_camera(Parent, ID, Zoom, X, Y)),
			  retractall(virtual_camera_size(Parent, ID, _, _)))
		     )
	      ); true)
	,
	ignore(forall((camera(Camera, _, _, _, _, Parent, _),
		       Parent == Camera
		      %,once(moving_virtual_camera(_, Camera, _, _, _, _, _, _))
		      ), 
		      
		      %true)).
	
		(forall(person(Person), 
			((   moving_virtual_camera_id(Person, ID), moving_virtual_camera(Time, Camera, ID, Zoom, X, Y, HorizontalSize, VerticalSize)
			 ->  (
			     
			     retractall(virtual_camera(Parent, ID, _, _, _)),
			      retractall(virtual_camera_size(Parent, ID, _, _)),
			      
			      assert(virtual_camera(Camera, ID, Zoom, X, Y)),
			      assert(virtual_camera_size(Camera, ID, HorizontalSize, VerticalSize))
			     )
			 ;   true
			 )
			))
		))
		).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% uren viditelnosti osoby na dan kamee
future_past_person_visible(Time, Person, Camera, Percent) :-
  camera(Camera, Left, Top, Width, Height, Parent, ID),
  rule_configuration(s_person_visible_window, PastWindow, FutureWindow),

  step(Step),
  head_positions(Time, Step, FutureWindow, Parent, Person, LF),
  head_positions(Time, -Step, PastWindow, Parent, Person, LP),

  append(LP, LF, LC),
  findall(X, member((X, _), LC), Xs),
  findall(Y, member((_, Y), LC), Ys),
  averlist(Xs, AverX),
  averlist(Ys, AverY),

  AverX >= Left,
  AverY >= Top,
  AverX < (Left + Width),
  AverY < (Top + Height),

  (   is_moving_virtual_camera(Camera)
  ->  moving_virtual_camera_id(Person, ID)
  ;   true
  ),

  PercentX is (1 - abs((Left + Width / 2) - AverX) / (Width / 2)),
  (   Parent = 3
  ->  PercentY is 1 - min(((AverY * 0.5 - Top) / Height), 1)
  ;   PercentY is 1 - min(((AverY * 1 - Top) / Height), 1)
  ),

  PercentA is (PercentX + PercentY) / 2,
  Percent is min(PercentA, 1).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% uren pozice osoby na dan kamee
future_past_person_position(Time, Person, Camera, AverX, AverY) :-
  camera(Camera, Left, Top, Width, Height, Parent, ID),
  Camera == Parent,
  rule_configuration(s_person_visible_window, PastWindow, FutureWindow),

  step(Step),
  head_positions(Time, Step, FutureWindow, Parent, Person, LF),
  head_positions(Time, -Step, PastWindow, Parent, Person, LP),

  append(LP, LF, LC),
  findall(X, member((X, _), LC), Xs),
  findall(Y, member((_, Y), LC), Ys),
  averlist(Xs, AverX),
  averlist(Ys, AverY),

  AverX >= Left,
  AverY >= Top,
  AverX < (Left + Width),
  AverY < (Top + Height).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% virtual_camera(Parent, ID, Zoom, CenterX, CenterY)
% ID = 100 - 199 - fixed virtual cameras
% ID = 200 - 299 - moving virtual cameras
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
export_virtual_camera_rectangles(Time):-
  forall((camera(Camera, Left, Top, Width, Height, Parent, _),
	  Parent \== Camera,
	  Camera == 20202
	 ),
	 (MaxX is Left + Width,
	  MaxY is Top + Height,
	  export('virtual_camera', Time, [('camera', Parent), ('object', Camera), ('minx', Left), ('miny', Top), ('maxx', MaxX), ('maxy', MaxY)])
	 )
	).

export_virtual_camera_rectangles_step(Time, End, Step):-
  Time =< End -> (set_virtual_camera_time(Time),
		  ignore(export_virtual_camera_rectangles(Time)),
		  T is Time + Step,
		  export_virtual_camera_rectangles_step(T, End, Step)).

export_virtual_camera_rectangles:-
  begin(B),
  end(E),
  step(S),
  (export_virtual_camera_rectangles_step(B, E, S); true).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
on_camera0(Time, Person, Camera, HowLong):-
	event_head_enter_camera(T, Camera, Person),
	T =< Time,
	not(later_event_head_leave_camera(T, Time, Camera, Person)),
	HowLong is Time - T.

sooner_on_camera0(Time, Person, Camera, HowLong):-
	on_camera0(Time, Person, Camera, HowLongSooner),
	HowLongSooner > HowLong.

% on which camera and how long is person (the longest time)
%
on_camera(Time, Person, Camera, HowLong):-
	on_camera0(Time, Person, Camera, HowLong),
	not(sooner_on_camera0(Time, Person, Camera, HowLong)).

on_camera(Time, Person, Camera):-
	on_camera(Time, Person, Camera, _).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% how is person visible on selected camera
%
%person_visible(Time, Person, Camera, Percent):-
%	(event_head(Time, Camera, Person, CenterX, CenterY) -> true;
%	 (event_head(T, Camera, Person, CenterX, CenterY),
%	  T =< Time,
%	  not(later_event_head(T, Time, Camera, Person)),
%	  not(later_event_head_leave_camera(T, Time, Camera, Person))
%	 )
%	),
%	camera(Camera, CameraWidth, CameraHeight),
%	CameraX is CameraWidth / 2,
%	CameraY is CameraHeight / 2,
%	Percent is max((CameraX - abs(CameraX - CenterX)) / CameraX,
%	(CameraY - abs(CameraY - CenterY)) / CameraY).
%	%	Percent is (0.5 * ((CameraX - abs(CameraX - CenterX)) / CameraX)) + (0.5 * ((CameraY - abs(CameraY - CenterY)) / CameraY)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% how is person visible on selected camera
%
past_person_visible(Time, Person, CameraID, Percent):-
  fail,
  camera(CameraID, Left, Top, Width, Height, Parent, _),
  ((Parent < 0) -> Camera is CameraID; Camera is Parent),

  past_person_visible_window(Window),
  head_positions(Time, 1, Window, Camera, Person, LC),


  findall(X, member((X, _), LC), Xs),

  findall(Y, member((_, Y), LC), Ys),
%  write(Xs), nl, write(Ys), nl,

  list_aver(Xs, AverX),
  list_aver(Ys, AverY),

%  write(AverX), nl, write(AverY), nl, write(Left), nl, write(Top), nl, write(Width), nl, write(Height), nl,

  AverX >= Left,
  AverY >= Top,
  AverX < (Left + Width),
  AverY < (Top + Height),

  PercentX is (1 - abs((Left + Width / 2) - AverX) / (Width / 2)),
  PercentY is 1 - ((AverY - Top) / Height),
  Percent is (PercentX + PercentY) / 2.

future_person_visible(Time, Person, CameraID, Percent):-
  fail,
  camera(CameraID, Left, Top, Width, Height, Parent, _),
  ((Parent < 0) -> Camera is CameraID; Camera is Parent),

  future_person_visible_window(Window),
  head_positions(Time, 1, Window, Camera, Person, LC),


  findall(X, member((X, _), LC), Xs),

  findall(Y, member((_, Y), LC), Ys),
%  write(Xs), nl, write(Ys), nl,

  list_aver(Xs, AverX),
  list_aver(Ys, AverY),

%  write(AverX), nl, write(AverY), nl, write(Left), nl, write(Top), nl, write(Width), nl, write(Height), nl,

  AverX >= Left,
  AverY >= Top,
  AverX < (Left + Width),
  AverY < (Top + Height),

  PercentX is (1 - abs((Left + Width / 2) - AverX) / (Width / 2)),
  PercentY is 1 - ((AverY - Top) / Height),
  Percent is (PercentX + PercentY) / 2.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%person_visible(Time, Person, Camera, Percent):-
%  fixed_visible(Person, Camera, P1) -> 
%  ((Camera \== 3, person_movement(Time, Person, State), member(State, [stand_whiteboard, stand_screen, move])) -> Percent is 0;
%  Percent is P1
%  );
%  future_past_person_visible(Time, Person, Camera, Percent).

person_visible(Time, Person, Camera, Percent):-
  fixed_visible(Person, Camera, P1) -> 
  ((person_movement(Time, Person, State), 
    fixed_visibility_regarding_state(Camera, Persons, States, M), 
    member(Person, Persons),
    member(State, States)) -> Percent is min(max(P1 * M, 0), 1);
  Percent is P1
  );
  future_past_person_visible(Time, Person, Camera, Percent).
  
