//---------------------------------------------------------------------------
#ifndef UnitMainH
#define UnitMainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <ComCtrls.hpp>
#include <Dialogs.hpp>
#include <Menus.hpp>
#include <AppEvnts.hpp>
#include <vector>
#include <time.h>
#include "DSTools.h"

//---------------------------------------------------------------------------
class TAVSource {
public:
  int Type;
  int VideoFormat;
  AnsiString File;
  bool VideoPreview, AudioPreview;
  std::vector<TFrame*> PreviewFrames;
  std::vector<AnsiString> AudioChannels;
  std::vector<AnsiString> VideoChannels;
  TIBaseFilters VideoPreviewFilters, VideoPreviewFilters2, AudioPreviewFilters;

	IBaseFilter *pCap;
  IBaseFilter *pDVSplit;
  IBaseFilter *pInfTee;
  IBaseFilter *pInfTeeAudio;
  IBaseFilter *pAVIMux;
  IBaseFilter *pFileWriter;
  IBaseFilter *pDVDecoder;
  IBaseFilter *pVideoRenderer;
  IBaseFilter *pScope;
  IBaseFilter *pAudioRenderer;
  IBaseFilter *pDVDecoder2;
  IBaseFilter *pVideoRenderer2;

  IBaseFilter *pMPEG2TSDemux;
  IBaseFilter *pMPEG2TSDemux2;
  IBaseFilter *pMPEG2TSDemux3;

  IBaseFilter *pMPEG2TSOutputDemux;

  IBaseFilter *pWAVEDst;
  IBaseFilter *pSampleGrabber;
  IBaseFilter *pNullRenderer;

  void Init() {
    pCap = NULL;
    pDVSplit = NULL;
    pInfTee = NULL;
    pInfTeeAudio = NULL;
    pAVIMux = NULL;
    pFileWriter = NULL;
    pDVDecoder = NULL;
    pVideoRenderer = NULL;
    pScope = NULL;
    pAudioRenderer = NULL;
    pDVDecoder2 = NULL;
    pVideoRenderer2 = NULL;

    pMPEG2TSDemux = NULL;
    pMPEG2TSDemux2 = NULL;
    pMPEG2TSDemux3 = NULL;

    pWAVEDst = NULL;
  	pSampleGrabber = NULL;
  	pNullRenderer = NULL;

    pMPEG2TSOutputDemux = NULL;
  };

  void Release(IGraphBuilder *pGraph) {
    SAFE_REMOVE(pGraph, pCap);
    SAFE_REMOVE(pGraph, pDVSplit);
    SAFE_REMOVE(pGraph, pInfTee);
    SAFE_REMOVE(pGraph, pInfTeeAudio);
    SAFE_REMOVE(pGraph, pAVIMux);
    SAFE_REMOVE(pGraph, pFileWriter);
    SAFE_REMOVE(pGraph, pDVDecoder);
    SAFE_REMOVE(pGraph, pVideoRenderer);
    SAFE_REMOVE(pGraph, pScope);
    SAFE_REMOVE(pGraph, pAudioRenderer);
    SAFE_REMOVE(pGraph, pDVDecoder2);
    SAFE_REMOVE(pGraph, pVideoRenderer2);

    SAFE_REMOVE(pGraph, pMPEG2TSDemux);
    SAFE_REMOVE(pGraph, pMPEG2TSDemux2);
    SAFE_REMOVE(pGraph, pMPEG2TSDemux3);

    SAFE_REMOVE(pGraph, pWAVEDst);
  	SAFE_REMOVE(pGraph, pSampleGrabber);
  	SAFE_REMOVE(pGraph, pNullRenderer);

    SAFE_REMOVE(pGraph, pMPEG2TSOutputDemux);
  }
};

//---------------------------------------------------------------------------
class TFormMain : public TForm
{
__published:	// IDE-managed Components
	TButton *ButtonAdd;
	TButton *ButtonRemove;
  TButton *ButtonRecord;
  TLabel *Label2;
  TEdit *EditDirectoryName;
  TButton *ButtonFileName;
  TListView *ListViewSources;
  TSaveDialog *SaveDialog;
  TButton *ButtonProperties;
  TMainMenu *MainMenu1;
  TMenuItem *FileSave;
  TMenuItem *Open1;
  TMenuItem *Save1;
  TSaveDialog *SaveDialog1;
  TOpenDialog *OpenDialog1;
  TTimer *TimerAudioPreview;
  TCheckBox *CheckBoxPreview;
  TLabel *Label10;
  TEdit *EditFileName;
  TCheckBox *CheckBoxDateTime;
  TMenuItem *Help1;
  TMenuItem *About1;
	TTimer *TimerRecord;
	TPageControl *PageControl;
	TTabSheet *TabSheet1;
	TTabSheet *TabSheet2;
	TLabel *Label1;
	TLabel *Label3;
	TLabel *Label4;
	TLabel *Label5;
	TLabel *Label6;
	TLabel *Label7;
	TLabel *LabelVolume;
	TLabel *LabelBalance;
	TComboBox *ComboBoxChannels;
	TComboBox *ComboBoxBits;
	TComboBox *ComboBoxRate;
	TCheckBox *CheckBoxAudioPreview;
	TButton *ButtonRate;
	TComboBox *ComboBoxInput;
	TTrackBar *TrackBarVolume;
	TTrackBar *TrackBarBalance;
	TCheckBox *CheckBoxVideoPreview;
	TLabel *Label8;
	TComboBox *ComboBoxWidth;
	TLabel *Label9;
	TComboBox *ComboBoxHeight;
	TMenuItem *N1;
	TMenuItem *Exit1;
	TButton *Button1;
	TTimer *TimerHack;
	TLabel *Label11;
	TRadioButton *RadioButtonVFAVI;
	TRadioButton *RadioButtonVFMPEG2TS;
	TRadioButton *RadioButtonVFMPEG2PS;
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall ButtonAddClick(TObject *Sender);
	void __fastcall ButtonRecordClick(TObject *Sender);
  void __fastcall ListViewSourcesDeletion(TObject *Sender,
          TListItem *Item);
  void __fastcall ListViewSourcesSelectItem(TObject *Sender,
          TListItem *Item, bool Selected);
  void __fastcall FormShow(TObject *Sender);
  void __fastcall ButtonFileNameClick(TObject *Sender);
  void __fastcall CheckBoxVideoPreviewClick(TObject *Sender);
  void __fastcall ButtonPropertiesClick(TObject *Sender);
  void __fastcall ButtonRemoveClick(TObject *Sender);
  void __fastcall Save1Click(TObject *Sender);
  void __fastcall Open1Click(TObject *Sender);
  void __fastcall CheckBoxAudioPreviewClick(TObject *Sender);
  void __fastcall ComboBoxAudioChange(TObject *Sender);
  void __fastcall ButtonRateClick(TObject *Sender);
  void __fastcall ComboBoxInputChange(TObject *Sender);
  void __fastcall TrackBarVolumeChange(TObject *Sender);
  void __fastcall CheckBoxPreviewClick(TObject *Sender);
  void __fastcall TimerAudioPreviewTimer(TObject *Sender);
  void __fastcall EditFileNameChange(TObject *Sender);

  void __fastcall EditPopisChange(TObject *Sender);
  void __fastcall About1Click(TObject *Sender);
	void __fastcall TimerRecordTimer(TObject *Sender);
	void __fastcall Exit1Click(TObject *Sender);
	void __fastcall Button1Click(TObject *Sender);
	void __fastcall TimerHackTimer(TObject *Sender);
	void __fastcall RadioButtonVFAVIClick(TObject *Sender);
private:	// User declarations
  DWORD g_dwGraphRegister;
  IGraphBuilder *pGraph;
  ICaptureGraphBuilder2 *pBuild;
  IMediaControl *pMC;
  IMediaSeeking *pMS;

  bool ChangeAudio, ChangeVideo, ChangeFileName;
  __int64 StartDiskFree;
  clock_t StartTime;

  bool AddVideoSource(AnsiString Name);
  bool AddAudioSource(AnsiString Name);

  void AddFilterToGraph(REFCLSID rclsid, IBaseFilter **ppv, const char *Name);
  bool ConnectF2F(const GUID *pType, IBaseFilter *fin, IBaseFilter *fout, bool ShowError = true);
  bool SetFileName(IBaseFilter *f, const char *Name);
  void RemoveOutputFilters();

  void StartPreview();
  void RunStopGraph();

  void SelectComboBoxItem(TComboBox *ComboBox, AnsiString Value);
  void LoadINI(AnsiString FileName);
  void SaveINI(AnsiString FileName);

  AnsiString ExchangeExt(AnsiString FileName, AnsiString Ext);
  AnsiString GetIndexName(AnsiString Name);

  void __fastcall NewWndProc(Messages::TMessage &Message);
public:		// User declarations
	bool ChangePos;
	__fastcall TFormMain(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TFormMain *FormMain;
//---------------------------------------------------------------------------
#endif
