//---------------------------------------------------------------------------
#ifndef DSToolsH
#define DSToolsH
//---------------------------------------------------------------------------
#include <vcl.h>
#include <vector>
//---------------------------------------------------------------------------
#define SAFE_RELEASE(x) { if (x) x->Release(); x = NULL; }
#define SAFE_REMOVE(y, x) { if (x) { y->RemoveFilter(x); x->Release(); x = NULL; } }

typedef std::vector<IBaseFilter*> TIBaseFilters;
typedef std::vector<IPin*> Pins;

HRESULT InitCaptureGraphBuilder(IGraphBuilder **ppGraph, ICaptureGraphBuilder2 **ppBuild, IMediaControl **ppMC);
HRESULT AddGraphToRot(IUnknown *pUnkGraph, DWORD *pdwRegister);
void RemoveGraphFromRot(DWORD pdwRegister);

TIBaseFilters GetFilters(IGraphBuilder *pGraph);
TIBaseFilters GetNewFilters(IGraphBuilder *pGraph, TIBaseFilters OldFilters);

void ReleaseFilters(TIBaseFilters &Filters);
void RemoveFilters(IGraphBuilder *pGraph, TIBaseFilters &Filters);

void GetPinParams(IPin *p, double &level, double &pan, bool &enabled);
void SetPinParams(IPin *p, double level, double pan, bool enabled);

Pins GetPins(IBaseFilter *f, PIN_DIRECTION dir);
void ReleasePins(Pins &pins);
int FindSelectedPin(Pins &pins);
int FindPin(Pins &pins, AnsiString name);
AnsiString GetPinName(IPin *p);

void SetAudioParams(ICaptureGraphBuilder2 *pBuild, IBaseFilter *f, int rate, int bits, int chn);
void GetAudioParams(ICaptureGraphBuilder2 *pBuild, IBaseFilter *f, int &rate, int &bits, int &chn, AUDIO_STREAM_CONFIG_CAPS &scc);
void GetAudioParams(ICaptureGraphBuilder2 *pBuild, IBaseFilter *f, int &rate, int &bits, int &chn);

void SetVideoParams(ICaptureGraphBuilder2 *pBuild, IBaseFilter *f, int width, int height, int frames);
void GetVideoParams(ICaptureGraphBuilder2 *pBuild, IBaseFilter *f, int &width, int &height, int &frames, VIDEO_STREAM_CONFIG_CAPS &scc);

void ShowFilterProperties(HWND Handle, IBaseFilter *pFilter);

int Round(double v);
#endif

