//---------------------------------------------------------------------------
#include <iostream>
#include <deque>
#include <time.h>
#pragma hdrstop
#include "Progress.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
static int LastProgressPos = -1;
static clock_t LastProgressTime = -1;

//---------------------------------------------------------------------------
typedef struct
{
	int Pos;
	clock_t Time;
}
TPosTime;
static std::deque<TPosTime> PosTimeQueue;

//---------------------------------------------------------------------------
void Progress(int Pos, int Max)
{
	TPosTime pt;
	pt.Pos = Pos;
	pt.Time = clock();
	PosTimeQueue.push_back(pt);

	float Speed = 0;
	if (PosTimeQueue.size() > 10)
	{
		if (PosTimeQueue.back().Pos > PosTimeQueue.front().Pos)
		{
			Speed = (1000.0 * float(PosTimeQueue.back().Time - PosTimeQueue.front().Time) / CLK_TCK) / float(PosTimeQueue.back().Pos - PosTimeQueue.front().Pos);
		}
		PosTimeQueue.pop_front();
	}

	int PorgressPos = (Pos * 100) / Max;
	std::cout << "\r" << Pos << "/" << Max << "ms " << PorgressPos << "% " << Speed << "          " << std::endl;
}

