//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <string.h>
#pragma hdrstop
#include "FSTools.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
int ExtractFilePathLength(const char *FileName)
{
	int Index = strlen(FileName);
	while (Index > 0)
	{
		if (FileName[Index - 1] == PATH_DELIMINER)
		{
			break;
		}
		else
		{
			Index--;
		}
	}
	return Index;
}

//---------------------------------------------------------------------------
int ExtractFilePathLength(const std::string FileName)
{
	return ExtractFilePathLength(FileName.c_str());
}

//---------------------------------------------------------------------------
std::string ExtractFilePath(const std::string FileName)
{
	return FileName.substr(0, ExtractFilePathLength(FileName));
}

//---------------------------------------------------------------------------
std::string NormalizeFilePath(const std::string FileName)
{
	std::string Normalized;
	for (unsigned int i = 0; i < FileName.size(); i++)
	{
		if (FileName[i] == WIN32_PATH_DELIMINER || FileName[i] == POSIX_PATH_DELIMINER)
		{
			Normalized += PATH_DELIMINER;
		}
		else
		{
			Normalized += FileName[i];
		}
	}
	return Normalized;
}

//---------------------------------------------------------------------------
std::string NormalizeFilePathProlog(const std::string FileName)
{
	std::string Normalized;
	for (unsigned int i = 0; i < FileName.size(); i++)
	{
		if (FileName[i] == WIN32_PATH_DELIMINER || FileName[i] == POSIX_PATH_DELIMINER)
		{
			Normalized += POSIX_PATH_DELIMINER;
		}
		else
		{
			Normalized += FileName[i];
		}
	}
	return Normalized;
}

