//---------------------------------------------------------------------------
//	Event editor
//	2002 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//	Brno University of Technology
//	Faculty of Information Technology
//
//	Events.h
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#ifndef EventsH
#define EventsH

//---------------------------------------------------------------------------
#include <vector>

#ifdef __BORLANDC__
//---------------------------------------------------------------------------
#include <Classes.hpp>
#else
#include <string>
//---------------------------------------------------------------------------
// Emulace trid a funkci z VCL pro ostatni prekladace

//---------------------------------------------------------------------------
class AnsiString: public std::string
{
public:
	AnsiString();
	AnsiString(const char* src);
	AnsiString(const AnsiString& src);
	AnsiString(const std::string& src);
	AnsiString(char src);

	char& operator [](const int idx);
	int Length();
	void size();
};

//---------------------------------------------------------------------------
bool AnsiSameText(const AnsiString S1, const AnsiString S2);
bool AnsiStartsText(const AnsiString S1, const AnsiString S2);

int StrToInt(const AnsiString Value);
int StrToIntDef(const AnsiString Value, const int Default);

float StrToFloat(AnsiString Value);

AnsiString IntToStr(int Value);
int TextToShortCut(AnsiString Text);
AnsiString ShortCutToText(int ShortCut);
AnsiString Trim(AnsiString S);
#endif

//---------------------------------------------------------------------------
extern const AnsiString DefaultGroupMeaning;
//---------------------------------------------------------------------------

#ifdef USING_NAMESPACE_EE
namespace ee {
#define NAMESPACE_EE_ID ee
#else
#define NAMESPACE_EE_ID
#endif

//---------------------------------------------------------------------------
class TParameter
{
public:
	AnsiString Name, Value;

	TParameter() {};
	TParameter(AnsiString _Name, AnsiString _Value): Name(_Name), Value(_Value) {};
};
typedef std::vector<TParameter> TParameters;
typedef AnsiString TParameterName;
typedef std::vector<TParameterName> TParameterNames;

//---------------------------------------------------------------------------
bool Compare(TParameters &p1, TParameters &p2, TParameterNames *Ignore = NULL);
bool GetParameterInt(TParameters &Parameters, char *Name, int &Value, char *Prefix = NULL);
bool GetParameterFloat(TParameters &Parameters, char *Name, float &Value, char *Prefix = NULL);
bool GetParameterHex(TParameters &Parameters, char *Name, int &Value, char *Prefix = NULL);
bool GetParameterString(TParameters &Parameters, char *Name, AnsiString &Value, char *Prefix = NULL);
TParameter* GetParameter(TParameters &Parameters, char *Name, char *Prefix);
AnsiString GetParameterString(TParameters &Parameters, char *Name, char *Default = NULL, char *Prefix = NULL);
AnsiString Parameters2String(const TParameters &Parameters);

//---------------------------------------------------------------------------
#ifdef __BORLANDC__
void Strings2Parameters(TStrings *Strings, TParameters &Parameters);
void Parameters2Strings(TParameters &Parameters, TStrings *Strings);
#endif

//---------------------------------------------------------------------------
class TEventTypeGroup
{
public:
	AnsiString Desc, Meaning;
	bool Enabled;
	TEventTypeGroup(): Enabled(true) {};
	TEventTypeGroup(AnsiString _Desc, AnsiString _Meaning): Desc(_Desc), Meaning(_Meaning), Enabled(true) {};
	TEventTypeGroup(AnsiString _Desc, AnsiString _Meaning, bool _Enabled): Desc(_Desc), Meaning(_Meaning), Enabled(_Enabled) {};
};
typedef std::vector<TEventTypeGroup> TEventTypeGroups;

//---------------------------------------------------------------------------
class TSecondaryKey
{
public:
	int Key, Offset;
	TParameters Parameters;
	TSecondaryKey(int _Key): Key(_Key), Offset(0) {};
	TSecondaryKey(int _Key, int _Offset, TParameters _Parameters): Key(_Key), Offset(_Offset), Parameters(_Parameters) {};
};
typedef std::vector<TSecondaryKey> TSecondaryKeys;

//---------------------------------------------------------------------------
class TEventType
{
public:
	AnsiString Desc;
	int Key, Group, GroupIndex, Offset;
	TParameters Parameters;
	TSecondaryKeys SecondaryKeys;
	bool CheckEndPoints;
//	TEventType(): Desc(""), Key(0), Group(-1), GroupIndex(-1), Offset(0) {};
	TEventType(AnsiString _Desc): Desc(_Desc), Key(0), Group(-1), GroupIndex(-1), Offset(0), CheckEndPoints(false) {};
//	TEventType(AnsiString _Desc, int _Key): Desc(_Desc), Key(_Key), Group(-1), GroupIndex(-1) {};
	TEventType(AnsiString _Desc, int _Key, int _Group, int _GroupIndex, int _Offset, TParameters _Parameters, TSecondaryKeys _SecondaryKeys): Desc(_Desc), Key(_Key), Group(_Group), GroupIndex(_GroupIndex), Offset(_Offset), Parameters(_Parameters), SecondaryKeys(_SecondaryKeys), CheckEndPoints(false) {};
	TEventType(AnsiString _Desc, int _Key, int _Group, int _GroupIndex, int _Offset, TParameters _Parameters, TSecondaryKeys _SecondaryKeys, bool _CheckEndPoints): Desc(_Desc), Key(_Key), Group(_Group), GroupIndex(_GroupIndex), Offset(_Offset), Parameters(_Parameters), SecondaryKeys(_SecondaryKeys), CheckEndPoints(_CheckEndPoints) {};
};
typedef std::vector<TEventType> TEventTypes;

//---------------------------------------------------------------------------
class LessEventTypeGroup
{
public:
	bool operator()(TEventType t1, TEventType t2)
	{
		return t1.Group < t2.Group;
	}
};

//---------------------------------------------------------------------------
class LessEventTypeGroupIndex
{
public:
	bool operator()(TEventType t1, TEventType t2)
	{
		return t1.GroupIndex < t2.GroupIndex;
	}
};

//---------------------------------------------------------------------------
class LessEventTypeGroupIterator
{
public:
	bool operator()(TEventTypes::iterator t1, TEventTypes::iterator t2)
	{
		return t1->Group < t2->Group;
	}
};

//---------------------------------------------------------------------------
class LessEventTypeGroupIndexIterator
{
public:
	bool operator()(TEventTypes::iterator t1, TEventTypes::iterator t2)
	{
		return t1->GroupIndex < t2->GroupIndex;
	}
};

//---------------------------------------------------------------------------
class TEvent
{
public:
	int ID;
	int Time;
	AnsiString Text;
	TParameters Parameters;

	TEvent(): ID(0), Time(0) {};
	TEvent(int _ID, int _Time): ID(_ID), Time(_Time) {};
	TEvent(int _ID, int _Time, AnsiString _Text, TParameters _Parameters): ID(_ID), Time(_Time), Text(_Text), Parameters(_Parameters) {};
};
typedef std::vector<TEvent*> TEvents;

//---------------------------------------------------------------------------
class LessEventTime
{
public:
	bool operator()(TEvent *e1, TEvent *e2)
	{
		return e1->Time < e2->Time;
	}
};

#ifdef USING_NAMESPACE_EE
}
#endif

//---------------------------------------------------------------------------
bool operator==(const NAMESPACE_EE_ID::TParameters &p1, const NAMESPACE_EE_ID::TParameters &p2);
bool operator!=(const NAMESPACE_EE_ID::TParameters &p1, const NAMESPACE_EE_ID::TParameters &p2);
bool operator<(const NAMESPACE_EE_ID::TParameters &p1, const NAMESPACE_EE_ID::TParameters &p2);
bool operator==(const NAMESPACE_EE_ID::TEvent &e1, const NAMESPACE_EE_ID::TEvent &e2);

//---------------------------------------------------------------------------
#ifdef EVENTEDITOR
TStrings* operator<<(TStrings *s, NAMESPACE_EE_ID::TEvent &e);
#endif

#endif

