//---------------------------------------------------------------------------
//	Event editor
//	2002 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//	Brno University of Technology
//	Faculty of Information Technology
//
//	Events.cpp
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <iostream>
#pragma hdrstop
#include "Events.h"
#include "Error.h"

#ifdef EVENTEDITOR
#include "UnitEventList.h"
#endif

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
const AnsiString DefaultGroupMeaning = "State";
//---------------------------------------------------------------------------

#ifndef __BORLANDC__
//---------------------------------------------------------------------------
AnsiString::AnsiString()
{
}

//---------------------------------------------------------------------------
AnsiString::AnsiString(const char* src): std::string(src)
{
}

//---------------------------------------------------------------------------
AnsiString::AnsiString(const AnsiString& src): std::string(src.c_str())
{
}

//---------------------------------------------------------------------------
AnsiString::AnsiString(const std::string& src): std::string(src)
{
}

//---------------------------------------------------------------------------
AnsiString::AnsiString(char src)
{
	*((std::string*)this) = src;
}

//---------------------------------------------------------------------------
char& AnsiString::operator [](const int idx)
{
	return std::string::operator [](idx - 1);
}

//---------------------------------------------------------------------------
int AnsiString::Length()
{
	return std::string::size();
}

//---------------------------------------------------------------------------
bool AnsiSameText(const AnsiString S1, const AnsiString S2)
{
	return !strcasecmp(S1.c_str(), S2.c_str());
}

//---------------------------------------------------------------------------
bool AnsiStartsText(const AnsiString S1, const AnsiString S2)
{
	return !strncasecmp(S1.c_str(), S2.c_str(), strlen(S1.c_str()));
}

//---------------------------------------------------------------------------
int StrToInt(const AnsiString Value)
{
	return atoi(Value.c_str());
}

//---------------------------------------------------------------------------
float StrToFloat(AnsiString Value)
{
	float TMP;
	for (int i = 1; i <= Value.Length(); i++)
	{
		if (Value[i] == ',')
		{
			Value[i] = '.';
		}
		if (sscanf(Value.c_str(), "%f", &TMP) == 1)
		{
			return TMP;
		}
		else
		{
			throw TError("Invalid float number!");
		}
	}
}

//---------------------------------------------------------------------------
int StrToIntDef(const AnsiString Value, const int Default)
{
	try
	{
		return StrToInt(Value);
	}
	catch (...)
	{
		return Default;
	}
}

//---------------------------------------------------------------------------
AnsiString IntToStr(int Value)
{
	AnsiString Text;
	int i = abs(Value);
	do
	{
		Text = char((i % 10) + '0') + Text;
		i = i / 10;
	}
	while (i != 0);

	if (Value < 0)
	{
		Text = "-" + Text;
	}
	return Text;
}

//---------------------------------------------------------------------------
int TextToShortCut(AnsiString Text)
{
	return 0;
}

//---------------------------------------------------------------------------
AnsiString ShortCutToText(int ShortCut)
{
	return "";
}

//---------------------------------------------------------------------------
AnsiString Trim(AnsiString S)
{
	AnsiString R;
	int b, e;
	for (b = 1; b <= S.Length() && isspace(S[b]); b++)
	{
		;
	}
	for (e = S.Length(); e > 0 && isspace(S[e]); e--)
	{
		;
	}
	for (int i = b; i <= e; i++)
	{
		R += S[i];
	}
	return R;
}
#endif

//---------------------------------------------------------------------------
#ifdef USING_NAMESPACE_EE
namespace ee {
#endif

//---------------------------------------------------------------------------
TParameter* GetParameter(TParameters &Parameters, char *Name, char *Prefix)
{
	for (unsigned int i = 0; i < Parameters.size(); i++)
	{
		if (Prefix == NULL)
		{
			if (AnsiSameText(Parameters[i].Name, Name))
			{
				return &Parameters[i];
			}
		}
		else
		{
			if (AnsiSameText(Parameters[i].Name, AnsiString(Prefix) + AnsiString(Name)))
			{
				return &Parameters[i];
			}
		}
	}
	return NULL;
}

//---------------------------------------------------------------------------
bool GetParameterHex(TParameters &Parameters, char *Name, int &Value, char *Prefix)
{
	TParameter *Parameter = GetParameter(Parameters, Name, Prefix);
	if (Parameter)
	{
		if (sscanf(Parameter->Value.c_str(), "%x", &Value) == 1)
		{
			return true;
		}
	}
	return false;
}

//---------------------------------------------------------------------------
bool GetParameterInt(TParameters &Parameters, char *Name, int &Value, char *Prefix)
{
	float FloatValue;
	if (GetParameterFloat(Parameters, Name, FloatValue, Prefix))
	{
		Value = FloatValue;
		return true;
	}
	return false;
}

//---------------------------------------------------------------------------
bool GetParameterFloat(TParameters &Parameters, char *Name, float &Value, char *Prefix)
{
	TParameter *Parameter = GetParameter(Parameters, Name, Prefix);
	if (Parameter)
	{
		AnsiString ValueStr = Parameter->Value;
		for (int i = 1; i <= ValueStr.Length(); i++)
		{
			if (ValueStr[i] == '.')
			{
				ValueStr[i] = ',';
			}
		}
		Value = StrToFloat(ValueStr);
		return true;
	}
	return false;
}

//---------------------------------------------------------------------------
bool GetParameterString(TParameters &Parameters, char *Name, AnsiString &Value, char *Prefix)
{
	TParameter *Parameter = GetParameter(Parameters, Name, Prefix);
	if (Parameter)
	{
		Value = Parameter->Value;
	}
	return Parameter;
}

#ifdef __BORLANDC__
//---------------------------------------------------------------------------
void Strings2Parameters(TStrings *Strings, TParameters &Parameters)
{
	Parameters.clear();
	for (int j = 0; j < Strings->Count; j++)
	{
		AnsiString l = Strings->Strings[j];
		int eq = l.Pos("=");
		if (eq > 0)
		{
			TParameter p;
			p.Name = l.SubString(1, eq - 1);
			p.Value = l.SubString(eq + 1, l.Length() - eq);

			if ((p.Name != "") && (p.Value != ""))
			{
				Parameters.push_back(p);
			}
		}
	}
}

//---------------------------------------------------------------------------
void Parameters2Strings(TParameters &Parameters, TStrings *Strings)
{
	Strings->Clear();
	for (unsigned int j = 0; j < Parameters.size(); j++)
	{
		Strings->Add(Parameters[j].Name + "=" + Parameters[j].Value);
	}
}
#endif

//---------------------------------------------------------------------------
AnsiString Parameters2String(const TParameters &Parameters)
{
	AnsiString String;
	for (unsigned int j = 0; j < Parameters.size(); j++)
	{
		if (String != "")
		{
			String += " ";
		}
		String += Parameters[j].Name + "=" + Parameters[j].Value;
	}
	return String;
}

//---------------------------------------------------------------------------
bool Compare(TParameters &p1, TParameters &p2, TParameterNames *Ignore)
{
	if (Ignore)
	{
		TParameters x1, x2;
		for (TParameters::iterator i = p1.begin(); i != p1.end(); i++)
		{
			if (std::find(Ignore->begin(), Ignore->end(), i->Name) == Ignore->end())
			{
				x1.push_back(*i);
			}
		}
		for (TParameters::iterator i = p2.begin(); i != p2.end(); i++)
		{
			if (std::find(Ignore->begin(), Ignore->end(), i->Name) == Ignore->end())
			{
				x2.push_back(*i);
			}
		}
		return x1 == x2;
	}
	else
	{
		return p1 == p2;
	}
}

//---------------------------------------------------------------------------
AnsiString GetParameterString(TParameters &Parameters, char *Name, char *Default, char *Prefix)
{
	AnsiString Value;
	if (GetParameterString(Parameters, Name, Value, Prefix))
	{
		return Value;
	}
	else
	{
		return Default;
	}
}

//---------------------------------------------------------------------------
#ifdef USING_NAMESPACE_EE
}
#endif

//---------------------------------------------------------------------------
#ifdef USING_NAMESPACE_EE
using namespace ee;
#endif

//---------------------------------------------------------------------------
bool operator==(const TParameters &p1, const TParameters &p2)
{
	return Parameters2String(p1) == Parameters2String(p2);
}

//---------------------------------------------------------------------------
bool operator!=(const TParameters &p1, const TParameters &p2)
{
	return !(p1 == p2);
}

//---------------------------------------------------------------------------
bool operator<(const TParameters &p1, const TParameters &p2)
{
	return Parameters2String(p1) < Parameters2String(p2);
}

//---------------------------------------------------------------------------
bool operator==(TEvent &e1, TEvent &e2)
{
	if (e1.ID != e2.ID)
	{
		return false;
	}

	if (e1.Parameters != e2.Parameters)
	{
		return false;
	}

	return true;
}

//---------------------------------------------------------------------------
#ifdef EVENTEDITOR
TStrings* operator<<(TStrings *s, TEvent &e)
{
	if (s->Count > 0)
	{
		s->Strings[0] = IntToStr(e.Time);
	}
	if (s->Count > 1)
	{
		s->Strings[1] = FormEventList->EventTypes[e.ID].Desc;
	}
	if (s->Count > 2)
	{
		s->Strings[2] = e.Text;
	}
	if (s->Count > 3)
	{
		AnsiString p;
		for (TParameters::iterator i = e.Parameters.begin(); i != e.Parameters.end(); i++)
		{
			if (p != "")
			{
				p = p + " ";
			}
			p = p + i->Name + "=" + i->Value;
		}
		s->Strings[3] = p;
	}
	return s;
}
#endif

