#pragma once

// C declarations please.
#ifdef __cplusplus
extern "C" {
#endif

#if defined(UBSHARED_EXPORTS) && defined(_WIN64)
#define UBSHARED_API_DLL_SPEC
#elif defined(UBSHARED_EXPORTS)
#define UBSHARED_API_DLL_SPEC __declspec(dllexport)
#else
#define UBSHARED_API_DLL_SPEC __declspec(dllimport)
#endif

#define UBSHARED_API(type) UBSHARED_API_DLL_SPEC type WINAPI


enum NodeType
{
	kUnread, //ROM not read
	kReadError, //ROM could not be read
	kUnknown, //To be parsed
	kFireNet,
	kMsFireNet,
	kCamera,
	kPrinter,
	kHardDisk,
	kAVC,
	kMLAN,
	kFireSpy
};

typedef struct
{
	enum NodeType type;
	char vendor[64];
	char model[64];
	char hardware[128];
	char keyword[128];
	char module[128];
	ULONG vendor_id;
	ULONG spec_id;
	ULONG sw_version;
	ULONG capabilities;
	ULONG sw_subversion;
}
C1394DeviceInfo;

#ifdef UNICODE
#define ubGetCameraImageIndex   ubGetCameraImageIndexW
#define ubGetXMLPathNameToLoad  ubGetXMLPathNameToLoadW
#define ubGetXMLPathNameToSave  ubGetXMLPathNameToSaveW
#define ubDisplayROM            ubDisplayROMW
#define ubGetAdapterDescription ubGetAdapterDescriptionW
#else
#define ubGetCameraImageIndex   ubGetCameraImageIndexA
#define ubGetXMLPathNameToLoad  ubGetXMLPathNameToLoadA
#define ubGetXMLPathNameToSave  ubGetXMLPathNameToSaveA
#define ubDisplayROM            ubDisplayROMA
#define ubGetAdapterDescription ubGetAdapterDescriptionA
#endif

UBSHARED_API(BOOL) ubInitCameraImageList();
UBSHARED_API(HIMAGELIST) ubCreateCameraImageList(ULONG a_uSize);
UBSHARED_API(ULONG) ubGetCameraImageIndexA(LPCSTR a_szCameraDescription, BYTE a_pGUID[8]);
UBSHARED_API(ULONG) ubGetCameraImageIndexW(LPCWSTR a_szCameraDescription, BYTE a_pGUID[8]);
UBSHARED_API(ULONG) ubGetXMLPathNameToLoadA(LPSTR a_szPathName, ULONG a_uPathNameLength);
UBSHARED_API(ULONG) ubGetXMLPathNameToLoadW(LPWSTR a_szPathName, ULONG a_uPathNameLength);
UBSHARED_API(ULONG) ubGetXMLPathNameToSaveA(LPCSTR a_szDefaultName, LPSTR a_szPathName, ULONG a_uPathNameLength);
UBSHARED_API(ULONG) ubGetXMLPathNameToSaveW(LPCWSTR a_szDefaultName, LPWSTR a_szPathName, ULONG a_uPathNameLength);

typedef BOOL (*READQUADLETFUNC)(void*, ULONG, DWORD*);
UBSHARED_API(BOOL) ubParseROM(READQUADLETFUNC a_pFunc, void* a_pContext, C1394DeviceInfo* a_pInfo);
UBSHARED_API(void) ubDisplayROMA(READQUADLETFUNC a_pFunc, void* a_pContext, LPCSTR a_szTitle);
UBSHARED_API(void) ubDisplayROMW(READQUADLETFUNC a_pFunc, void* a_pContext, LPCWSTR a_szTitle);

UBSHARED_API(BOOL) ubInitAdapterImageList();
UBSHARED_API(HIMAGELIST) ubCreateAdapterImageList(ULONG a_uSize);
UBSHARED_API(ULONG) ubGetAdapterImageIndex(BYTE a_pGUID[8], ULONG a_uSpeedCode);
UBSHARED_API(void) ubGetAdapterDescriptionA(BYTE a_pGUID[8], ULONG a_uSpeedCode, LPSTR a_szDescription);
UBSHARED_API(void) ubGetAdapterDescriptionW(BYTE a_pGUID[8], ULONG a_uSpeedCode, LPWSTR a_szDescription);

typedef BOOL (*GetNextCameraFunc)(LPWSTR, LPWSTR, BYTE[8], ULONG*, ULONG*);
UBSHARED_API(void*) ubCreateCameraSelector(GetNextCameraFunc a_pGetNextCameraFunc);
UBSHARED_API(BOOL) ubSelectCamera(BYTE a_pGUID[8], ULONG* a_puData);

UBSHARED_API(float) ubCalcIsoBandwidthPercentage(UCHAR a_uchTransmitSpeed, ULONG a_uPacketSize);

UBSHARED_API(BOOL) ubCRC16XORImplementation(void *a_pData, ULONG a_uDoublets, UCHAR a_CRC[2]);
UBSHARED_API(BOOL) ubCRC16CImplementation(void *a_pData, ULONG a_uQuadlets, UCHAR a_CRC[2]);
UBSHARED_API(BOOL) ubCRC16CImplementationSwapped(void *a_pData, ULONG a_uQuadlets, UCHAR a_CRC[2]);

#ifdef __cplusplus
}
#endif
