#ifndef __FIINT__
#define __FIINT__

#include <INITGUID.H>
#include "ficam.h"
#include "IYuv2Rgb.h"
#include "Camregisters.h"

#ifndef DLLEXPORT
#define DLLEXPORT __declspec(dllexport)
#endif

#ifdef __cplusplus
#ifdef DLLEXPORT
#undef DLLEXPORT
#endif
#define DLLEXPORT extern"C" __declspec(dllexport)
extern "C" {
#endif
    DEFINE_GUID(IID_FiExpoControl, 
    0x92750b52, 0x7fb7, 0x411b, 0x96, 0x30, 0x98, 0xd3, 0xda, 0xfd, 0x93, 0x49);

    MIDL_INTERFACE("92750B52-7FB7-411b-9630-98D3DAFD9349")
    FiExpoControl : public IUnknown
    {
    public:
        virtual HRESULT STDMETHODCALLTYPE GetRange(
            /* [in] */ long a_Property, 
            /* [out] */ float __RPC_FAR *a_pMin, 
            /* [out] */ float __RPC_FAR *a_pMax, 
            /* [out] */ long __RPC_FAR *a_pSteppingDelta, 
            /* [out] */ long __RPC_FAR *a_pDefault, 
            /* [out] */ long __RPC_FAR *a_pCapsFlags) = 0;
        
        virtual HRESULT STDMETHODCALLTYPE Set(
            /* [in] */ long a_Property, 
            /* [in] */ float a_lValue, 
            /* [in] */ long a_Flags) = 0;
        
        virtual HRESULT STDMETHODCALLTYPE Get(
            /* [in] */ long a_Property, 
            /* [out] */ float __RPC_FAR *a_lValue, 
            /* [out] */ long __RPC_FAR *a_Flags) = 0;

        virtual HRESULT STDMETHODCALLTYPE RelativeToAbsolute(
            /* [in] */  long  a_Property, 
            /* [in] */  float a_RelativeValue, 
            /* [out] */ float __RPC_FAR *a_AbsoluteValue) = 0;

        virtual HRESULT STDMETHODCALLTYPE AbsoluteToRelative(
            /* [in] */  long  a_Property, 
            /* [in] */  float a_AbsoluteValue, 
            /* [out] */ float __RPC_FAR *a_RelativeValue) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetAbs(
            /* [in] */  long a_Property, 
            /* [out] */ float __RPC_FAR *a_Value) = 0;

        virtual HRESULT STDMETHODCALLTYPE SetAbs(
            /* [in] */  long  a_Property, 
            /* [in] */  float a_Value) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetAbsRange(
            /* [in] */  long a_Property, 
            /* [out] */ float __RPC_FAR *a_pMin, 
            /* [out] */ float __RPC_FAR *a_pMax) = 0;
    };

    DEFINE_GUID(IID_FiColorControl, 
    0x92750b62, 0x7fb7, 0x411b, 0x96, 0x30, 0x98, 0xd3, 0xda, 0xfd, 0x93, 0x49);

    MIDL_INTERFACE("92750B62-7FB7-411b-9630-98D3DAFD9349")
    FiColorControl : public IUnknown
    {
    public:
        virtual HRESULT STDMETHODCALLTYPE GetRange(
            /* [in] */ long a_Property, 
            /* [out] */ float __RPC_FAR *a_pMin, 
            /* [out] */ float __RPC_FAR *a_pMax, 
            /* [out] */ long __RPC_FAR *a_pSteppingDelta, 
            /* [out] */ long __RPC_FAR *a_pDefault, 
            /* [out] */ long __RPC_FAR *a_pCapsFlags) = 0;
        
        virtual HRESULT STDMETHODCALLTYPE Set(
            /* [in] */ long a_Property, 
            /* [in] */ float a_lValue, 
            /* [in] */ long a_Flags) = 0;
        
        virtual HRESULT STDMETHODCALLTYPE Get(
            /* [in] */ long a_Property, 
            /* [out] */ float __RPC_FAR *a_lValue, 
            /* [out] */ long __RPC_FAR *a_Flags) = 0;
    };

    DEFINE_GUID(IID_FiBasicControl, 
    0x92750b72, 0x7fb7, 0x411b, 0x96, 0x30, 0x98, 0xd3, 0xda, 0xfd, 0x93, 0x49);

    MIDL_INTERFACE("92750B72-7FB7-411b-9630-98D3DAFD9349")
    FiBasicControl : public IUnknown
    {
    public:
        virtual HRESULT STDMETHODCALLTYPE GetRange(
            /* [in] */ long a_Property, 
            /* [out] */ float __RPC_FAR *a_pMin, 
            /* [out] */ float __RPC_FAR *a_pMax, 
            /* [out] */ long __RPC_FAR *a_pSteppingDelta, 
            /* [out] */ long __RPC_FAR *a_pDefault, 
            /* [out] */ long __RPC_FAR *a_pCapsFlags) = 0;
        
        virtual HRESULT STDMETHODCALLTYPE Set(
            /* [in] */ long a_Property, 
            /* [in] */ float a_lValue, 
            /* [in] */ long a_Flags) = 0;
        
        virtual HRESULT STDMETHODCALLTYPE Get(
            /* [in] */ long a_Property, 
            /* [out] */ float __RPC_FAR *a_lValue, 
            /* [out] */ long __RPC_FAR *a_Flags) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetAbs(
            /* [in] */  long a_Property, 
            /* [out] */ float __RPC_FAR *a_Value) = 0;

        virtual HRESULT STDMETHODCALLTYPE SetAbs(
            /* [in] */  long  a_Property, 
            /* [in] */  float a_Value) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetAbsRange(
            /* [in] */  long a_Property, 
            /* [out] */ float __RPC_FAR *a_pMin, 
            /* [out] */ float __RPC_FAR *a_pMax) = 0;
        
    };

    DEFINE_GUID(IID_FiCameraInfo, 
        0x5b44afe7, 0x6eff, 0x4b29, 0x90, 0x8b, 0x47, 0xa, 0x33, 0x27, 0xd1, 0xe7);

    MIDL_INTERFACE("5B44AFE7-6EFF-4b29-908B-470A3327D1E7")
    FiCameraInfo : public IUnknown
    {
    public:
        virtual HRESULT STDMETHODCALLTYPE GetVendorInfo(
                       Fi_VENDOR_INFO *a_pVendorInfo) = 0;
        
        virtual HRESULT STDMETHODCALLTYPE GetRegister(
            /* [in] */ long  a_Offset, 
            /* [out] */long *a_pValue) = 0;

        virtual HRESULT STDMETHODCALLTYPE SetRegister(
            /* [in] */ long  a_Offset, 
            /* [out] */long  a_Value) = 0;

        virtual HRESULT STDMETHODCALLTYPE ReadBlock(
            /* [in] */ long  a_Offset, 
            /* [in] */ long  a_NumBytesToRead, 
            /* [out] */void *a_Buffer) = 0;

        virtual HRESULT STDMETHODCALLTYPE WriteBlock(
            /* [in] */ long  a_Offset, 
            /* [in] */ long  a_NumBytesToWrite, 
            /* [out] */void *a_Buffer) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetLicenceType(FIREi_LICENCE_TYPE *a_LicenceType) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetCommandRegBase(long *a_CommandRegBase) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetAdapterInfo(FIREi_ADAPTER_INFO *a_adapterInfo) = 0;
    };

	DEFINE_GUID(IID_FiVideoFormatConfig, 
        0x63d0faf7, 0xcfbc, 0x4de5, 0xb5, 0x39, 0x5b, 0xbd, 0xf0, 0xbc, 0x7, 0x3b);

    MIDL_INTERFACE("63D0FAF7-CFBC-4de5-B539-5BBDF0BC073B")
    FiVideoFormatConfig : public IUnknown
    {
    public:
        virtual HRESULT STDMETHODCALLTYPE GetVideoFormatList(
                       Fi_VIDEO_FORMAT_INFO **a_pVideoFormatInfoList, 
                       ULONG                 *a_pFormatNum) = 0;

        virtual HRESULT STDMETHODCALLTYPE FreeVideoFormatList(
                       Fi_VIDEO_FORMAT_INFO *a_pVideoFormatInfoList) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetDefaultFormat(
                       ULONG *a_DefaultFormatIdx) = 0;

        virtual HRESULT STDMETHODCALLTYPE SetDefaultFormat(
                       ULONG a_DefaultFormatIdx) = 0;

        virtual HRESULT STDMETHODCALLTYPE SetupVideoFormat(
                       ULONG             a_FormatIdx, 
                       VIDEOINFOHEADER  *a_pVideoInfoHeader) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetF7PacketInfo(
                       ULONG    a_FormatIdx, 
                       ULONG   *a_UnitPacketSize, 
                       ULONG   *a_MaxPacketSize) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetF7PacketSize(
                       ULONG    a_FormatIdx, 
                       ULONG   *a_PacketSize) = 0;

        virtual HRESULT STDMETHODCALLTYPE SetF7PacketSize(
                       ULONG    a_FormatIdx, 
                       ULONG    a_PacketSize) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetCurrentFps(
                       ULONG        a_FormatIdx, 
                       FIREi_FPS   *a_CurrentFps) = 0;

        virtual HRESULT STDMETHODCALLTYPE SetCurrentFps(
                       ULONG        a_FormatIdx, 
                       FIREi_FPS    a_CurrentFps) = 0;

        virtual HRESULT STDMETHODCALLTYPE Enable16BitSwap(
                       BOOL a_enable) = 0;

        virtual HRESULT STDMETHODCALLTYPE Is16BitSwapEnabled(
                       BOOL *a_enable) = 0;

        virtual HRESULT STDMETHODCALLTYPE SetCustomRect(
                       ULONG  a_formatIndex, 
                       RECT  &a_customRect) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetCustomRect(
                       ULONG  a_formatIndex, 
                       RECT  *a_customRect) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetF7ColorFilter(
                       ULONG    a_FormatIdx, 
                       ULONG   *a_ColorFilterID) = 0;
    };

    // {F417116D-D17E-42e6-A2E3-065A390BFAB1}
    DEFINE_GUID(IID_FiNetDump, 
        0xf417116d, 0xd17e, 0x42e6, 0xa2, 0xe3, 0x6, 0x5a, 0x39, 0xb, 0xfa, 0xb1);

    MIDL_INTERFACE("F417116D-D17E-42e6-A2E3-065A390BFAB1")
    FiNetDump : public IUnknown
    {
    public:
        virtual HRESULT STDMETHODCALLTYPE GetProfileDescription(
                       unsigned long    a_ProfileIndex, 
                       WCHAR*           a_ProfileDescription, 
                       unsigned long   *a_DescriptionLength) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetProfileName(
                       unsigned long  a_ProfileIndex, 
                       WCHAR         *a_ProfileName, 
                       unsigned long *a_NameLength) = 0;

        virtual HRESULT STDMETHODCALLTYPE SetProfile(
                       unsigned long a_ProfileIndex) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetProfile(
                       unsigned long *a_ProfileIndex) = 0;

        virtual HRESULT STDMETHODCALLTYPE GetXmitPort(
                       unsigned long *a_XmitPort) = 0;

        virtual HRESULT STDMETHODCALLTYPE SetXmitPort(
                       unsigned long a_XmitPort) = 0;
    };

    // {87F4BFE4-47F3-44cf-A1BF-1882FC973232}
    DEFINE_GUID(IID_FiNetRcv, 
        0x87f4bfe4, 0x47f3, 0x44cf, 0xa1, 0xbf, 0x18, 0x82, 0xfc, 0x97, 0x32, 0x32);

    MIDL_INTERFACE("87F4BFE4-47F3-44cf-A1BF-1882FC973232")
    FiNetRcv : public IUnknown
    {
    public:
        virtual HRESULT STDMETHODCALLTYPE SetURL(WCHAR* a_URL) = 0;
        virtual HRESULT STDMETHODCALLTYPE GetImageSize(SIZE *a_ImageSize) = 0;

    };

#ifdef __cplusplus
}
#endif

#endif // __FIINT__


