#ifndef _IYUV2RGB_H_
#define _IYUV2RGB_H_

#include <initguid.h>

#ifdef __cplusplus
extern "C" {
#endif
    // {92DCFFA8-C116-49a0-ABAE-6DEFD03FECA2}
    DEFINE_GUID(IID_Iyuv2rgb,
    0x92dcffa8, 0xc116, 0x49a0, 0xab, 0xae, 0x6d, 0xef, 0xd0, 0x3f, 0xec, 0xa2);

    DECLARE_INTERFACE_(Iyuv2rgb, IUnknown)
    {
        STDMETHOD(EnableOverlays) (THIS_
                  BOOL a_bEnable) PURE;

        STDMETHOD(IsEnabledOverlay) (THIS_
                BOOL *a_bEnable)PURE;

        STDMETHOD(GetNextFrameBuffer) (THIS_
                  long *a_FrameSize, long *a_pFrameBuffer, FIREi_PIXEL_FORMAT a_pFormat )PURE;

        STDMETHOD(SaveFrameSequence) (THIS_
                  unsigned long a_uFrames, CHAR* a_pszSavePath, unsigned long a_uFlags) PURE;

        STDMETHOD(SaveNextFrame) (THIS_
                  CHAR* a_pszSavePath, GUID *a_encoderClsid) PURE;

        STDMETHOD(SetRawMode) (THIS_
                  FIREi_RAW_MODE a_RawMode )PURE;

        STDMETHOD(GetRawMode) (THIS_
                  FIREi_RAW_MODE *a_RawMode )PURE;

        STDMETHOD(SetRawModeConversion) (THIS_
                  FIREi_RAW_MODE_CONVERSION a_RawModeConversion )PURE;

        STDMETHOD(GetRawModeConversion) (THIS_
                  FIREi_RAW_MODE_CONVERSION *a_RawModeConversion )PURE;

        STDMETHOD(SetRawConversionCoefficients)(THIS_
            float a_RCoeff, float a_GCoeff, float a_BCoeff)PURE;

        STDMETHOD(SetCallback)(THIS_
            YuvToRgbCallback a_callback, FIREi_PIXEL_FORMAT a_format, void * a_context)PURE;

        STDMETHOD(SetYMono16SignificantBits)(THIS_
            int a_numSignificantBits)PURE;

        STDMETHOD(GetYMono16SignificantBits)(THIS_
            int *a_numSignificantBits)PURE;
    };
#ifdef __cplusplus
}
#endif

#endif // _IYUV2RGB_H_