//---------------------------------------------------------------------------
//	AVFile - library for audio and video files processing
//	2002 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//
//	fffilei.h
//	ffmpeg file reader and writer
//---------------------------------------------------------------------------

#ifndef _FFFILEI_H
#define _FFFILEI_H

#include <queue>
#ifdef __BORLANDC__
//#define EMULATE_INTTYPES
//#pragma option push -b
extern "C"
{
#include "avformat.h"
}
//#pragma option pop
#else
#include "avformat.h"
#endif

#ifndef PIX_FMT_RGBA32
#define PIX_FMT_RGBA32 PIX_FMT_RGB32
#endif

class TFFFileI
{
public:
	typedef std::queue<AVPacket*> AVPackets;

	AVFormatContext *ic, *oc;
	int AudioIndex, VideoIndex;
	AVStream *audio_st, *video_st;
	AVPackets AudioPackets, VideoPackets;
	int64_t VideoStreamStart;

	TFFFileI();
	AVStream* AddVideoStream(AVFormatContext *oc, int Codec, int Width, int Height, int Rate, int Scale, int KeyFrame, int BitRate);
	AVStream* AddAudioStream(AVFormatContext *oc, int Codec, int Rate, int Channels, int BitRate);
	bool OpenVideo(AVFormatContext *oc, AVStream *Stream);
	bool OpenAudio(AVFormatContext *oc, AVStream *Stream);
	AVFrame* AllocPicture(int Format, int Width, int Height, uint8_t *Buffer = NULL);
	void FlushQueues();
	AVCodec* OpenCodec(AVCodecContext *cc);
};

#endif

