//---------------------------------------------------------------------------
//	AVFile - library for audio and video files processing
//	2002 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//
//	dsfilei.h
//	DirectShow internal class
//---------------------------------------------------------------------------

#ifndef _DSFILEI_H
#define _DSFILEI_H

#include "dshow_hack.h"

#ifdef __BORLANDC__
#include "SampleGrabberCB.h"
#else
#include <Ocidl.h>
#endif

#include <string>

//---------------------------------------------------------------------------
extern const GUID CLSID_SampleGrabber;
extern const GUID IID_ISampleGrabber;
extern const GUID IID_ISampleGrabberCB;
extern const GUID CLSID_NullRenderer;
extern const GUID CLSID_Deinterlace;
extern const GUID CLSID_RTSPSource;
extern const GUID CLSID_MoonlightDemuxer;

//---------------------------------------------------------------------------
class TDSFileI
{
public:
	CComPtr<IGraphBuilder> pGraph;
	CComPtr<ICaptureGraphBuilder2> pBilder;
	CComPtr<ISampleGrabber> pVideoGrabber, pAudioGrabber, pGrabber;
	CComQIPtr<IMediaControl, &IID_IMediaControl> pControl;
	CComQIPtr<IMediaSeeking, &IID_IMediaSeeking> pSeeking;
	CComQIPtr<IMediaEvent, &IID_IMediaEvent> pMediaEvent;
#ifdef __BORLANDC__
	TSampleGrabberCB *VideoCB, *AudioCB;
#endif
	DWORD g_dwGraphRegister, g_dwAudioGraphRegister;

	HRESULT AddGraphToRot(IUnknown *pUnkGraph, DWORD *pdwRegister);
	void RemoveGraphFromRot(DWORD pdwRegister);

	std::string GetDevice(IPropertyBag *pPropBag, int &UnknownCount);

	HRESULT GetPin(IBaseFilter *pFilter, PIN_DIRECTION dirrequired, int iNum, IPin **ppPin);
	IPin* GetInPin(IBaseFilter *pFilter, int Num);
	IPin* GetOutPin(IBaseFilter *pFilter, int Num);
	IPin* WaitForPin(IBaseFilter *pFilter, PIN_DIRECTION dirrequired, int Num, int MSecs);
};

#endif

