//---------------------------------------------------------------------------
//	AVFile - library for audio and video files processing
//	2002 - 2005 Stanislav Sumec <sumec@fit.vutbr.cz>
//
//	SampleGrabberCB.h
//	DirectShow sample grabber callback
//---------------------------------------------------------------------------

#ifndef SAMPLEGRABBERCB_H
#define SAMPLEGRABBERCB_H

#include <deque>
#include <SyncObjs.hpp>
#pragma option push -VF -VM

//---------------------------------------------------------------------------
class TBuffer
{
private:
	void* GetMem(size_t Size);
	void FreeMem(void *Mem);

public:
	double SampleTime;
	BYTE *pBuffer;
	long BufferSize;
	TBuffer();
	TBuffer(double SampleTime, BYTE *pBuffer, long BufferSize);
	TBuffer(const TBuffer &Buffer);
	~TBuffer();
	TBuffer& operator =(TBuffer& Buffer);
	TBuffer& operator =(TBuffer Buffer);
};

//---------------------------------------------------------------------------
class TBuffers
{
private:
	TCriticalSection *CS;
	std::deque<TBuffer*> Buffers;

public:
	HANDLE Event;
	TBuffers();
	~TBuffers();
	void push_back(TBuffer *Buffer);
	TBuffer* pop_front();
	TBuffer* pop_back();
	void clear();
	bool empty();
	size_t size();
	void Enter();
	void Leave();
};

//---------------------------------------------------------------------------
class TSampleGrabberCB: public ISampleGrabberCB
{
private:
	TCriticalSection *CS;
	int Drop, Counter;

public:
	TBuffers Buffers;
	TSampleGrabberCB();
	~TSampleGrabberCB();

	STDMETHODIMP_(ULONG) AddRef();
	STDMETHODIMP_(ULONG) Release();
	STDMETHODIMP QueryInterface(REFIID riid, void ** ppv);
	STDMETHODIMP SampleCB(double SampleTime, IMediaSample *pSample);
	STDMETHODIMP BufferCB(double SampleTime, BYTE *pBuffer, long BufferSize);

	void SetDrop(int Drop);
	int IncDrop(int Increment);
	int GetDrop();
};
#pragma option pop

#endif

