//---------------------------------------------------------------------------
//	AVFile - library for audio and video files processing
//	2002 - 2005 Stanislav Sumec <sumec@fit.vutbr.cz>
//
//	SampleGrabberCB.cpp
//	DirectShow sample grabber callback
//
//	10.2.2004
//		- first release
//---------------------------------------------------------------------------

#include "dshow_hack.h"
#include "BaseClasses_hack.h"
#pragma hdrstop
#include "SampleGrabberCB.h"
#pragma option push -VF -VM

//---------------------------------------------------------------------------
TBuffer::TBuffer()
{
	SampleTime = 0;
	pBuffer = NULL;
	BufferSize = 0;
}

//---------------------------------------------------------------------------
TBuffer::TBuffer(double SampleTime, BYTE *pBuffer, long BufferSize)
{
	this->SampleTime = SampleTime;
	this->BufferSize = BufferSize;
	this->pBuffer = (BYTE*)GetMem(BufferSize);
	if (this->pBuffer)
	{
		memcpy(this->pBuffer, pBuffer, BufferSize);
	}
}

//---------------------------------------------------------------------------
TBuffer::TBuffer(const TBuffer &Buffer)
{
	SampleTime = Buffer.SampleTime;
	BufferSize = Buffer.BufferSize;
	if (Buffer.pBuffer)
	{
		pBuffer = (BYTE*)GetMem(Buffer.BufferSize);
		if (pBuffer)
		{
			memcpy(pBuffer, Buffer.pBuffer, Buffer.BufferSize);
		}
	}
	else
	{
		pBuffer = NULL;
	}
}

//---------------------------------------------------------------------------
TBuffer& TBuffer::operator =(TBuffer& Buffer)
{
	SampleTime = Buffer.SampleTime;
	BufferSize = Buffer.BufferSize;
	if (pBuffer)
	{
		FreeMem(pBuffer);
		pBuffer = NULL;
	}
	if (Buffer.pBuffer)
	{
		pBuffer = (BYTE*)GetMem(Buffer.BufferSize);
		if (pBuffer)
		{
			memcpy(pBuffer, Buffer.pBuffer, Buffer.BufferSize);
		}
	}
	else
	{
		pBuffer = NULL;
	}
	return *this;
}

//---------------------------------------------------------------------------
TBuffer& TBuffer::operator =(TBuffer Buffer)
{
	SampleTime = Buffer.SampleTime;
	BufferSize = Buffer.BufferSize;
	if (pBuffer)
	{
		FreeMem(pBuffer);
		pBuffer = NULL;
	}
	if (Buffer.pBuffer)
	{
		pBuffer = (BYTE*)GetMem(Buffer.BufferSize);
		if (pBuffer)
		{
			memcpy(pBuffer, Buffer.pBuffer, Buffer.BufferSize);
		}
	}
	else
	{
		pBuffer = NULL;
	}
	return *this;
}

//---------------------------------------------------------------------------
TBuffer::~TBuffer()
{
	if (pBuffer)
	{
		FreeMem(pBuffer);
	}
}

//---------------------------------------------------------------------------
void* TBuffer::GetMem(size_t Size)
{
	return (void*)GlobalAlloc(GMEM_FIXED, Size);
}

//--------------------------------------------------------------------------
void TBuffer::FreeMem(void *Mem)
{
	GlobalFree(HGLOBAL(Mem));
}


//---------------------------------------------------------------------------
TBuffers::TBuffers()
{
	Event = CreateEvent(NULL, TRUE, FALSE, NULL);
	if (Event == NULL)
	{
		throw Exception("CreateEvent failed!"); 
	}
	CS = new TCriticalSection();
}

//---------------------------------------------------------------------------
TBuffers::~TBuffers()
{
	clear();
	CloseHandle(Event);
	delete CS;
}

//---------------------------------------------------------------------------
void TBuffers::clear()
{
	CS->Enter();
	while (!Buffers.empty())
	{
		delete Buffers.front();
		Buffers.pop_front();
	}
	ResetEvent(Event);
	CS->Leave();
}

//---------------------------------------------------------------------------
void TBuffers::push_back(TBuffer *Buffer)
{
	CS->Enter();
	Buffers.push_back(Buffer);
	SetEvent(Event);
	CS->Leave();
}

//---------------------------------------------------------------------------
TBuffer* TBuffers::pop_front()
{
	CS->Enter();
	TBuffer *Buffer = Buffers.front();
	Buffers.pop_front();
	if (Buffers.empty())
	{
		ResetEvent(Event);
	}
	CS->Leave();
	return Buffer;
}

//---------------------------------------------------------------------------
TBuffer* TBuffers::pop_back()
{
	CS->Enter();
	TBuffer *Buffer = Buffers.back();
	Buffers.pop_back();
	if (Buffers.empty())
	{
		ResetEvent(Event);
	}
	CS->Leave();
	return Buffer;
}

//---------------------------------------------------------------------------
bool TBuffers::empty()
{
	CS->Enter();
	bool Empty = Buffers.empty();
	CS->Leave();
	return Empty;
}

//---------------------------------------------------------------------------
size_t TBuffers::size()
{
	CS->Enter();
	size_t Size = Buffers.size();
	CS->Leave();
	return Size;
}

//---------------------------------------------------------------------------
void TBuffers::Enter()
{
	CS->Enter();
}

//---------------------------------------------------------------------------
void TBuffers::Leave()
{
	CS->Leave();
}

//---------------------------------------------------------------------------
TSampleGrabberCB::TSampleGrabberCB()
{
	Drop = Counter = 0;
	CS = new TCriticalSection();
}

//---------------------------------------------------------------------------
void TSampleGrabberCB::SetDrop(int Drop)
{
	CS->Enter();
	if (Drop < 0)
	{
		Drop = 0;
	}
	this->Drop = Drop;
	CS->Leave();
}

//---------------------------------------------------------------------------
int TSampleGrabberCB::IncDrop(int Increment)
{
	CS->Enter();
	Drop += Increment;
	if (Drop < 0)
	{
		Drop = 0;
	}
	int Temp = Drop;
	CS->Leave();
	return Temp; 
};

//---------------------------------------------------------------------------
int TSampleGrabberCB::GetDrop() 
{
	CS->Enter();
	int Temp = Drop;
	CS->Leave();
	return Temp;
}

//---------------------------------------------------------------------------
TSampleGrabberCB::~TSampleGrabberCB()
{
	delete CS;
}

//---------------------------------------------------------------------------
STDMETHODIMP_(ULONG) TSampleGrabberCB::AddRef()
{
	return 2;
}

//---------------------------------------------------------------------------
STDMETHODIMP_(ULONG) TSampleGrabberCB::Release()
{
	return 1;
}

//---------------------------------------------------------------------------
STDMETHODIMP TSampleGrabberCB::QueryInterface(REFIID riid, void ** ppv)
{
	CheckPointer(ppv, E_POINTER);
	if (riid == IID_ISampleGrabberCB || riid == IID_IUnknown)
	{
		*ppv = (void *) static_cast<ISampleGrabberCB*> ( this );
		return NOERROR;
	}
	return E_NOINTERFACE;
}

//---------------------------------------------------------------------------
STDMETHODIMP TSampleGrabberCB::SampleCB(double SampleTime, IMediaSample *pSample)
{
	return 0;
}

//---------------------------------------------------------------------------
STDMETHODIMP TSampleGrabberCB::BufferCB(double SampleTime, BYTE *pBuffer, long BufferSize)
{
	CS->Enter();
	if (Counter >= Drop)
	{
		Buffers.push_back(new TBuffer(SampleTime, pBuffer, BufferSize));
		Counter = 0;
	}
	else
	{
		Counter++;
	}
	CS->Leave();
	return 0;
}

#pragma option pop

