#ifndef _CAMERADLLHANDLER_H
#define _CAMERADLLHANDLER_H

#include <windows.h>

typedef void (*PVOIDFUNC)();
typedef void (*PCONTROLFUNC)(int);
typedef unsigned long (*PULONGFUNC)();
typedef unsigned long (*PULONGINTFUNC)(int);
typedef unsigned int (*PUINTINTFUNC)(int); 

typedef bool (*PADDCAMERAFUNC)(const char*, int);
typedef void (*PGETXFRAMEFUNC)(int, BYTE*, unsigned int*, unsigned int*);
typedef void (*PGETFRAMEFUNC)(int, unsigned long, BYTE*, unsigned int*, unsigned int*);


class TCameraDllHandler
{
private:
	HINSTANCE hDllHandle;
	bool Initialized;

	//---------------------------- DLL exports
	PVOIDFUNC DllInit;
	PCONTROLFUNC DllStartCamera;
	PVOIDFUNC DllStartAll;
	PCONTROLFUNC DllStopCamera;
	PVOIDFUNC DllStopAll;
	PVOIDFUNC DllTerminate;

	PULONGFUNC DllGetCamerasFound;
	PULONGFUNC DllGetCamerasCount;

	PULONGINTFUNC DllGetFrameSize;
	PULONGINTFUNC DllGetLastFrameIndex;

	PUINTINTFUNC DllGetFrameWidth;
	PUINTINTFUNC DllGetFrameHeight;

	PADDCAMERAFUNC DllAddCamera;
	PGETXFRAMEFUNC DllGetFirstFrame;
	PGETXFRAMEFUNC DllGetLastFrame;
	PGETFRAMEFUNC DllGetFrame;
	//----------------------------------------
	void Setup();

public:
	bool IsOK;

	TCameraDllHandler();
	~TCameraDllHandler();

	void Init();
	void StartCamera(int camera);
	void StartAll();
	void StopCamera(int camera);
	void StopAll();
	void Terminate();

	unsigned long GetCamerasFound();
	unsigned long GetCamerasCount();

	unsigned long GetFrameSize(int camera);
	unsigned long GetLastFrameIndex(int camera);

	unsigned int GetFrameWidth(int camera);
	unsigned int GetFrameHeight(int camera);

	bool AddCamera(const char *fileName, int camera);
	void GetFirstFrame(int camera, BYTE* data, unsigned int* width, unsigned int* height);
	void GetLastFrame(int camera, BYTE* data, unsigned int* width, unsigned int* height);
	void GetFrame(int camera, unsigned long frame, BYTE* data, unsigned int* width, unsigned int* height);
};


static TCameraDllHandler	*CameraDll = new TCameraDllHandler();

#endif

