
#include <stdio.h>

#include "CameraDllHandler.h"


TCameraDllHandler::TCameraDllHandler()
{
	IsOK = false;
	Initialized = false;
}


TCameraDllHandler::~TCameraDllHandler()
{
	Terminate();
	// close dll library
	FreeModule((HMODULE)hDllHandle);
}


void TCameraDllHandler::Setup()
{
	if (!Initialized)
	{
		// open dll library
		hDllHandle = LoadLibrary("CameraDll.dll");
		if (hDllHandle == NULL)
		{
//		char err[128];
//		sprintf(err, "Error: %d\n", GetLastError());
//		MessageBox(NULL, err, "Error", MB_OK);
			return;
		}

		// get functions addresses
		DllInit = (PVOIDFUNC)GetProcAddress(hDllHandle, "Init");
		DllStartCamera = (PCONTROLFUNC)GetProcAddress(hDllHandle, "StartCamera");
		DllStartAll = (PVOIDFUNC)GetProcAddress(hDllHandle, "StartAll");
		DllStopCamera = (PCONTROLFUNC)GetProcAddress(hDllHandle, "StopCamera");
		DllStopAll = (PVOIDFUNC)GetProcAddress(hDllHandle, "StopAll");
		DllTerminate = (PVOIDFUNC)GetProcAddress(hDllHandle, "Terminate");
		DllGetCamerasFound = (PULONGFUNC)GetProcAddress(hDllHandle, "GetCamerasFound");
		DllGetCamerasCount = (PULONGFUNC)GetProcAddress(hDllHandle, "GetCamerasCount");
		DllGetFrameSize = (PULONGINTFUNC)GetProcAddress(hDllHandle, "GetFrameSize");
		DllGetLastFrameIndex = (PULONGINTFUNC)GetProcAddress(hDllHandle, "GetLastFrameIndex");
		DllGetFrameWidth = (PUINTINTFUNC)GetProcAddress(hDllHandle, "GetFrameWidth");
		DllGetFrameHeight = (PUINTINTFUNC)GetProcAddress(hDllHandle, "GetFrameHeight");
		DllAddCamera = (PADDCAMERAFUNC)GetProcAddress(hDllHandle, "AddCamera");
		DllGetFirstFrame = (PGETXFRAMEFUNC)GetProcAddress(hDllHandle, "GetFirstFrame");
		DllGetLastFrame = (PGETXFRAMEFUNC)GetProcAddress(hDllHandle, "GetLastFrame");
		DllGetFrame = (PGETFRAMEFUNC)GetProcAddress(hDllHandle, "GetFrame");

		IsOK = ((DllInit != NULL) && (DllStartAll != NULL) && (DllStopAll != NULL) &&
				(DllTerminate != NULL) && (DllGetCamerasFound != NULL) &&
				(DllGetCamerasCount != NULL) && (DllAddCamera != NULL) &&
				(DllGetFirstFrame != NULL) && (DllGetLastFrame != NULL) &&
				(DllGetFrame != NULL) && (DllStartCamera != NULL) &&
				(DllStopCamera != NULL) && (DllGetFrameSize != NULL) &&
				(DllGetLastFrameIndex != NULL) && (DllGetFrameWidth != NULL) &&
				(DllGetFrameHeight != NULL));
		Initialized = true;
	}
}


void TCameraDllHandler::Init()
{
	Setup();
	if (DllInit != NULL)
	{
		DllInit();
	}
}


void TCameraDllHandler::StartAll()
{
	Setup();
	if (DllStartAll != NULL)
	{
		DllStartAll();
	}
}


void TCameraDllHandler::StopAll()
{
	Setup();
	if (DllStopAll != NULL)
	{
		DllStopAll();
	}
}


void TCameraDllHandler::StartCamera(int camera)
{
	Setup();
	if (DllStartCamera != NULL)
	{
		DllStartCamera(camera);
	}
}


void TCameraDllHandler::StopCamera(int camera)
{
	Setup();
	if (DllStopCamera != NULL)
	{
		DllStopCamera(camera);
	}
}


void TCameraDllHandler::Terminate()
{
	Setup();
	if (DllTerminate != NULL)
	{
		DllTerminate();
	}
}


unsigned long TCameraDllHandler::GetCamerasFound()
{
	Setup();
	return (DllGetCamerasFound != NULL) ? DllGetCamerasFound() : 0;
}


unsigned long TCameraDllHandler::GetCamerasCount()
{
	Setup();
	return (DllGetCamerasCount != NULL) ? DllGetCamerasCount() : 0;
}


unsigned long TCameraDllHandler::GetFrameSize(int camera)
{
	Setup();
	return (DllGetFrameSize != NULL) ? DllGetFrameSize(camera) : 0;
}


unsigned long TCameraDllHandler::GetLastFrameIndex(int camera)
{
	Setup();
	return (DllGetLastFrameIndex != NULL) ? DllGetLastFrameIndex(camera) : 0;
}


unsigned int TCameraDllHandler::GetFrameWidth(int camera)
{
	Setup();
	return (DllGetFrameWidth != NULL) ? DllGetFrameWidth(camera) : 0;
}


unsigned int TCameraDllHandler::GetFrameHeight(int camera)
{
	Setup();
	return (DllGetFrameHeight != NULL) ? DllGetFrameHeight(camera) : 0;
}


bool TCameraDllHandler::AddCamera(const char *fileName, int camera)
{
	Setup();
	return (DllAddCamera != NULL) ? DllAddCamera(fileName, camera) : false;
}


void TCameraDllHandler::GetFirstFrame(int camera, BYTE* data,
	unsigned int* width, unsigned int* height)
{
	Setup();
	if (DllGetFirstFrame != NULL)
	{
		DllGetFirstFrame(camera, (BYTE*)data, width, height);
	}
	else
	{
		data = NULL;
		*width = 0;
		*height = 0;
	}
}


void TCameraDllHandler::GetLastFrame(int camera, BYTE* data,
	unsigned int* width, unsigned int* height)
{
	Setup();
	if (DllGetLastFrame != NULL)
	{
		DllGetLastFrame(camera, (BYTE*)data, width, height);
	}
	else
	{
		*width = 0;
		*height = 0;
	}
}


void TCameraDllHandler::GetFrame(int camera, unsigned long frame,
	BYTE* data, unsigned int* width, unsigned int* height)
{
	Setup();
	if (DllGetFrame != NULL)
	{
		DllGetFrame(camera, frame, data, width, height);
	}
	else
	{
		*width = 0;
		*height = 0;
	}
}

