//---------------------------------------------------------------------------
//	AVFile - library for audio and video files processing
//  2002 - 2005 Stanislav Sumec <sumec@fit.vutbr.cz>
//
//	types.h
//  auxiliary types
//---------------------------------------------------------------------------

#ifndef _TYPES_H
#define _TYPES_H

#define DIB_SCAN_LINE(WIDTH) (((WIDTH) & 0xfffffffc) + (((WIDTH) & 0x3) ? 4 : 0))

#if defined(_WIN32) || defined(WIN32)

#ifdef __BORLANDC__
# pragma pack(push, 1)
#endif

#include <windows.h>

#ifdef __BORLANDC__
# pragma pack(pop)
#endif

#else
#pragma pack (2)

typedef unsigned long   DWORD;
typedef int             BOOL;
typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef long            LONG;

#define BI_RGB          0L

typedef struct tagBITMAPINFOHEADER
{ // bmih
	DWORD  biSize;
	LONG   biWidth;
	LONG   biHeight;
	WORD   biPlanes;
	WORD   biBitCount;
	DWORD  biCompression;
	DWORD  biSizeImage;
	LONG   biXPelsPerMeter;
	LONG   biYPelsPerMeter;
	DWORD  biClrUsed;
	DWORD  biClrImportant;
}
BITMAPINFOHEADER;

typedef struct tagRGBQUAD
{ // rgbq
	BYTE  rgbBlue;
	BYTE  rgbGreen;
	BYTE  rgbRed;
	BYTE  rgbReserved;
}
RGBQUAD;

typedef struct tagBITMAPINFO
{ // bmi
	BITMAPINFOHEADER  bmiHeader;
	RGBQUAD           bmiColors[1];
}
BITMAPINFO;

typedef struct tagBITMAPFILEHEADER
{ // bmfh
	WORD    bfType;
	DWORD   bfSize;
	WORD    bfReserved1;
	WORD    bfReserved2;
	DWORD   bfOffBits;
}
BITMAPFILEHEADER;

#pragma pack ()
#endif

#endif

