//---------------------------------------------------------------------------
//	AVFile - library for audio and video files processing
//	2002 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//
//	dvfile.h
//	DV camera input
//---------------------------------------------------------------------------

#ifndef _DVFILE_H
#define _DVFILE_H

#include <string>
#include <vector>
#include "avfile.h"

//---------------------------------------------------------------------------
class TDSFileI;

//---------------------------------------------------------------------------
class TDVFile: public TAVFile
{
public:
	typedef std::string TDevice;
	typedef std::vector<TDevice> TDevices;

private:
	TDSFileI *Internal;
	bool CoInitialized, FirstFrame;

	unsigned int ScanLineWidth, AlignedScanLineWidth, BitmapDataSize;
	unsigned int Length, FrameInBuffer;
	DWORD g_dwGraphRegister;

	BITMAPINFO *Bitmap;
	BYTE *BitmapData, *FrameBuffer;

protected:
	void OpenA(const char *FileName, int Mode, int Type, bool ThrowExceptions);
	BYTE* GetFrameA();
	void GetFrameA2(BYTE *Buffer);
	BITMAPINFO* DIBGetFrameA();

public:
	TDVFile();
	~TDVFile();

	void Close();
	unsigned int GetVideoLength();
	TDevices GetDevices();
};

#endif

