//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

#ifndef _CAMFILE_H
#define _CAMFILE_H

#include <string>
#include "avfile.h"
#include "CameraDllHandler.h"


class TCAMFile: public TAVFile
{
private:
	unsigned int ScanLineWidth, AlignedScanLineWidth;
	unsigned int FrameInBuffer;

	BITMAPINFO *Bitmap;
	BYTE *FrameBuffer;

	int nCamera;

protected:
	void OpenA(const char *FileName, int Mode = omRead, int Type = otVideo, bool ThrowExceptions = false);
	BITMAPINFO* DIBGetFrameA();
	BITMAPINFO* DIBGetFrameB(unsigned int Position);
	BYTE* GetFrameA();
	void GetFrameA2(BYTE *Buffer);
	BYTE* GetFrameB(unsigned int Position);
	void GetFrameB2(BYTE *Buffer, unsigned int Position);

public:
	TCAMFile();
	TCAMFile(int camera);
	~TCAMFile();

	void InitCamera(int camera);
	void Close();
	void Seek(unsigned int Frame);

	unsigned int GetVideoLength();
};

#endif

